#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void ContPlots (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct cont_info cinfo;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *Ws;

   void   *Xx, *Yy;
   ReaL_4 *X, *Y, *V, *N;
   ReaL_4 Bad;
   ByTe_4 K, TotP, pN, nP, PN;
   ByTe_2 rV;
   ByTe_1 New;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;
   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S = (struct SrcInfo *)Pd->Src;                      /* pntr to first src  */
   nP = S->Col.N;                                      /* num of collapses   */
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   PopUpCBar (PNuM);                                   /* colorbar           */

   K = 0;                                              /* 1st plot in series */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      TimeAlign (PN, K, 0);
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1);
      if ((Pd->PStat == 0 && rV == 0) || 
             (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */

      if (Pd->PStat == 0 && CanIgn) {                  /* BEG IGNORE EMPTIES */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */ 
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */ 
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */ 
         IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, 1); /* next plot tms */
         continue;                                          /* try the next  */
      }                                                /* END IGNORE EMPTIES */

      New = 1;                                         /* new tool data      */
      Ws = (ReaL_4 *)Wa.WorkSpace;                     /* ptr to plot data   */
      FormEdges (PN, &Yy, 'Y', 1, 1);                  /* form Y bin edges   */
      FormEdges (PN, &Xx, 'X', 1, 1);                  /* form X bin edges   */
      X = (ReaL_4 *)Xx;                                /* X edges            */
      Y = (ReaL_4 *)Yy;                                /* Y edges            */

      XferContour(PN, 0, New);                         /* cont struc inits   */

      Bad = 10.0 * cinfo.Utol;                         /* out of limits      */
      for (pN = 0; pN < nP; ++pN)                      /* collapse plot loop */
      {                                                /* BEG CONT PLOT LOOP */
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             V = Ws + 2 * Pd->PlotLen * pN;            /* base plot position */
             N = V + Pd->PlotLen;                      /* base norm position */
             Normalize (V, N, Pd->PlotLen, 1, Bad);    /* normalize data     */
          }                                            /* END NON EMPTY PLOT */
          if (Pd->OutFmt == 0)                         /* cartesian output   */
             SetUpRecPlot (PN, K, 0);                  /* set up plot        */
          else                                         /* carteographic      */
             SetUpMapPlot (PN, K);                     /* set up plot        */
          if (Pd->CCut != 0 || Pd->LSCut != 0)         /* Cut plot defined   */
             SetUpRecPlot (PN, K, 1);                  /* set up plot        */
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             PopUpPlot (PN, 1, 0);                     /* plot box and text  */
             PlotCut (PN, 0);                          /* plot cuts          */
             MkContour (Pd->Wn, V, X, Y, X, Pd->PlotLen); /* make plot       */
             PlotCut (PN, 1);                          /* plot cuts          */
          }                                            /* END NON EMPTY PLOT */
          PopUpPlot (PN, 0, 1);                        /* plot box and text  */
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             Tools (PN, 0, 1, New, pN);                /* vector plot tool   */
             Tools (PN, 0, 3, New, pN);                /* Draw Globe         */
             Tools (PN, 0, 4, New, pN);                /* Draw Globe         */
             New = 0;                                  /* hold vector data   */
          }                                            /* END NON EMPTY PLOT */
          PlotText (PNuM, 0, K, 0, 0);                 /* Per Plot Labels    */
          if (Pd->OutFmt == 0)                         /* cartesian output   */
             AxisLabs (PN, K++, 0);                    /* axis labels        */
          else                                         /* carteographic      */
             ++K;                                      /* just advance plot  */
      }                                                /* END CONT PLOT LOOP */
      ZeroWkSp();                                      /* clear plot arrays  */
      if (CanIgn) {                                    /* BEG RESET TIME     */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */
      }                                                /* END RESET TIME     */

      if (Pd->Tm.Fmt != 0) {
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else 
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, CanIgn);
      }

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */

   if (Xx != 0) {                                      /* BEG FREE X MEM     */
      free (Xx);                                       /* let it go          */
      Xx = 0;                                          /* free at last       */
   }                                                   /* END FREE X MEM     */
   if (Yy != 0) {                                      /* BEG FREE Y MEM     */
      free (Yy);                                       /* let it go          */
      Yy = 0;                                          /* free at last       */
   }                                                   /* END FREE Y MEM     */
}
