#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all labels associated with a given line plot        */
/*****************************************************************************/

void AxisLabs (ByTe_4 PNuM, ByTe_4 RelPn, ByTe_1 Type)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct CutDef *cD;
   ByTe_4 N;
   ByTe_4 RCut = 0;

   N = PNuM % InFo.NPDefs;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;        /* plot info struct     */
   AxisNum (N, 0, Type);                            /* X num labels         */
   AxisText (N, 0, RelPn, 0);                       /* Main X text labels   */
   if (Pd->CCut > 0)                                /* Contour Cut?         */
       AxisText (N, 0, RelPn, -1);                  /* Contour Cut labels   */
   if (Pd->LSCut > 0)                               /* LShell Cut?          */
       AxisText (N, 0, RelPn, -2);                  /* LShell Cut labels    */
   AxisNum (N, 1, Type);                            /* left Y num labels    */
   AxisText (N, 1, RelPn, Type);                    /* left Y text labels   */
   if (Pd->CCut > 0)                                /* Contour Cut?         */
       AxisText (N, 1, RelPn, -1);                  /* Contour Cut labels   */
   if (Pd->LSCut > 0)                               /* LShell Cut?          */
       AxisText (N, 1, RelPn, -2);                  /* LShell Cut labels    */

   if (Pd->LSCut > 0) {                             /* BEG SHELL CUT        */
      cD = (struct CutDef *)Pd->LSCut;              /* cut info             */
      RCut = cD->CutPlace;                          /* Right Cut Plot       */
   }                                                /* END SHELL CUT        */
   if (Pd->SrcsYR > 0 || RCut)                      /* right axis active?   */
   {                                                /* BEG RIGHT LABELS     */
      AxisNum (N, 2, Type);                         /* right Y num labels   */
      AxisText (N, 2, RelPn, Type);                 /* right Y text labels  */
   }                                                /* END RIGHT LABELS     */
}
