/*****************************************************************************/
/*  This routine takes the given sweep units label and the given scan units  */
/*  label and under the integration scheme layed out in fmt tries to         */
/*  construct a new data units label.                                        */
/*                                                                           */
/*  The input array *fmt has the following definitions for its elements      */
/*                                                                           */
/*     fmt[0] - if 1 then both the input sweep and scan unit labels are      */
/*              converted to upper case before any processing beging         */
/*     fmt[1] - if 1 then integration over scan has occurred                 */ 
/*     fmt[2] - if 1 then integration over phi has occurred                  */ 
/*     fmt[3] - if 1 then integration over theta has occurred                */ 
/*                                                                           */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Util1Ansi.h"

#define NSR 4

static ByTe_1 rcsid[] = "$Id: int_units.c,v 1.1 1999/11/11 10:15:20 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *SR_V[NSR] = {"SR", "STR", "STER", "STERADIAN"};

ByTe_1 int_units (ByTe_1 *swp_unit, ByTe_1 *scan_unit, ByTe_1 *fmt, 
                  ByTe_1 *new_unit)
{
   register ByTe_1 *c1, *c2, *c3, *c4, *c5, *c6; 

   ByTe_4  j, offset, D = -1;

   ByTe_1  *swp, *scan;
   ByTe_1  beg_wd = 1;
   ByTe_1  del = 0;
   ByTe_1  numer = 0;

   void  *Tstr;
   void  *ZP;

   /**************************************************************************/
   /*  If there has been no integration over scan then copy the entire       */
   /*  units label over into new_unit                                        */ 
   /**************************************************************************/

   if (fmt[1] == 0)                               /* no scan integration?    */
      strcpy (new_unit, swp_unit);                /* copy old to new label   */

   Tstr = 0;                                      /* init ucase string ptr   */
   ZP = 0;                                        /* init bad ptr variable   */

   if (fmt[1] == 1)                               /* integrated over scan?   */
   {                                              /* yes!                    */

   /**************************************************************************/
   /*  Look for `/` in sweep units label.  Everything after this symbol is   */
   /*  considered to be in the denominator.  Units in the denominator can    */
   /*  be canceled out by the integrated units                               */
   /**************************************************************************/

      c1 = swp_unit;                              /* ptr to input sweep lab  */
      c3 = new_unit;                              /* ptr to new unit label   */
      while (*c1 != '/' && *c1 != 0)              /* look for '/' til EOS    */
      {
         if (*c1 != ' ' && *c1 != '(' && *c1 != ')') /* word in numerator?   */
            numer = 1;                            /* probably                */
         *c3++ = *c1++;                           /* xfer old -> new unitlab */
      }

      if (*c1 == '/')                             /* found divide symbol?    */
      {                                           /* yes!                    */
         *c3++ = *c1++;                           /* xfer it to new unit lab */
         D = (ByTe_4)c3 - (ByTe_4)new_unit - 1;   /* pos of '/'              */
      }
      else                                        /* no denominator          */
         *c3 = 0;                                 /* end new_unit string     */

   /**************************************************************************/
   /*  Begin to process the dividend.  First, if there was an integration    */
   /*  over the scan, then remove (or add to the numerator if not found in   */
   /*  the denominator) the scan units.  Second, if integration has occurred */
   /*  over phi and theta - remove the steradian unit from the demonimator   */
   /*  if it is present.  Recognized abbreviations are sr, str, ster         */
   /**************************************************************************/

      if (fmt[0] == 1 && *c1 != 0)                /* do all chks in ucase?   */
      {                                           /* yes!                    */
         if ((Tstr = Ucase (c1, scan_unit)) > ZP) /* convert units to UC     */
         {                                        /* if no malloc error      */
            swp = (ByTe_1 *)Tstr;                 /* ptr to ucase sweep lab  */
            scan = (ByTe_1 *)Tstr + strlen(c1) + 1; /* ptr to ucase scan lab */
         }
         else
            return (-1);                          /* return error            */
      }
      else                                        /* use given labels        */
      {
         swp = c1;                                /* ptr to input sweep lab  */
         scan = scan_unit;                        /* ptr to input scan lab   */
      }
          
      c5 = swp;                                   /* dup ptr to beg of denom */

      while (*c1 != 0)                            /* loop till NULL          */
      {
         c2 = scan;                               /* ptr to scan unit label  */
         if ((*c5 == *c2) && !del && beg_wd)      /* swp lab is scan lab?    */
         {                                        /* maybe ..                */
            c4 = c1;                              /* ptr to begin of match   */
            while ((*c5 == *c2) && (*c2 != 0))    /* loop till lab different */
            {
               ++c1;                              /* inc swp unit label      */
               ++c2;                              /* inc scan unit label     */
               ++c5;                              /* inc orig swp unit label */
            }
 
            if (*c2 == 0)                         /* hit end of scan label?  */
            {                                     /* yes                     */
               if ((del = end_of_word (*c1)))     /* end of word found?      */
               {                                  /* yes                     */
                  if (*(c3-1) == ' ' || *(c3-1) == '-')
                     --c3;
               } 
            }
            else
            {
               while (c4 < c1)                    /* loop over missed chars  */
                 *c3++ = *c4++;                   /* put in integral label   */
            }
         }
         else
         {
            beg_wd = end_of_word (*c1);           /* end of word found?      */
            *c3++ = *c1++;                        /* char to new label       */
            ++c5;                                 /* inc tmp string position */
         }
      }

      *c3 = 0;                                    /* terminate new lab       */

   /**************************************************************************/
   /*  If the scan label was not removed, then we must add it to the         */
   /*  numerator                                                             */
   /**************************************************************************/

      if (!del)                                   /* scan label found?       */
      {                                           /* no!                     */
         offset = strlen(scan_unit) + numer;      /* shift to insert scanlab */
         if (D >= 0)                              /* has a denominator?      */
         {                                        /* yes!                    */
            c1 = new_unit + D;                    /* position of '/'         */
            c2 = new_unit + strlen(new_unit);     /* end of string           */
            while (c2 >= c1 )                     /* loop over demoninator   */
            {
               *(c2 + offset) = *c2;              /* shift denonimator       */
               --c2;                              /* dec new units ptr       */
            }
         }
         else                                     /* no divided sign         */
            D = strlen(new_unit);                 /* end of new_unit         */

         c1 = new_unit + D - 1;                   /* end of numerator        */
         while (*c1 == ' ' || *c1 == ')')         /* move spaces and )'s     */
         {
            *(c1 + offset) = *c1;                 /* shift character         */
            --c1;                                 /* dec new units ptr       */
         }

         if (numer)                               /* something in numerator? */
            *(++c1) = '-';                        /* yes - add dash          */
         c2 = scan_unit;                          /* pntr to scan units lab  */
         while (*c2 != 0)                         /* loop over scan units    */
            *(++c1) = *c2++;                      /* add scan units label    */
      }
   }

   /**************************************************************************/
   /*  In this section of the code the sterdian units label is removed if    */
   /*  one exists                                                            */
   /**************************************************************************/

   if (Tstr != 0)                                 /* memeory been malloced?  */
   {
      free (Tstr);                                /* yes - free it           */
      Tstr = 0;                                   /* reinitialize it         */
   }

   /**************************************************************************/
   /*  Look for `/` in new_units label.                                      */
   /**************************************************************************/

   del = 0;                                       /* reinitialize remove     */
   beg_wd = 1;                                    /* reinitialize beg_wd    */

   c1 = new_unit;                                 /* ptr to new unit label   */
   while (*c1 != '/' && *c1 != 0)                 /* look for '/' til EOS    */
      ++c1;                                       /* next character          */

   if (*c1 == '/')                                /* found divide symbol?    */
      ++c1;                                       /* next character          */

   if (fmt[2] == 1 && fmt[3] == 1 && *c1 != 0)    /* integral over phi & th? */
   {                                              /* yes!                    */
      c6 = c1;                                    /* dup pos in new_units    */
      if ((Tstr = Ucase (c1, "")) > ZP)           /* convert new_unit to UC  */
         c3 = (ByTe_1 *)Tstr;                     /* ptr to ucase sweep lab  */
      else
         return (-1);                             /* return error            */
          
      while (*c1 != 0)                            /* loop till NULL          */
      {
         if ((*c3 == 'S') && !del && beg_wd)      /* possible STERADIAN lab? */
         {                                        /* maybe ..                */
            c4 = c1;                              /* beg of match in newunit */
            c5 = c3;                              /* begin of match in Tstr  */
            j = 0;                                /* first steradian label   */
            while (j < NSR && !del)               /* loop over SR labs       */
            {
               c1 = c4;                           /* reset new_unit pointer  */
               c2 = SR_V[j++];                    /* ptr to scan unit label  */
               c3 = c5;                           /* reset Tstr pointer      */
               while ((*c3 == *c2) && (*c2 != 0)) /* loop till lab different */
               {
                  ++c1;                           /* inc new unit label      */
                  ++c2;                           /* inc scan unit label     */
                  ++c3;                           /* inc new unit label      */
               }
 
               if (*c2 == 0)                      /* hit end of scan label?  */
               {                                  /* yes                     */
                  if ((del = end_of_word (*c1)))  /* end of word found?      */
                     if (*(c6-1) == ' ' || *(c6-1) == '-')
                        --c6;
               } 
            }

            if (!del)                             /* did we find a match?    */
            {                                     /* no!                     */
               while (c4 < c1)                    /* loop over missed chars  */
                  *c6++ = *c4++;                  /* put in integral label   */
            }
         }
         else
         {
            beg_wd = end_of_word (*c1);           /* end of word found?      */
            *c6++ = *c1++;                        /* char to new label       */
            ++c3;                                 /* inc Tstr position       */
         }
      }

      *c6 = 0;                                    /* terminate new lab       */
   }

   if (Tstr != 0)                                 /* memeory been malloced?  */
   {
      free (Tstr);                                /* yes - free it           */
      Tstr = 0;                                   /* reinitialize it         */
   }

   return (1);
}

#include <stdlib.h>

void *Ucase (ByTe_1 *swp, ByTe_1 *scan)
{
   register ByTe_1 *c1, *c2;

   void *Tstr;

   ByTe_4 offset;
   size_t bytes = 2;

   /**************************************************************************/
   /*  First find the length of both strings and malloc temporary array of   */
   /*  the same size.  Note that the nulls are taken care of in the          */
   /*  initialization  of the variable byte                                  */
   /**************************************************************************/

   c1 = swp;                                   /* ptr to swp unit label      */
   while (*c1++ != 0)                          /* loop over swp units        */
     ++bytes;                                  /* inc bytes in string        */

   c1 = scan;                                  /* ptr to scan unit label     */
   while (*c1++ != 0)                          /* loop over swp units        */
     ++bytes;                                  /* inc bytes in string        */

   if ((Tstr = malloc (bytes)) == 0)           /* malloc string memory       */
      return (0);                              /* return error bad malloc    */

   /**************************************************************************/
   /*  Transfer both input strings to temporary storage according to the 1st */
   /*  format definition.                                                    */
   /**************************************************************************/

   c2 = (ByTe_1 *)Tstr;                        /* ptr to tmp swp unit label  */

   offset = 'A' - 'a';                         /* lower to upper conversion  */ 
   c1 = swp;                                   /* ptr to swp unit label      */
   while (*c1 != 0)                            /* loop over swp units        */
   {
      if (*c1 >= 'a' && *c1 <= 'z')            /* is it lower case?          */
         *c2++ = *c1++ + offset;               /* yes - convert to uppercase */ 
      else
         *c2++ = *c1++;                        /* no - leave it as is        */ 
   }
   *c2++ = 0;                                  /* null end 1st string        */
           
   c1 = scan;                                  /* ptr to scan unit label     */
   while (*c1 != 0)                            /* loop over scan units       */
   {
      if (*c1 >= 'a' && *c1 <= 'z')            /* is it lower case?          */
         *c2++ = *c1++ + offset;               /* yes - convert to uppercase */ 
      else
         *c2++ = *c1++;                        /* no - leave it as is        */ 
   }
   *c2++ = 0;                                  /* null end 2nd string        */

   return (Tstr);                              /* pntr CAP labels            */
}

/*****************************************************************************/
/*  This routine takes a character and determines if it is one of the        */
/*  accepted end of word characters.  These characters are ' ', '-', '(',    */
/*  '/', '[', ']', '{', '}', and '('.                                        */
/*****************************************************************************/

ByTe_1 end_of_word (ByTe_1 C)
{
   register ByTe_1 *c1;

   ByTe_1  *EoW = "/()[]{} -";
   ByTe_1  EnD = 0;

   if (C != 0)                                    /* natural end of word?    */
   {                                              /* no!                     */
      c1 = EoW;                                   /* ptr to end of wd chars  */
      while (*c1 != 0 && *c1 != C)                /* chk cur char to these   */
        ++c1;                                     /* inc beg char pntr       */

      EnD = (*c1 == 0) ? 0 : 1;                   /* if end of word, set     */
   }
   else                                           /* natural end of word     */
      EnD = 1;                                    /* set end flag to 1       */

   return (EnD);
}
