#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "user_defs.h"
#include "libbase_udf.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "UDFpltStr.h"
#include "UDFpltVar.h"
#include "UDFpltAnsi.h"

int main(int argc, char *argv[])
{
   ByTe_4 I, EndP;
   ByTe_1 NextPg = 1;
   struct PlotDef *Pb, *Pd;

   if (argc == 12)                              /* batch mode                */
   {                                            /* BEG GET TIMES             */
      sscanf(argv[2], "%hd", &BatchTime[0]);    /* begin year                */
      sscanf(argv[3], "%hd", &BatchTime[1]);    /* begin day                 */
      sscanf(argv[4], "%hd", &BatchTime[2]);    /* begin hour                */
      sscanf(argv[5], "%hd", &BatchTime[3]);    /* begin minute              */
      sscanf(argv[6], "%hd", &BatchTime[4]);    /* begin second              */
      sscanf(argv[7], "%hd", &BatchTime[5]);    /* end year                  */
      sscanf(argv[8], "%hd", &BatchTime[6]);    /* end day                   */
      sscanf(argv[9], "%hd", &BatchTime[7]);    /* end hour                  */
      sscanf(argv[10], "%hd", &BatchTime[8]);   /* end minute                */
      sscanf(argv[11], "%hd", &BatchTime[9]);   /* end second                */
   }                                            /* END GET TIMES             */

   ReadMenu (argv[1]);                          /* read the default file     */
   init_udf ();                                 /* initial all UDF stuff     */
   CreatePidfStruc (&InFo.PIDF);                /* create PIDF info ptr      */
   MenuInterface ();                            /* menu answers to strucs    */
   DoInitializes ();                            /* all initilizations        */
   OpenDataFiles();                             /* open & pos all srcs       */

   StartPlot ();                                /* fire up the graphics      */
   FormPlots();                                 /* set up plot positions     */

   while (NextPg)                               /* Plot continuation loop    */
   {                                            /* BEG CONTINUE PAGE LOOP    */
      MainLab(argv[1]);                         /* output main labels        */
      NextPg = 0;                               /* no continuation           */
      EndP = InFo.NPDefs * InFo.Dups;
      Pb = (struct PlotDef *)InFo.PlotDefs;     /* 1st plot definition       */
      for (I=0; I < EndP; ++I)                  /* loop over plot defs       */
      {                                         /* BEG PLOT DEFINITION LOOP  */
          Pd = Pb + I % InFo.NPDefs;            /* normalized plot def loc   */
          switch (Pd->PType)                    /* switch on plot type       */ 
          {                                     /* BEG PLOT TYPE SWITCH      */
             case 0:                            /* START TIME BASED          */ 
                TimePlots (I, 1);               /* time based plot           */
             break;                             /* STOP TIME BASED           */ 
             case 1:                            /* START SCAN BASED          */ 
                ScanPlots (I);                  /* scan based plot           */
             break;                             /* STOP SCAN BASED           */ 
             case 2:                            /* START GENERIC PLOT        */ 
                Gen2DPlots (I);                 /* generic plot              */
             break;                             /* STOP GENERIC PLOT         */ 
             case 3:                            /* START CONTOUR PLOT        */ 
                ContPlots (I);                  /* contour plot              */
             break;                             /* STOP CONTOUR PLOT         */ 
             case 4:                            /* START CONTOUR PLOT        */ 
                CPlots (I);                     /* contour plot              */
             break;                             /* STOP CONTOUR PLOT         */ 
             case 5:                            /* START VALUE PLOT          */ 
                Gen1DPlots (I);                 /* value plots               */
             break;                             /* STOP VALUE PLOT           */ 
          }                                     /* END PLOT TYPE SWITCH      */
          ZeroWkSp();                           /* clear out plot arrays     */
          if (Pd->More == 1)                    /* this plot needs next page */
             NextPg = 1;                        /* set next page             */
      }                                         /* END PLOT DEFINITION LOOP  */
      new_scr();                                /* hold screen               */
      clear_all(1);
   }                                            /* END CONTINUE PAGE LOOP    */

   StopPlot ();                                 /* shut down the graphics    */
   exit (0);                                    /* we is done and outta here */
}
