#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

void TimePlots (ByTe_4 PNuM, ByTe_1 AxisN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *Sb, *S;

   register ReaL_4 *Ws;
   register ByTe_2 *s1, *sEnD;

   void   *Yy;
   ReaL_8 dT;
   ReaL_4 *X, *Y, *V, *Y2, *N;
   ReaL_4 x[2];
   ByTe_4 J, K, TotP, Beg, End, pN, RpN, rN, cO, PN;
   ByTe_4 EndSrc;
   ByTe_2 SrcN;
   ByTe_2 rV;
   ByTe_1 Cmd[3], EndP;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;
   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   Sb = (struct SrcInfo *)Pd->Src;                     /* pntr to first src  */
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   if (Pd->AData[1] != 1 || Sb->LpType == 10)
      PopUpCBar (PNuM);                                /* colorbar           */

   switch (Pd->AData[(ByTe_4)AxisN])                   /* pre-plot switch    */
   {                                                   /* BEG PRE-PLOT       */
      case 1:                                          /* START VALUE PLOTS  */
      break;                                           /* STOP VALUE PLOTS   */
      case 2:                                          /* START SCAN PLOTS   */
      case 3:                                          /* START SCAN PLOTS   */
      case 9:                                          /* START SCAN PLOTS   */
         Cmd[0] = 'y';                                 /* plot along Y       */
         Cmd[1] = '3';                                 /* binned plot        */
         Cmd[2] = 0;                                   /* end of string      */
         Beg = 0;                                      /* beg of data        */
         X = x;                                        /* data X position    */
         Y2 = 0;                                       /* pixel plotting     */
      break;                                           /* STOP SCAN PLOTS    */
   }                                                   /* BEG PRE-PLOT       */

   K = 0;                                              /* 1st plot in series */
   sEnD = (ByTe_2 *)Pd->SOrder + Pd->EmptySrc;         /* source order array */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      TimeAlign (PN, K, 0);
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1);

      if ((Pd->PStat == 0 && rV == 0) || 
             (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */

      if (Pd->PStat == 0 && CanIgn) {                  /* BEG IGNORE EMPTIES */
         dT = Pd->Tm.R * Pd->Bx.N;                     /* time across plot   */
         IncTm (&Pd->Pb, &Pd->Pe, dT, Pd->Tm.Sca, 0);  /* next plot tms      */
         continue;                                     /* try the next       */
      }                                                /* END IGNORE EMPTIES */

      Ws = (ReaL_4 *)Wa.WorkSpace;                     /* base plot position */
      s1 = (ByTe_2 *)Pd->SOrder;                       /* source order array */
      SrcN = *s1++;                                    /* first source num   */
      switch (Pd->AData[(ByTe_4)AxisN])                /* pre-plot switch    */
      {                                                /* BEG PLOT SWITCH    */
         case 1:                                       /* START VALUE PLOTS  */
            RpN = 0;                                   /* relative plot num  */
            End = Pd->Byl.N - 1;                       /* end of data        */
            for (pN = 0, rN = 1; pN < Pd->nGL; ++pN, ++rN)  /* plot loop     */
            {                                          /* BEG PLOT LOOP      */
               S = Sb + SrcN;
               EndSrc = (S->OneAll == 3) ? S->TCols * S->Col.N : S->Col.N;
               EndP = ((rN % Pd->Stack == 0) || rN == Pd->nGL) ? 1 : 0;
               cO = (S->PCol < 0) ? 10 + (pN % Pd->Stack) % 7 : 
                    (S->OneAll == 3) ? pN : 0;
               if (pN % Pd->Stack == 0)                /* need new plot?     */
               {                                       /* BEG NEW PLOT       */
                  SetUpRecPlot (PN, K, 0);             /* set up plot        */
                  PopUpPlot (PN, 1, 0);                /* pre plot stuff     */
               }                                       /* END NEW PLOT       */
               TimeValue (PN, SrcN, pN, RpN);          /* do value plot      */ 
               if (EndP)                               /* need new plot?     */
               {                                       /* BEG NEW PLOT       */
                  PopUpPlot (PN, 0, Sb->LpType);       /* post plot stuff    */
                  AxisLabs (PN, K, Sb->LpType);        /* axis labels        */
               }                                       /* END NEW PLOT       */
               PlotText (PNuM, SrcN, K, pN, cO);       /* Per Plot Labels    */
               if (EndP)                               /* need new plot?     */
                  ++K;                                 /* to next plot       */

               if (++RpN >= EndSrc)                    /* done with this src */
               {                                       /* BEG DONE WITH SRC  */
                  SrcN = *s1++;                        /* next src           */
                  RpN = 0;                             /* no lines this src  */
               }                                       /* END DONE WITH SRC  */
            }                                          /* END PLOT LOOP      */
         break;                                        /* STOP VALUE PLOTS   */
         case 2:                                       /* START SCAN PLOTS   */
         case 3:                                       /* START SCAN PLOTS   */
         case 9:                                       /* START SCAN PLOTS   */
            End = FormEdges (PN, &Yy, 'Y', Pd->Byl.Fmt, 0) - 1;  /* Y edges  */
            Y = (ReaL_4 *)Yy;                          /* pointer to edges   */
            for (pN = 0, rN = 1; pN < Pd->nGL ; ++pN, ++rN) /* plot loop     */
            {                                          /* BEG PLOT LOOP      */
               S = Sb + SrcN;
               EndP = ((rN % Pd->Stack == 0) || rN == Pd->nGL) ? 1 : 0;
               cO = (S->PCol < 0) ? 10 : 0;
               V = Ws + 2 * pN * Pd->PlotLen;          /* plot begins here   */
               N = V + Pd->PlotLen;                    /* norms begin here   */
               if (pN % Pd->Stack == 0)                /* need new plot?     */
               {                                       /* BEG NEW PLOT       */
                  SetUpRecPlot (PN, K, 0);             /* set up plot        */
                  PopUpPlot (PN, 1, 0);                /* pre plot stuff     */
               }                                       /* END NEW PLOT       */
               Normalize (V, N, Pd->PlotLen, 1, 0.0);  /* normalize data     */
               FillGaps (PN, pN, 'X');                 /* fill gaps along X  */
               FillGaps (PN, pN, 'Y');                 /* fill gaps along X  */

               for (J = 1; J <= Pd->Bx.N; V += Pd->Byl.N, N += Pd->Byl.N)  
               {
                  *X = J++;
                  plot_3d (Pd->Pn, 0, 4, 8, X, Y, X, V, Y2, 
                          Beg, End, Cmd, Pd->CInfo, Pd->Cb.Sca);
               }

               if (EndP)                               /* need new plot?     */
               {                                       /* BEG NEW PLOT       */
                  PopUpPlot (PN, 0, Sb->LpType);       /* post plot stuff    */
                  AxisLabs (PN, K, Sb->LpType);        /* axis labels        */
               }                                       /* END NEW PLOT       */
               PlotText (PN, SrcN, K, pN, cO);         /* Per Plot Labels    */
               if (EndP)                               /* need new plot?     */
                  ++K;                                 /* to next plot       */
               SrcN = *s1++;                           /* next src           */
            }                                          /* BEG PLOT LOOP      */
            if (Yy != 0)                               /* Y memory to free?  */
            {                                          /* BEG FREE Y MEM     */
               free (Yy);                              /* let it go          */
               Yy = 0;                                 /* free at last       */
            }                                          /* END FREE Y MEM     */
         break;                                        /* STOP SCAN PLOTS    */
      }                                                /* BEG PLOT SWITCH    */

      ZeroWkSp();                                      /* clear plot arrays  */
      if (Pd->Tm.Fmt != 0) {
         dT = Pd->Tm.R * Pd->Bx.N;                     /* time across plot   */
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else 
            IncTm (&Pd->Pb, &Pd->Pe, dT, Pd->Tm.Sca, CanIgn);
      }

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */
}
