#include <stdio.h>
#include <stdlib.h>
#include "util_str.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void TimeAlign (ByTe_4 N, ByTe_4 pN, ByTe_1 Act)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pdm, *Pds;
   struct TiMiNg  *tB, *tE;
   struct SrcInfo *S;

   ByTe_4 bS, eS, bN, eN;
   ByTe_2 rV, BKey = 0, nSrcs, *s1;
   ByTe_1 Fmt;

   Pds = (struct PlotDef *)InFo.PlotDefs + N;       /* slave plot def        */
   if (Pds->AlignPd < 0) {                          /* BEG NO TIME ALIGN     */
      Fmt = (Pds->Pb.Yr < 0 || Act == 0) ? -1 : 0;  /* Time Not Set       */
   } else {                                         /* BEG MAYBE TIME ALIGN  */
      if (Pds->AlignPd < N)                         /* set time align action */
         Fmt = (Act == 1) ? -1 : 1;                 /* Time Not Set       */
      else
         Fmt = (Pds->Pb.Yr < 0 || Act == 0) ? -1 : 0;  /* Time Not Set       */
   }                                                /* END MAYBE TIME ALIGN  */

   switch (Fmt) {                                      /* BEG PROCESS SWITCH */
      case 0:                                          /* START SAVE         */
        tB = (struct TiMiNg *)Pds->Times + 2 * pN;     /* slave start time   */
        tE = tB + 1;                                   /* slave stop time    */
        tB->Yr = Pds->Pb.Yr;                           /* save beg year      */
        tB->Dy = Pds->Pb.Dy;                           /* save beg day       */
        tB->Ms = Pds->Pb.Ms;                           /* save beg millesec  */
        tE->Yr = Pds->Pe.Yr;                           /* save end year      */
        tE->Dy = Pds->Pe.Dy;                           /* save end day       */
        tE->Ms = Pds->Pe.Ms;                           /* save end millesec  */
      break;                                           /* STOP SAVE          */
      case 1:                                          /* START TRANSFER     */
        Pdm = (struct PlotDef *)InFo.PlotDefs + Pds->AlignPd; 
        tB = (struct TiMiNg *)Pdm->Times + 2 * pN;     /* master start time  */
        tE = tB + 1;                                   /* master stop time   */
        Pds->Pb.Yr = tB->Yr;                           /* xfer beg year      */
        Pds->Pb.Dy = tB->Dy;                           /* xfer beg day       */
        Pds->Pb.Ms = tB->Ms;                           /* xfer beg millesec  */
        Pds->Pe.Yr = tE->Yr;                           /* xfer end year      */
        Pds->Pe.Dy = tE->Dy;                           /* xfer end day       */
        Pds->Pe.Ms = tE->Ms;                           /* xfer end millesec  */
        bS = tB->Ms/1000.0;
        bN = (tB->Ms % 1000) * 1000000;
        eS = tB->Ms/1000.0;
        eN = (tB->Ms % 1000) * 1000000;
        while ((nSrcs = BegEndSrc (N, BKey)) > 0) {    /* BEG KEY GROUP      */
           s1 = (ByTe_2 *)Pds->SOrder + BKey;          /* source order array */
           S = (struct SrcInfo *)Pds->Src + *s1;       /* current source     */
           BKey += nSrcs;                              /* next key           */
           rV = ToThisTime (S->Key, "", S->Ver, InFo.UDF, 
                      tB->Yr, tB->Dy, bS, bN,
                      tE->Yr, tE->Dy, eS, eN);
           ErrorRpt ("TOTHISTIME", rV, 0);             /* report any errs   */
           if (rV == TIME_NOT_FOUND)                   /* can't get to time */
              return ;                                 /* leave and report  */
        }                                              /* END KEY GROUP      */
      break;                                           /* STOP TRANSFER      */
   }                                                   /* END PROCESS SWITCH */
}
