#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void TFerLine (ByTe_4 PN, ByTe_4 pN, ByTe_4 Ln, ByTe_1 Dir, void **V) 
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;

   register ReaL_4 *Px, *PEnd, *f1;

   ByTe_4  Inc, Len;
   size_t bytes;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */

   Px = (ReaL_4 *)Wa.WorkSpace + 2 * pN * Pd->PlotLen; /* base plot position */

   if (Dir == 'X')                                     /* fill along X       */
   {                                                   /* BEG X SETS         */
      Inc = Pd->Byl.N;                                 /* to next data value */
      Len = Pd->Bx.N;                                  /* number of elements */
      PEnd = Px + Pd->PlotLen;                         /* end of row         */
      Px += Ln;                                        /* this line          */
   }                                                   /* END X SETS         */
   else                                                /* fill along Y       */
   {                                                   /* BEG Y SETS         */
      Inc = 1;                                         /* to next data value */
      Len = Pd->Byl.N;                                 /* number of elements */
      Px += Ln * Pd->Byl.N;;                           /* this line          */
      PEnd = Px + Pd->Byl.N;                           /* end of col         */
   }                                                   /* END Y SETS         */

   if (*V == 0) {                                      /* BEG GET SOME MEM   */
      bytes = Len * sizeof(ReaL_4);                    /* this many bytes    */
      if ((*V = malloc(bytes)) == 0)                   /* grab space         */
         ErrorRpt ("TFERLINE", 0, 2);                  /* YIKES! an error    */
   }                                                   /* END GET SOME MEM   */

   f1 = (ReaL_4 *) *V;                                 /* value pointer      */
   for (; Px < PEnd; Px += Inc)                        /* row/col loop       */
      *f1++ = *Px;                                     /* xfer value         */
}
