#include <string.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up a plot box in which a contour can be drawn.         */
/*****************************************************************************/

void SetUpRecPlot (ByTe_4 PNuM, ByTe_4 RelPn, ByTe_1 PType)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct CutDef *cD, *cDs;
   struct AxisInfo *Axb, *Axt, *Ayl, *Ayr;

   ReaL_8 lV;
   ReaL_4 dPx, dPy, Xr, Xl, Yt, Yb, Ty, By, GrP;
   ByTe_4 C, R, Ln, N, Lg, Mr, Mc;
   ByTe_2 Lr, Lc, xL, mP, mC;
   ByTe_1 Wn, Pn, Lx = 0, LyL = 0, LyR = 0, Xts, Xbs, Yls, Yrs;
   ByTe_1 BCut = 0, RCut = 0;
   ByTe_1 lE, uE;

   N = PNuM % InFo.NPDefs;
   GrP = (ByTe_4)(PNuM / InFo.NPDefs);
   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot define info   */

   if (Pd->CCut != 0) {
      cD = (struct CutDef *)Pd->CCut;
      if (cD->CutPlace == 0) 
         BCut = 1;
      else
         RCut = 1;
   }
   if (Pd->LSCut != 0) {
      cDs = (struct CutDef *)Pd->LSCut;
      if (PType == 1) PType = 2;
      if (cDs->CutPlace == 0) 
         BCut = 1;
      else
         RCut = 1;
   }

   if (PType == 0) {                                   /* normal plot        */
      Pn = Pd->Pn;                                     /* plot number        */
      Axt = &Pd->Xt;                                   /* Top X axis         */
      Ayl = &Pd->Yl;                                   /* Left Y axis        */
      Axb = &Pd->Xb;                                   /* Bot X axis         */
      Ayr = &Pd->Yr;                                   /* Right Y axis       */
   } else {
      if (PType == 2) cD = cDs;                        /* LShell Cut Plot    */
      Pn = cD->CutPn;                                  /* plot number        */
      Axt = &cD->Ax;                                   /* Top X axis         */
      Ayl = &cD->Ay;                                   /* Left Y axis        */
      Axb = &cD->Ax;                                   /* Bot X axis         */
      Ayr = &cD->Ay;                                   /* Right Y axis       */
   }

   Wn = 2;                                             /* set base window #  */ 
   Lc = Pd->Cols - 1;                                  /* last col number    */
   Lr = Pd->Rows - 1;                                  /* last row number    */
   Mr = Pd->Rows / 2;                                  /* middle row number  */
   Mc = Pd->Cols / 2;                                  /* middle col number  */
   Lg = InFo.Dups - 1;                                 /* last dup number    */
   Ln = InFo.EmptyPd - 1;                              /* last plot def      */
   if (Pd->TimeDir == 1) {                             /* TIME ACROSS        */
      R = RelPn / Pd->Cols;                            /* current row number */
      C = RelPn % Pd->Cols;                            /* current col number */
   } else {                                            /* TIME DOWN          */
      R = RelPn % Pd->Rows;                            /* current row number */
      C = RelPn / Pd->Rows;                            /* current col number */
   }                                                   /* END PLOT PLACEMENT */

   switch (PType) {                                    /* axis label status  */
      case 0:                                          /* START NORMAL PLOT  */
        xL = (BCut) ? -1 : Pd->XLabs;                  /* no X lab if BCut   */
        Ayr->DoLabs = (C == Lc && !RCut) ? 1 : 0;      /* Right Y label stat */
        Axt->DoLabs = (N == 0 && R == 0) ? 1 : 0;      /* Top X label status */
        Ayl->DoLabs = (C == 0) ? 1 : 0;                /* Left Y label stat  */
        Axb->DoLabs = 0;
      break;                                           /* STOP NORMAL PLOT   */
      case 1:                                          /* START CONTOUR CUT  */
        xL = Pd->XLabs;                                /* X lab possible     */
        Ayl->DoLabs = (C == 0 && BCut) ? 1 : 0;        /* Left Y label stat  */
      break;                                           /* STOP CONTOUR CUT   */
      case 2:                                          /* START LSHELL CUT   */
        xL = Pd->XLabs;                                /* X lab possible     */
        Ayr->DoLabs = ((C == Lc && cD->CutPlace == 1) ||
                      (C == 0 && cD->CutPlace == 0)) ? 1 : 0;  /* Left Y     */
      break;                                           /* STOP LSHELL CUT    */
   }

   switch (xL) {                                       /* BEG X BOTTOM       */
      case 0:                                          /* Start default      */
        if ((GrP == Lg && N == Ln) && R == Lr)
           Axb->DoLabs = (C == Mc) ? 1 : 2;
        else
           Axb->DoLabs = 0;
      break;                                           /* Stop default       */
      case 1:                                          /* Start always       */
        Axb->DoLabs = (R == Lr && C == Mc) ? 1 : 2;    /* Bot X label status */
      break;                                           /* Stop always        */
      case 2:                                          /* Start bottom       */
        if(R == Lr)
           Axb->DoLabs = (C == Mc) ? 1 : 2;            /* Bot X label status */
        else
           Axb->DoLabs = 0;                            /* Bot X label status */
      break;                                           /* Stop bottom        */
   }                                                   /* END X BOTTOM       */
   
   mj_tic_len(Pn, Axb->MjTLen, Ayl->MjTLen, 1,
                  Axt->MjTLen, Ayr->MjTLen, 1 ); 

   mn_tic_len(Pn, Axb->MnTLen, Ayl->MnTLen, 1,
                  Axt->MnTLen, Ayr->MnTLen, 1 );

   mj_tic_fmt(Pn, Axb->MjTFmt, Ayl->MjTFmt, 1,
                  Axt->MjTFmt, Ayr->MjTFmt, 1 ); 

   mn_tic_fmt(Pn, Axb->MnTFmt, Ayl->MnTFmt, 1,
                  Axt->MnTFmt, Ayr->MnTFmt, 1 );

   mj_tics(Pn, Axb->MjTNum, Ayl->MjTNum, 0,
               Axt->MjTNum, Ayr->MjTNum, 0 );

   mn_tics(Pn, Axb->MnTNum, Ayl->MnTNum, 0,
               Axt->MnTNum, Ayr->MnTNum, 0 );

   num_size(Pn, Axb->NumSize, Ayl->NumSize, 1,
                Axt->NumSize, Ayr->NumSize, 1 );

   num_intlv(Pn, Axb->NumIntlv, Ayl->NumIntlv, 0 ,
                 Axt->NumIntlv, Ayr->NumIntlv, 0 );

   num_gap(Pn, Axb->NumGap, Ayl->NumGap, 0 ,
               Axt->NumGap, Ayr->NumGap, 0 );

   num_offset(Pn, Axb->NumOffset, Ayl->NumOffset, 0 , 
                  Axt->NumOffset, Ayr->NumOffset, 0 );

   num_spacing(Pn, Axb->NumSpace, Ayl->NumSpace, 0 , 
                  Axt->NumSpace, Ayr->NumSpace, 0 );

   lab_spacing (Pn, 1.0);                             /* default lab spacing */
   lab_offset (Pn, 1.0);                              /* default lab offsets */
   lab_size (Pn, 20);                                 /* default lab size    */

   lE = 0;                                            /* deflt low end flag  */
   uE = 0;                                            /* deflt up end flag   */
   if (Axb->Sca == 1) {                               /* BEG LOG SCALED AXIS */
      lV = log10(Axb->Min);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      lE = (lV < .3 ) ? 0 : 1;                        /* lower end buf flag  */
      lV = log10(Axb->Max);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      uE = (lV < .3 ) ? 0 : 1;                        /* upper end buf flag  */
   }                                                  /* END LOG SCALED AXIS */

   if ((!lE || !uE) && Axb->DoLabs > 0) {             /* BEG CROWDED END     */
      mP = (RCut && PType == 0) ? 1000 : C;           /* !last plot if RCUT  */
      mC = (RCut && PType != 0) ? 1 : C;              /* !first plot if RCUT */
      if (R == Lr && (Lc > 0 || RCut))                /* end label check     */
         Lx = (mC == 0) ? 1 : (mP == Lc) ? 2 : 3;     /* end label set       */
      if (lE && Lx > 1) Lx -= 2;                      /* Ok low end correct  */
      if (uE && (Lx == 1 || Lx == 3)) Lx -= 1;        /* Ok up end correct   */
   }                                                  /* END CROWDED END     */

   lE = 0;                                            /* deflt low end flag  */
   uE = 0;                                            /* deflt up end flag   */
   if (Ayl->Sca == 1) {                               /* BEG LOG SCALED AXIS */
      lV = log10(Ayl->Min);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      lE = (lV < .3 ) ? 0 : 1;                        /* lower end buf flag  */
      lV = log10(Ayl->Max);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      uE = (lV < .3 ) ? 0 : 1;                        /* upper end buf flag  */
   }                                                  /* END LOG SCALED AXIS */

   if ((!lE || !uE) && Ayl->DoLabs > 0) {             /* BEG CROWDED END     */
      if (Ln > 0 || Lr > 0) {                         /* BEG SORT Y END LABS */
         LyR = (N == 0 && R == 0) ? 2 :               /* top row no bot lab  */
               (N == Ln && R == Lr) ? 1 : 3;          /* bot no top lab      */
         if (lE && LyR > 1) LyR -= 2;                 /* Ok low end correct  */
         if (uE && (LyR == 1 || LyR == 3)) LyR -= 1;  /* Ok up end correct   */
      }                                               /* BEG SORT Y END LABS */
   }                                                  /* END CROWDED END     */

   lE = 0;                                            /* deflt low end flag  */
   uE = 0;                                            /* deflt up end flag   */
   if (Ayr->Sca == 1) {                               /* BEG LOG SCALED AXIS */
      lV = log10(Ayr->Min);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      lE = (lV < .3 ) ? 0 : 1;                        /* lower end buf flag  */
      lV = log10(Ayr->Max);                           /* log lower limit     */ 
      lV = lV - (ByTe_4)lV;                           /* fractional part     */
      if (lV < 0.0) lV += 1.0;                        /* make positive       */
      uE = (lV < .3 ) ? 0 : 1;                        /* upper end buf flag  */
   }                                                  /* END LOG SCALED AXIS */

   if ((!lE || !uE) && Ayr->DoLabs > 0) {             /* BEG CROWDED END     */
      if (Ln > 0 || Lr > 0) {                         /* BEG SORT Y END LABS */
         LyL = (N == 0 && R == 0) ? 2 :               /* top row no bot lab  */
               (N == Ln && R == Lr) ? 1 : 3;          /* bot no top lab      */
         if (lE && LyL > 1) LyL -= 2;                 /* Ok low end correct  */
         if (uE && (LyL == 1 || LyL == 3)) LyL -= 1;  /* Ok up end correct   */
      }                                               /* BEG SORT Y END LABS */
   }                                                  /* END CROWDED END     */


   if (PType == 0 && BCut)                            /* is cut on bot */
      LyL = (LyL == 0) ? 2 : (LyL == 1) ? 3 : LyL;    /* no bot label  */

   num_ends (Pn, Lx, LyL, 0, Lx, LyR, 0);             /* label ends          */

   Xbs = Axb->Sca;                                    /* bot x scale         */
   Xts = Axt->Sca;                                    /* top x scale         */
   Yls = Ayl->Sca;                                    /* left y scale        */
   Yrs = (Pd->SrcsYL == 0) ? Ayl->Sca : Ayr->Sca;     /* right y scale       */

   plot_axis(Pn, Xbs, Yls, 0, Xts, Yrs, 0);           /* set axis scaling    */

   Ty = Pd->P.Uy - Pd->P.AbsLy * GrP - Pd->P.ToPdY * GrP;
   By = Ty - (Pd->P.Uy - Pd->P.Ly);                   /* upper y plot edge   */
   dPy = Pd->P.dY + Pd->P.dCb;                        /* total Y length      */
   dPx = Pd->P.dX + Pd->P.dCr;                        /* total X length      */

   if (PType == 0)                                    /* main plot           */
   {                                                  /* BEG PLACE MAIN PLOT */
      Xl = Pd->P.Lx + C * (dPx + Pd->P.dXp);          /* left x plot edge    */
      Xr = Pd->P.Rx + C * (dPx + Pd->P.dXp);          /* right x plot edge   */
      Yt = Ty - R * (dPy + Pd->P.dYp);                /* upper y plot edge   */
      Yb = By - R * (dPy + Pd->P.dYp);                /* lower y plot edge   */
   }                                                  /* END PLACE MAIN PLOT */
   else                                               /* cut plot            */
   {                                                  /* BEG PLACE CUT PLOT  */
      if (BCut)                                       /* cut on bottom       */
      {                                               /* BEG CUT ON BOTTOM   */
         Xl = Pd->P.Lx + C * dPx;                     /* left x plot edge    */
         Xr = Pd->P.Rx + C * dPx;                     /* right x plot edge   */
         Yt = By - R * dPy;                           /* lower y plot edge   */
         Yb = Yt - Pd->P.dCb;                         /* lower y plot edge   */
      }                                               /* END CUT ON BOTTOM   */
      else                                            /* cut on right        */
      {                                               /* BEG CUT ON RIGHT    */
         Xl = Pd->P.Rx + C * dPx;                     /* left x plot edge    */
         Xr = Xl + Pd->P.dCr;                         /* right x plot edge   */
         Yt = Ty - R * dPy;                           /* lower y plot edge   */
         Yb = By - R * dPy;                           /* lower y plot edge   */
      }                                               /* END CUT ON RIGHT    */
   }                                                  /* END PLACE CUT PLOT  */

   place_plot(Pn, Wn, Xl, Yb, 0., Xr, Yt, 0., 4);     /* set plot placement  */

   Xl = Axb->Min;                                     /* bot x plot min      */
   Xr = Axb->Max;                                     /* bot x plot max      */
   Yt = Ayl->Max;                                     /* left y plot max     */
   Yb = Ayl->Min;                                     /* left y plot min     */

   plot_scale(Pn, 0, Xl, Yb, 0., Xr, Yt, 0.);         /* axis (0,4) min/max  */

   Xl = Axt->Min;                                     /* bot x plot min      */
   Xr = Axt->Max;                                     /* bot x plot max      */
   Yt = Ayr->Max;                                     /* left y plot max     */
   Yb = Ayr->Min;                                     /* left y plot max     */

   plot_scale(Pn, 1, Xl, Yb, 0., Xr, Yt, 0.);         /* axis (2,6) min/max  */

   init_plot(Pn, 0, 4, 8);
   if (PType == 0)
      Pd->Wn = parm.grf->window;
}
