#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

void ScanPlots (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct Binning *Bs, *Bv;

   register ReaL_4 *Ws;

   void   *Sc, *Ln;
   ReaL_8 dT;
   ReaL_4 *X, *Y, *V, *Y2, *N;
   ReaL_4 r[2], Cen;
   ByTe_4 J, K, TotP, Beg, End, pN, nP, PN;
   ByTe_2 rV;
   ByTe_1 Cmd[3], TyPe, Ax, Ay, ScAx;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;
   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S = (struct SrcInfo *)Pd->Src;                      /* pntr to first src  */
   End = Pd->EmptySrc - 1;                             /* last source number */
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   Ln = 0;
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   if (Pd->AData[0] == 2)                              /* X is scan axis     */
   {                                                   /* BEG SET X PTRS     */
      TyPe = Pd->AData[1];                             /* non-scan axis func */
      Bs = &Pd->Bx;                                    /* scan is X          */
      Bv = &Pd->Byl;                                   /* non-scan is Y      */
      ScAx = 'X';                                      /* Scan Axis          */
      Cmd[0] = 'x';                                    /* Scan Axis          */
   }                                                   /* BEG SET X PTRS     */
   else                                                /* Y is scan axis     */
   {                                                   /* BEG SET Y PTRS     */
      TyPe = Pd->AData[0];                             /* non-scan axis func */
      Bs = &Pd->Byl;                                   /* scan is Y          */
      Bv = &Pd->Bx;                                    /* non-scan is X      */
      ScAx = 'Y';                                      /* Scan Axis          */
      Cmd[0] = 'y';                                    /* Scan Axis          */
   }                                                   /* BEG SET Y PTRS     */

   if (TyPe != 1)                                      /* not spectra plot   */
      PopUpCBar (PNuM);                                /* colorbar           */

   switch (TyPe)                                       /* pre-plot switch    */
   {                                                   /* BEG PRE-PLOT       */
      case 1:                                          /* START VALUE PLOTS  */
      break;                                           /* STOP VALUE PLOTS   */
      case 3:                                          /* START SCAN PLOTS   */
      case 6:                                          /* START SCAN PLOTS   */
      case 9:                                          /* START SCAN PLOTS   */
         Cmd[1] = (Pd->Bx.Fmt == 1) ? '0' : '3';       /* binned plot        */
         Cmd[2] = 0;                                   /* end of string      */
         Beg = 0;                                      /* beg of data        */
         Y2 = 0;                                       /* pixel plotting     */
         if (Pd->AData[0] == 2)                        /* X is scan axis     */
         {                                             /* BEG X AXIS SETS    */
            Ax = 0;                                    /* plot along bot X   */
            Ay = (Pd->Bx.Fmt == 0) ? 6 : 4;            /* select X axis      */
            Y = r;                                     /* data Y position    */
         }                                             /* BEG X AXIS SETS    */
         else                                          /* Y is scan axis     */
         {                                             /* BEG Y AXIS SETS    */
            Ax = (Pd->Bx.Fmt == 0) ? 2 : 0;            /* select X axis      */
            Ay = 4;                                    /* but left Y         */
            X = r;                                     /* data Y position    */
         }                                             /* BEG Y AXIS SETS    */
      break;                                           /* STOP SCAN PLOTS    */
   }                                                   /* BEG PRE-PLOT       */

   K = 0;                                              /* 1st plot in series */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      TimeAlign (PN, K, 0);
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1);

      if ((Pd->PStat == 0 && rV == 0) || 
              (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */

      if (Pd->PStat == 0 && CanIgn) {                  /* BEG IGNORE EMPTIES */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */
         dT = Pd->Tm.R * Pd->Bx.N;                     /* time across plot   */
         IncTm (&Pd->Pb, &Pd->Pe, dT, Pd->Tm.Sca, 1);  /* next plot tms      */
         continue;                                      /* try the next      */
      }                                                /* END IGNORE EMPTIES */

      Ws = (ReaL_4 *)Wa.WorkSpace;                     /* base plot position */
      switch (TyPe)                                    /* plot switch        */
      {                                                /* BEG PLOT SWITCH    */
         case 3:                                       /* START SCAN PLOTS   */
         case 6:                                       /* START SCAN PLOTS   */
         case 9:                                       /* START SCAN PLOTS   */
            End = FormEdges (PN, &Sc, ScAx, Bs->Fmt, 0) - 1;  /* Y bin edges */
            if (ScAx == 'Y')                           /* scan along Y       */
               Y = (ReaL_4 *)Sc;                       /* pointer to edges   */
            else
               X = (ReaL_4 *)Sc;                       /* pointer to edges   */
            nP = (Pd->DoSrcs == 1) ? Pd->EmptySrc : 1; /* total plots        */
            for (pN = 0; pN < nP ; ++pN)               /* loop over plots    */
            {                                          /* BEG PLOT LOOP      */
               V = Ws + 2 * pN * Pd->PlotLen;          /* plot begins here   */
               N = V + Pd->PlotLen;                    /* norms begin here   */
               SetUpRecPlot (PN, K, 0);                /* set up plot        */
               PopUpPlot (PN, 1, 0);                   /* pre plot stuff     */
               Normalize (V, N, Pd->PlotLen, 1, 0.);   /* normalize data     */
               FillGaps (PN, pN, 'X');                 /* fill gaps in X     */
               FillGaps (PN, pN, 'Y');                 /* fill gaps in Y     */
               for (J = 1; J <= Bv->N; )               /* loop over X pos    */
               {                                       /* BEG X LOOP         */
                  TFerLine (PN, pN, J-1, ScAx, &Ln);   /* data along scan    */
                  V = (ReaL_4 *)Ln;                    /* ptr to scan line   */
                  if (Pd->Bx.Fmt == 0)
                     r[0] = J++;
                  else
                     GetBinStats (&Pd->Bx, J++ - 1, &r[0], &r[1], &Cen, 0);

                  plot_3d (Pd->Pn, Ax, Ay, 8, X, Y, X, V, Y2, 
                           Beg, End, Cmd, Pd->CInfo, Pd->Cb.Sca);

               }                                       /* END NON-SCAN LOOP  */

               PopUpPlot (PN, 0, 0);                   /* plot box           */
               PlotText (PNuM, K, K, 0, 0);            /* Per Plot Labels    */
               AxisLabs (PN, K++, 0);                  /* axis labels        */
            }                                          /* BEG PLOT LOOP      */
           if (Sc != 0)                            /* Scan mem to free?  */
           {                                       /* BEG FREE SCAN MEM  */
              free (Sc);                           /* let it go          */
              Sc = 0;                              /* free at last       */
           }                                       /* END FREE SCAN MEM  */
           if (Ln != 0)                            /* Xfer mem to free?  */
           {                                       /* BEG FREE XFER MEM  */
              free (Ln);                           /* let it go          */
              Ln = 0;                              /* free at last       */
           }                                       /* END FREE XFER MEM  */
         break;                                        /* STOP SCAN PLOTS    */
      }                                                /* BEG PLOT SWITCH    */

      ZeroWkSp();                                      /* clear plot arrays  */
      if (CanIgn) {                                    /* BEG RESET TIME     */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */
      }                                                /* END RESET TIME     */

      if (Pd->Tm.Fmt != 0) {
         dT = Pd->Tm.R * Pd->Bx.N;                     /* time across plot   */
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else {
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, CanIgn);
         }
      }

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */
} 
