#include <stdio.h>
#include <math.h>
#include "OpSySInD.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

void PlotVecData (ByTe_4 N, struct ToolInfo *Ti, ByTe_1 New) 
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;

   register ReaL_4 *V;
   ReaL_4 T, P, L;

   ByTe_2 *s1, C;
   ByTe_2 SaveCsize;
   ByTe_1 SaveUniv, *Cp;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */

   s1 = &parm.white;                                   /* pointer to white   */
   C = *(s1 + Ti->Color1);                             /* vec output color   */
   if (New && Ti->Src == 1)                            /* new time base?     */
      VecData (&Ti->Vs, &Pd->Pb, &Pd->Pe, Ti->Avg);    /* get vector         */

   if (((Pd->AData[0] == 3 || Pd->AData[0] == 4) && Pd->AData[1] == 5) ||
      ((Pd->AData[1] == 3 || Pd->AData[1] == 4) && Pd->AData[0] == 5)) 
   {
      Cp = (ByTe_1 *)Wa.CStore;                        /* misc char info     */
      SaveCsize = parm.csize;                          /* save cur char size */
      SaveUniv = parm.univ;                            /* save cur plot fmt  */
      parm.csize = Ti->Size;                           /* new character size */
      if (Pd->OutFmt > 0)                              /* map output         */
          parm.univ = Pd->OutFmt + 8;                  /* carteographic fmt  */
      else                                             /* normal plot        */
         set_axis (Pd->Pn, 0, 4, 8);                   /* set to scaled axes */

      V = Ti->Avg;                                     /* return values      */
      L = *V * *V + *(V + 1) * *(V + 1);               /* XY Len squared     */
      L = sqrt(L);                                     /* temp Len           */
      T = atan2 (*(V + 2), L) * 180.0 / M_PI;          /* theta              */
      P = atan2 (*(V + 1), *V) * 180.0 / M_PI;         /* phi                */
      CTEXT (Pd->Wn, P, T, Cp + Ti->Head, C);          /* prnt data vec head */
      P = (P > 0) ? P - 180.0 : 180.0 + P;             /* phi at vec end     */
      T = -T;                                          /* reverse theta      */
      CTEXT (Pd->Wn, P, T, Cp + Ti->Tail, C);          /* prnt data vec tail */
      parm.univ = SaveUniv;                            /* back to orig fmt   */
      parm.csize = SaveCsize;                          /* back to orig Csize */
   }                                                   /* END PLOT SWITCH    */
}
