#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

/*****************************************************************************/
/*  This program puts up all labels associated with a given line plot which  */
/*  need to be put up immediately after the plot is put up on the screen     */
/*  least they be lost.                                                      */
/*****************************************************************************/

void PlotTimes (ByTe_4 PNuM, ByTe_2 sN, ByTe_4 pN, ByTe_4 RpN)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;

   ReaL_4 X1, Y1, X2, Y2, Sz[2], R1, R2, XL, XR, Sn; 
   ByTe_4 N, GrP;
   ByTe_2 *s1, C, RoW, CoL;
   ByTe_1 L0[50], L1[50], Wn; 
   ByTe_1 J1, J2, OK;

   N = PNuM % InFo.NPDefs; 
   GrP = PNuM / InFo.NPDefs; 
   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */

   if (Pd->TimeDir == 1)                               /* time across        */
   {                                                   /* BEG SEQUENTIAL     */
      RoW = pN / Pd->Cols;                             /* current row number */
      CoL = pN % Pd->Cols;                             /* current col number */
   }                                                   /* END SEQUENTIAL     */
   else                                                /* time down          */
   {                                                   /* BEG INCREMENT      */
      RoW = pN % Pd->Rows;                             /* current row number */
      CoL = pN / Pd->Rows;                             /* current col number */
   }                                                   /* END INCREMENT      */

   switch (Pd->Li[0].Occur)                            /* label occurances   */
   {                                                   /* BEG OCCURRANCES    */
      case 0:                                          /* START ONCE         */
        OK = (GrP == 0 && pN == 0 && RpN == 0) ? 1 : 0;  /* OK if first plot */
      break;                                           /* STOP ONCE          */
      case 1:                                          /* START ONCE/PLOT    */
        OK = 1;                                        /* always proceed     */
      break;                                           /* STOP ONCE/PLOT     */
      case 2:                                          /* START ONCE / COL   */
         OK = ((CoL < Pd->Cols) && (RoW == 0)) ? 1 : 0; /* OK if top row     */
      break;                                           /* STOP ONCE / COL    */
      case 3:                                          /* START ONCE / ROW   */
        if (Pd->Li[0].LocA == 6)                       /* right side         */
           OK = ((CoL % Pd->Cols) == (Pd->Cols - 1)) ? 1 : 0; /* right col   */
        else                                                  /* all else    */
           OK = ((CoL % Pd->Cols) ==0) ? 1 : 0;        /* OK left col        */
      break;                                           /* STOP ONCE / ROW    */
      case 4:                                          /* START ONCE         */
        OK = (pN == 0 && RpN == 0) ? 1 : 0;            /* OK if first plot   */
      break;                                           /* STOP ONCE          */
   }                                                   /* END OCCURRANCES    */

   if (!OK)
      return;

   Wn = Pd->Wn;                                        /* plot number        */
   s1 = &parm.white;                                   /* base color         */

   LabelMkr (N, 0, pN, 0, 0, 0, L0);                   /* beg time           */
   if (Pd->Li[0].Fmt == 2)                             /* end time too       */
      LabelMkr (N, 0, pN, 0, 0, 1, L1);                /* end time           */
   else                                                /* no second label    */
      L1[0] = 0;                                       /* null it out        */

   clip (Wn, 0);                                       /* turn off clipping  */

   chr_size (Pd->Li[0].Size);                          /* label size         */
   get_chsz (Sz);                                      /* character size     */

   C = *(s1 + Pd->Li[0].Color);                        /* label color        */
   if (parm.ostyle == 0)                               /* landscape          */
   {                                                   /* BEG LANDSCAPE SETS */
      XL = 0.0;                                        /* Left X Coordinate  */
      XR = 1.0;                                        /* Right X Coordinate */
      Sn = 1.0;                                        /* no reversal        */
   }                                                   /* END LANDSCAPE SETS */
   else                                                /* portrait           */
   {                                                   /* BEG PORTRAIT SETS  */
      XL = 1.0;                                        /* Left X Coordinate  */
      XR = 0.0;                                        /* Right X Coordinate */
      Sn = -1.0;                                       /* reversal           */
   }                                                   /* END PORTRAIT SETS  */
   XL = (parm.ostyle == 0) ? 0.0 : 1.0;                /* Left X Coordinate  */
   XR = (parm.ostyle == 0) ? 1.0 : 0.0;                /* Right X Coordinate */

   if (Pd->Li[0].LocA < 4)                             /* Label Along X-Axis */
   {                                                   /* BEG X SETS         */
      R1 = R2 = 0.0;                                   /* non-rotated labels */
      Y1 = (Pd->Li[0].LocA == 0) ? 0.0 : 1.0;          /* L0 Y begin point   */
      Y1 += Pd->Li[0].YOff * Sz[1];                    /* corrected L0 Y pos */
      Y2 = Y1;                                         /* L1 Y position      */
      if (Pd->Li[0].Fmt == 2 && Pd->Li[0].LocB != 0)   /* not spread them?   */ 
      {                                                /* BEG STACKED LABELS */
         if (Pd->Li[0].YOff > 0.0)                     /* shift up off axis  */
            Y1 += 1.25 * Sz[1];                        /* first label is top */
         else                                          /* other way          */
            Y2 -= 1.25 * Sz[1];                        /* 2nd label is bot   */
      }                                                /* BEG STACKED LABELS */

      switch (Pd->Li[0].LocB)                          /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           X1 = XL + Sn * Pd->Li[0].XOff * Sz[0];      /* pos at left axis   */
           J1 = -1;                                    /* and left justify   */
           X2 = XR - Sn * Pd->Li[0].XOff * Sz[0];      /* pos at right axis  */
           J2 = 1;                                     /* and right justify  */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           X1 = XL + Sn * Pd->Li[0].XOff * Sz[0];      /* pos at left axis   */
           J1 = -1;                                    /* and left justify   */
           X2 = X1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           X1 = 0.5 + Sn * Pd->Li[0].XOff * Sz[0];     /* pos at center axis */
           J1 = 0;                                     /* and center justify */
           X2 = X1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           X1 = XR + Sn * Pd->Li[0].XOff * Sz[0];      /* pos at right axis  */
           J1 = 1;                                     /* and right justify  */
           X2 = X1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END X SETS         */
   else                                                /* label along Y      */
   {                                                   /* BEG Y SETS         */
      R1 = (Pd->Li[0].LocA == 4) ? 90.0 : -90.0;       /* L0 label rotation  */
      R2 = (Pd->Li[0].LocB != 0) ? 90.0 : -90.0;       /* L1 label rotation  */
      X1 = (Pd->Li[0].LocA == 4) ? XL : XR;            /* L0 X begin point   */
      X1 += Sn * Pd->Li[0].XOff * Sz[0];               /* corrected L0 X pos */
      X2 = X1;                                         /* L1 X pos           */
      if (Pd->Li[0].Fmt == 2)                          /* dual labels?       */ 
      {                                                /* BEG TWO LABELS     */
         if (Pd->Li[0].LocB == 0)                      /* spread them?       */ 
            X2 = XR - Sn * Pd->Li[0].XOff * Sz[0];     /* corrected L1 X pos */
         else                                          /* they are stacked   */
         {                                             /* BEG STACKED        */
            if (Pd->Li[0].XOff > 0.0)                  /* shift up off axis  */
               X2 += Sn * 1.25 * Sz[0];                /* first label is top */
            else                                       /* other way          */
               X1 -= Sn * 1.25 * Sz[0];                /* 2nd label is bot   */
         }                                             /* END STACKED        */
      }                                                /* END TWO LABELS     */

      switch (Pd->Li[0].LocB)                          /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           Y1 = 0.5 + Pd->Li[0].YOff * Sz[1];          /* pos at left axis   */
           J1 = 0;                                     /* and left justify   */
           Y2 = Y1;                                    /* pos at right axis  */
           J2 = J1;                                    /* and right justify  */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           Y1 = Pd->Li[0].YOff * Sz[1];                /* pos at left axis   */
           J1 = -1;                                    /* and left justify   */
           Y2 = Y1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           Y1 = 0.5 + Pd->Li[0].YOff * Sz[1];          /* pos at center axis */
           J1 = 0;                                     /* and center justify */
           Y2 = Y1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           Y1 = 1.0 + Pd->Li[0].YOff * Sz[1];          /* pos at right axis  */
           J1 = -1;                                    /* and right justify  */
           Y2 = Y1;                                    /* same X position    */
           J2 = J1;                                    /* same justification */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END Y SETS         */

   chr_dspl (Wn, X1, Y1, 0., R1, 0., 0., 0, J1, L0, -1, C); /* beg tm        */
   chr_dspl (Wn, X2, Y2, 0., R2, 0., 0., 0, J2, L1, -1, C); /* end tm        */
}
