#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all labels associated with a given line plot which  */
/*  need to be put up immediately after the plot is put up on the screen     */
/*  least they be lost.                                                      */
/*****************************************************************************/

void PlotText (ByTe_4 PNuM, ByTe_2 sN, ByTe_4 Pn, ByTe_4 RelPn, ByTe_2 Coff)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct window  *wN;
   struct SrcInfo *S;
   struct ToolInfo *Ti;
   struct ConTouR *Ct;

   register ByTe_2 *s1;

   ReaL_4 TMin[2], TMax[2], R;
   ByTe_4 RpN, N;
   ByTe_2 I, J, C, Lev, SrcN, PoS;
   ByTe_1 TSca[2], CLab[40];

   N = PNuM % InFo.NPDefs;

   CLab[0] = 0;
   Pd = (struct PlotDef *)InFo.PlotDefs + N;         /* plot info struct     */
   window (Pd->Wn, "PLOTTEXT");                      /* make window current  */
   wN = parm.win;                                    /* current window info  */
   for (I = 0; I < 2; ++I)                           /* save scale loop      */
   {                                                 /* BEG SAVE/SET LOOP    */
       TSca[I] = wN->axis[I];                        /* save axis scale      */
       TMin[I] = wN->plot[I];                        /* save axis min        */
       TMax[I] = wN->plot[3+I];                      /* save axis max        */
       wN->axis[I] = 0;                              /* set axis scale lin   */
       wN->plot[I] = 0.0;                            /* set axis min         */
       wN->plot[3+I] = 1.0;                          /* set axis max         */
   }                                                 /* END SAVE/SET LOOP    */
   scale_win(0);                                     /* rescale              */

   if (Pd->Li[0].Fmt != -1 && Pd->Li[0].Fmt != 3)    /* show time label?     */
      PlotTimes (PNuM, sN, Pn, RelPn);               /* put out time labels  */

   PoS = (Pd->Li[1].Fmt >= 0) ? 1 : (Pd->Li[2].Fmt >= 0) ? 2 : 1;
   if (Pd->Li[PoS].Fmt >= 0)                         /* source labels        */
   {                                                 /* BEG SOURCE LABELS    */
      if (Pd->DoSrcs == 0)                           /* sources merged?      */
      {                                              /* BEG LABEL ALL        */
         RpN = 0;                                    /* relative plot number */
         s1 = (ByTe_2 *)Pd->SOrder;                  /* source order array   */
         SrcN = *s1++;                               /* first source num     */
         if (PoS == 1)                               /* all sources          */
         {                                           /* BEG THE WORKS        */
            for (I = 0; I < Pd->EmptySrc; ++RpN)     /* loop over graphs     */
            {                                        /* BEG GRAPH LOOP       */
               S = (struct SrcInfo *)Pd->Src + SrcN;        /* pntr to src   */
               GenLabs (PNuM, SrcN, Pn, RelPn, PoS, 0, I, Coff, CLab);
               if (RpN >= S->Col.N)                         /* done with src */
               {                                     /* BEG DONE WITH SRC    */
                   SrcN = *s1++;                     /* next src             */
                   RpN = 0;                          /* reset rel plot num   */
                   ++I;                              /* increment src cnt    */
               }                                     /* END DONE WITH SRC    */
            }                                        /* END GRAPH LOOP       */
         }                                           /* BEG THE WORKS        */
         else
           GenLabs (PNuM, SrcN, Pn, RelPn, PoS, 0, 0, Coff, CLab);
      }                                              /* END LABEL ALL        */
      else                                           /* just this source     */
      {                                              /* BEG ONE LABEL        */
         S = (struct SrcInfo *)Pd->Src + sN;         /* pntr to src          */
         if (Pd->Li[PoS].LocA > 3 && Pd->Li[PoS].LocB == 2 && S->LpType == 10)
         {                                           /* BEG SPECSCA ORIG Y   */
            wN->axis[1] = TSca[1];                   /* reset Y axis scale   */
            wN->plot[1] = TMin[1];                   /* reset Y axis min     */
            wN->plot[4] = TMax[1];                   /* reset Y axis max     */
            scale_win(0);                            /* rescale              */
            Lev = 0;                                 /* all same level       */
         }                                           /* END SPECSCA ORIG Y   */
         else
            Lev = RelPn % Pd->Stack;                 /* label level          */
         GenLabs (PNuM, sN, Pn, RelPn, PoS, 0, Lev, Coff, CLab);
      }                                              /* END ONE LABEL        */
   }                                                 /* END SOURCE LABELS    */

   S = (struct SrcInfo *)Pd->Src + sN;               /* pntr to src          */
   if(S->Col.Fmt >= 0 && Pd->Li[3].Occur != 4 && Pd->Li[3].Fmt != -1)
     GenLabs (PNuM, sN, Pn, RelPn, 3, 0, 0, Coff, CLab); /* label this one   */

   if(Pd->Li[4].Fmt >= 0 && Pd->NTools > 0) {        /* BEG TOOL LABELS      */
      Ti = (struct ToolInfo * ) Pd->Tools;           /* Tool info            */
      J = 0;                                         /* current level        */
      for (I = 0; I < Pd->NTools; ++Ti, ++I) {       /* BEG TOOL LOOP        */
         if (Pd->Li[4].Fmt == 0)                     /* need tool labels     */
            GenLabs (PNuM, sN, Pn, RelPn, 4, Ti->Type, J++, Coff, CLab);
         if ((Ti->Type == 3 || Ti->Type == 4) && Ti->LShell > 0) {
            C = 100;
            for (R = Ti->LRng[0]; R <= Ti->LRng[1]; R += Ti->LRng[2]) {
               sprintf (CLab, "L %.1f", R); 
               GenLabs (PNuM, sN, Pn, RelPn, 4, Ti->Type, J++, C++, CLab);
            }
         }
      }                                              /* END TOOL LOOP        */
      CLab[0] = 0;
      if (Pd->IncCont == 1 && Pd->Li[4].Fmt == 0)    /* contour tool?        */
         GenLabs (PNuM, sN, Pn, RelPn, 4, 2, J, Coff, CLab); 
   }                                                 /* END TOOL LABELS      */

   if (Pd->AData[0] == 8 && Pd->Li[5].Fmt >= 0)      /* Contour Plot         */
   {                                                 /* BEG 3D PLANE LABELS  */
      Ct = (struct ConTouR *)Pd->Cont;               /* contour info         */
      if (Ct->Method == 0)                            /* 3D                  */
      {                                               /* BEG 3D LABELS       */ 
         for (I = 0; I < 5; ++I)                      /* label loop          */
            GenLabs (PNuM, sN, Pn, RelPn, 5, I, I, Coff, CLab); 
      }                                               /* END 3D LABELS       */ 
   }                                                 /* END 3D PLANE LABELS  */

   for (I = 0; I < 2; ++I)                           /* reset scale loop     */
   {                                                 /* BEG RESET LOOP       */
       wN->axis[I] = TSca[I];                        /* reset axis scale     */
       wN->plot[I] = TMin[I];                        /* reset axis min       */
       wN->plot[3+I] = TMax[I];                      /* reset axis max       */
   }                                                 /* END RESET LOOP       */
   scale_win(0);                                     /* rescale              */
}
