#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "gph_opind.h"
#include "gph_shortcut_defs.h"

void PlotObj (ByTe_4 N, struct ToolInfo *Ti, ByTe_1 New, ByTe_4 pN) 
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct TiMiNg Mt;

   ReaL_4 Elev, Phase, Ang1, Ang2, P1, P2;
   ReaL_4 A11, A12, A13;
   ReaL_4 A21, A22, A23;
   ReaL_4 A31, A32, A33;
   ReaL_4 X, Y, Z;
   ReaL_4 X1, Y1, Z1;
   ReaL_4 X2, Y2, Z2;

   ReaL_4 Mag, GsT, cGsT, sGsT;
   ReaL_8 MjD;
   ReaL_4 gLnG, gLaT, gLnGo, gLaTo, gLnGs, gLaTs;
   ByTe_2 Dy, Mo;
   ByTe_2 rV1, rV2, rV3;
   ByTe_1 SUniV, Ewn;

   ReaL_4 Ox, Oy, Oz;
   ReaL_4 Ex, Ey, Ez;
   ReaL_4 Sx, Sy, Sz;
   ReaL_4 MagE, MagO;
   ReaL_4 Re = 6371.0, A;

   ReaL_4 RToD;
   ByTe_2 *s1, C, SaveCsize, SVcolor;
   ByTe_1 *Cp;

   /**************************************************************************/
   /*                            INITIALIZATIONS                             */
   /**************************************************************************/

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */
   SaveCsize = parm.csize;                             /* current  char size */
   SVcolor = parm.l_color;                             /* current plot color */
   SUniV = parm.univ;                                  /* current plot fmt   */
   Cp = (ByTe_1 *)Wa.CStore;                           /* misc char info     */
   RToD = 180.0 / M_PI;                                /* radians to degrees */
   s1 = &parm.white;                                   /* color white        */
   C = *(s1 + Ti->Color1);                             /* object color       */

   /**************************************************************************/
   /* Get the vector data needed                                             */
   /**************************************************************************/

   if (New && Ti->Src == 1)                            /* new time base?     */
      rV1 = VecData (&Ti->Vs, &Pd->Pb, &Pd->Pe, Ti->Avg);    /* get S/C pos  */
   if (New && Ti->Src1 == 1)                           /* new time base?     */
      rV2 = VecData (&Ti->Vs1, &Pd->Pb, &Pd->Pe, Ti->Avg1);  /* get Sp Axis  */
   if (New && Ti->Src2 == 1)                           /* new time base?     */
      rV3 = VecData (&Ti->Vs2, &Pd->Pb, &Pd->Pe, Ti->Avg2);  /* get Obj Pos  */

   if (rV1 == 0 || rV2 == 0 || rV3 == 0)
      return;

   /**************************************************************************/
   /* Only can do it an angle/angle plot.  If not then quit                  */
   /**************************************************************************/

   if (!(((Pd->AData[0] == 3 || Pd->AData[0] == 4) && Pd->AData[1] == 5) ||
      ((Pd->AData[1] == 3 || Pd->AData[1] == 4) && Pd->AData[0] == 5)))
      return;

   /**************************************************************************/
   /* Form unit vectors                                                      */
   /**************************************************************************/

   MagE = sqrt (Ti->Avg[0] * Ti->Avg[0] + Ti->Avg[1] * Ti->Avg[1]
                + Ti->Avg[2] * Ti->Avg[2]);            /* Distance to S/C    */
   Ex = Ti->Avg[0] / MagE;                             /* S/C Unit GCI X     */
   Ey = Ti->Avg[1] / MagE;                             /* S/C Unit GCI Y     */
   Ez = Ti->Avg[2] / MagE;                             /* S/C Unit GCI Z     */

   Mag = sqrt (Ti->Avg1[0] * Ti->Avg1[0] + Ti->Avg1[1] * Ti->Avg1[1] 
               + Ti->Avg1[2] * Ti->Avg1[2]);           /* Spin Axis Mag      */
   Sx = Ti->Avg1[0] / Mag;                             /* Spn Ax Unit GCI X  */
   Sy = Ti->Avg1[1] / Mag;                             /* Spn Ax Unit GCI Y  */
   Sz = Ti->Avg1[2] / Mag;                             /* Spn Ax Unit GCI Z  */

   MagO = sqrt (Ti->Avg2[0] * Ti->Avg2[0] + Ti->Avg2[1] * Ti->Avg2[1] 
               + Ti->Avg2[2] * Ti->Avg2[2]);           /* Object Magnitude   */
   Ox = Ti->Avg2[0] / MagO;                            /* Object Unit GCI X  */
   Oy = Ti->Avg2[1] / MagO;                            /* Object Unit GCI Y  */
   Oz = Ti->Avg2[2] / MagO;                            /* Object Unit GCI Z  */

   /**************************************************************************/
   /* Compute the Greenwich Siderial Time of the vectors                     */
   /**************************************************************************/

   MidTime (&Pd->Pb, &Pd->Pe, &Mt);
   MjD = TransDate (Mt.Ms, Mt.Dy, 1, Mt.Yr, &Dy, &Mo, 5);  
   GsT = 100.641 + 36000.77 * (MjD - 51544.5)/36525.0 + 
               15.04107 * Mt.Ms/3600000.0;
   GsT = fmod(GsT, 360.0);
   if (GsT < 0.0)
      GsT += 360.0;

   GsT /= RToD;
   cGsT = cos (GsT);
   sGsT = sin (GsT);

   /**************************************************************************/
   /* Compute the equivalent geographic latitude and longitude of the object */
   /* and the satellite spin axis.                                           */
   /**************************************************************************/

   X = cGsT * Ex + sGsT * Ey;                          /* X proj onto earth  */
   Y = -sGsT * Ex + cGsT * Ey;                         /* Y proj onto earth  */
   gLnG = atan2 (Y, X) * RToD;                         /* Object Longitude   */
   gLaT = atan2 (Ez, sqrt(X * X + Y * Y)) * RToD;      /* Object Latitude    */

   X = cGsT * Sx + sGsT * Sy;                          /* X proj Spin axis   */
   Y = -sGsT * Sx + cGsT * Sy;                         /* Y proj Spin axis   */
   gLnGs = atan2 (Y, X) * RToD;                        /* Spin axis Long     */
   gLaTs = atan2 (Sz, sqrt(X * X + Y * Y)) * RToD;     /* Spin axis Lat      */

   X = cGsT * Ox + sGsT * Oy;                          /* X proj Object      */
   Y = -sGsT * Ox + cGsT * Oy;                         /* Y proj Object      */
   gLnGo = atan2 (Y, X) * RToD;                        /* Object Longitude   */
   gLaTo = atan2 (Oz, sqrt(X * X + Y * Y)) * RToD;     /* Object Latitude    */

   /**************************************************************************/
   /* Set character size and output universe                                 */
   /**************************************************************************/

   parm.csize = Ti->Size;                              /* new character size */
   if (Pd->OutFmt > 0)                                 /* map output         */
      parm.univ = Pd->OutFmt + 8;                      /* carteographic fmt  */
   else                                                /* normal plot        */
      set_axis (Pd->Pn, 0, 4, 8);                      /* set to scaled axes */

   /**************************************************************************/
   /* Object output begins here                                              */
   /**************************************************************************/

   switch (Ti->DisplayFmt)
   {
      case 0:                                          /* Start ThreeD       */
      case 1:                                          /* Start TwoD         */
        clip (Pd->Wn, 2);                              /* turn on clipping   */
        Ang1 = atan2 (Sy, Sx);                         /* Spin axis Phi      */
        Ang2 = atan2 (Sz, sqrt(Sx * Sx + Sy * Sy));    /* Spin Axis Theta    */

   /**************************************************************************/
   /* Set up a rotation matrix which will rotate the satellite spin axis to  */
   /* the X axis                                                             */
   /**************************************************************************/

        A11 = cos (Ang1);
        A12 = sin (Ang1);
        A13 = 0.0;
        A21 = -sin (Ang1) * cos (Ang2);
        A22 = cos (Ang1) * cos (Ang2);
        A23 = sin (Ang2);
        A31 = sin (Ang1) * sin (Ang2);
        A32 = -cos (Ang1) * sin (Ang2);
        A33 = cos (Ang2);

   /**************************************************************************/
   /* Rotate, Spin Axis, Object, and S/C to coordinate system with spin axis */
   /* along X.                                                               */
   /**************************************************************************/

        X = A11 * Ox + A12 * Oy + A13 * Oz;
        Y = A21 * Ox + A22 * Oy + A23 * Oz;
        Z = A31 * Ox + A32 * Oy + A33 * Oz;
        X1 = A11 * Sx + A12 * Sy + A13 * Sz;
        Y1 = A21 * Sx + A22 * Sy + A23 * Sz;
        Z1 = A31 * Sx + A32 * Sy + A33 * Sz;
        X2 = A11 * Ex + A12 * Ey + A13 * Ez;
        Y2 = A21 * Ex + A22 * Ey + A23 * Ez;
        Z2 = A31 * Ex + A32 * Ey + A33 * Ez;

   /**************************************************************************/
   /* Determine the angle of the object off the spin axis.  This is the      */
   /* elevation of the object as seen from the spin axis                     */
   /**************************************************************************/

        Elev = acos (X1 * X + Y1 * Y + Z1 * Z) * RToD;
        Elev = 90.0 - Elev;

   /**************************************************************************/
   /* Compute the spin phase at which the object is located.  The negative   */
   /* sign added at end is due to the fact that the X-axis in reality is     */
   /* actuall -Xgei (?)                                                      */
   /**************************************************************************/

        P1 = atan2 (-Z2,  -Y2) * RToD;
        P2 = atan2 (MagO * Z - MagE * Z2,  MagO * Y - MagE * Y2) * RToD;
        Phase = P2 - P1;

   /**************************************************************************/
   /* Make adjustments for fact that plot may be 0 to 360 or -180 to 180.    */
   /* Also need to reverse Phase and Elevation if the plot has Phase along   */
   /* X and not Elevation                                                    */
   /**************************************************************************/

        if (Pd->AData[0] == 5)
        {
           if (Phase > Pd->Yl.Max)
              Phase = Phase - 360.0;
           else if (Phase < Pd->Yl.Min)
              Phase = 180 - Phase;
           
        }
        else
        {
           if (Phase > Pd->Xb.Max)
              Phase = Phase - 360.0;
           else if (Phase < Pd->Xb.Min)
              Phase = 180 - Phase;
           P1 = Phase;
           Phase = Elev;
           Elev = P1;
        }

   /**************************************************************************/
   /* Plot out object position.                                              */
   /**************************************************************************/

        CTEXT (Pd->Wn, Elev, Phase, Cp + Ti->Head, C); 
        clip (Pd->Wn, 0);
      break;                                           /* Stop 2D/3D         */

      case 2:                                          /* Start Sub-Point    */
        A = atan2 (1.0, MagE/Re) * RToD;
        Ewn = EarthWin (N, Ti, &Ti->Avg1[0], A, gLaT, gLnG, gLaTs, gLnGs);
        clip (Ewn, 2);
        CTEXT (Ewn, gLnGo, gLaTo, Cp + Ti->Head, C); 
        clip (Ewn, 0);
      break;                                           /* Stop Sub-Point     */
   }

   if (Ti->Terminator == 1)
      DrTerminator (N, GsT, Ti); 
   if (Ti->LShell != 0) { 
      A = atan2 (1.0, MagE/Re) * RToD;
      Ewn = EarthWin (N, Ti, &Ti->Avg1[0], A, gLaT, gLnG, gLaTs, gLnGs);
      LShells (Ewn, N, gLnGo, Ti, pN);
   }

   parm.univ = SUniV;                              
   parm.csize = SaveCsize;                        
   plt_color (0, SVcolor);
}
