#include <stdlib.h>
#include <math.h>
#include "util_str.h"
#include "idf_defs.h"
#include "user_defs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void PixRes (struct PlotDef *Pd, ByTe_4 SrcN)
{
   extern struct UserDefs InFo;
   struct idf_data  *ExDa;

   struct SrcInfo  *S;

   ReaL_8 dT;

   ExDa = (struct idf_data *) InFo.UDF;              /* ptr to data          */
   TmRes (Pd, SrcN);                                 /* time resolution      */

   if (Pd->Pb.Yr < 0)                                /* need beg plot set    */
   {                                                 /* BEG SET BEG TIME     */
      Pd->Pb.Yr = ExDa->byear;                       /* start year of plot   */
      Pd->Pb.Dy = ExDa->bday;                        /* start day of plot    */
      Pd->Pb.Ms = ExDa->bmilli;                      /* start msec of plot   */
      Pd->Pb.Ns = ExDa->bnano;                       /* start nano of plot   */
   }                                                 /* END SET BEG TIME     */

   S = (struct SrcInfo *) Pd->Src + SrcN;            /* source structure     */

   if (S->Col.N > 1)                                 /* set up collapse blk  */
   {                                                 /* BEG SCAN COLLAPSE    */
      if (S->Col.Sca == 1)                           /* if log scaling       */
      {                                              /* BEG TAKE LOGS        */
         S->Col.Stop = log(S->Col.Stop);             /* log end val          */
         S->Col.Start = log(S->Col.Start);           /* log start value      */
      }                                              /* END TAKE LOGS        */
      dT = (S->Col.Pos == 0) ? S->Col.N - 1 : S->Col.N;  /* bins to form     */
      S->Col.R = (S->Col.Stop - S->Col.Start) / dT;      /* step resolution  */
      S->Col.Dir = 1;                                /* resolution           */
   }                                                 /* END SCAN COLLAPSE    */

   if (Pd->Bx.R == 0.0)
      AxisRes (Pd, 0);
   if (Pd->Byl.R == 0.0)
      AxisRes (Pd, 1);
   if (Pd->Byr.R == 0.0)
      AxisRes (Pd, 2);

/*
   if (Pd->AData[0] != 0 && S->OneAll != 3)
*/
   if (Pd->AData[0] != 0)
     IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, 1); /* set plot end time */
}
