#include <stdio.h>
#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ReaL_4 PerCentAge (ReaL_4 L, ReaL_4 R, ReaL_4 From, ReaL_4 To)
{
   ReaL_4 T;
   ReaL_4 P = 0;

   ByTe_1 Type;

   if (L > R)                                         /* backwards bin?      */
   {                                                  /* looks that way      */
      T = L;                                          /* Left to tmp         */
      L = R;                                          /* Right to Left       */
      R = T;                                          /* Left to Right       */
   }
 
   if (L >= To || R <= From)                          /* not in bin?         */
      return (P);                                     /* nope                */
        
   if (From == To)
      Type = 3;
   else
   {
      Type = (L >= From && L <= To) ? 1 : 0;          /* left status         */
      Type += (R >= From && R <= To) ? 2 : 0;         /* combined status     */
   }

   switch (Type)
   {
      case 0:
         P = (To - From)/(R - L);                    /* this is percentage  */
      break;
      case 1:
         P = (To - L)/(R - L);                       /* partial bin         */
      break;
      case 2:
         P = (R - From)/(R - L);                     /* partial bin         */
      break;
      case 3:
         P = 1.0;                                    /* whole bin           */
      break;
   }

   return (P);
} 
