#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "Gmenu_str.h"
#include "libbase_udf.h"
#include "libCfg.h"

void NeedAlt (struct SrcInfo *S)
{
   extern struct UserDefs InFo;

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfScan *Pc;
   struct PidfSensor *Ps;
   struct PidfAnc *Pa;

   ReadPidf(S->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;


   if (S->SAltUN >= 0)
   {
      Pa = (struct PidfAnc *)P->Ancil + S->SAltPN;
      Pu = (struct PidfUnit *)P->Units + S->SAltUN;            
      S->SAltVN = Pa->VidfNum;
      S->SAltNAS = Pu->NTbls;                                 
      if (Pu->NTbls > 0)                                       
      {
         S->SAltTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
         S->SAltOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
      }
   }

   if (S->AltUN >= 0)
   {
      Ps = (struct PidfSensor *)P->Sensors + S->SenPN;
      Pu = (struct PidfUnit *)P->Units + S->AltUN;            
      S->AltNAS = Pu->NTbls;                                 
      if (Pu->NTbls > 0)                                       
      {
         S->AltTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls); 
         S->AltOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls); 
      }

      Pc = (struct PidfScan *)P->Scans + Ps->ScanBlk;         
      S->AltSca = *(Pc->Step + S->AltSB); 

      if (S->AltSca == 'V')
      {
         S->SecSca = *(Pc->Loc + S->AltSB); 
         S->SecUN = *(Pc->VUnits + S->AltSB); 
         Pu = (struct PidfUnit *)P->Units + S->SecUN;            
         S->SecNAS = Pu->NTbls;                                 
         if (Pu->NTbls > 0)                                       
         {
            S->SecTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls); 
            S->SecOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls); 
         }
      }
   }
}
