#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuVUDF (struct VSrcInfo *Vs, ByTe_2 N)
{
   extern struct MeNuS Ms;
   extern struct WorkArea Wa;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;

   ByTe_4  I; 
   ByTe_2  R;
   ByTe_1  *C;

   /*************************************************************************/
   /*             IDFS INFO MENU TRANSFER                                   */
   /*                                                                       */
   /* ID[00]:  PROJECT                                                      */
   /* ID[01]:  MISSION                                                      */
   /* ID[02]:  EXPERIMENT                                                   */
   /* ID[03]:  INSTRUMENT                                                   */
   /* ID[04]:  VIRTUAL                                                      */
   /* ID[05]:  X: DATA GROUP                                                */
   /* ID[06]:  X: COMPONENT (VIDF SENSOR NUMBER)                            */
   /* ID[07]:  X: SENSOR UNITS                                              */
   /* ID[08]:  X: MINIMUM VALID DATA RANGE                                  */
   /* ID[09]:  X: MAXIMUM VALID DATA RANGE                                  */
   /* ID[10]:  Y: DATA GROUP                                                */
   /* ID[11]:  Y: COMPONENT (VIDF SENSOR NUMBER)                            */
   /* ID[12]:  Y: SENSOR UNITS                                              */
   /* ID[13]:  Y: MINIMUM VALID DATA RANGE                                  */
   /* ID[14]:  Y: MAXIMUM VALID DATA RANGE                                  */
   /* ID[15]:  Z: DATA GROUP                                                */
   /* ID[16]:  Z: COMPONENT (VIDF SENSOR NUMBER)                            */
   /* ID[17]:  Z: SENSOR UNITS                                              */
   /* ID[18]:  Z: MINIMUM VALID DATA RANGE                                  */
   /* ID[19]:  Z: MAXIMUM VALID DATA RANGE                                  */
   /*************************************************************************/

   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ;
   Vs->Vb.Yr = -1;

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            Vs->P = TransFer (Qs->CReply, 1, 0);
         break;
         case 1:
            Vs->M = TransFer (Qs->CReply, 1, 0);
         break;
         case 2:
            Vs->E = TransFer (Qs->CReply, 1, 0);
         break;
         case 3:
            Vs->I = TransFer (Qs->CReply, 1, 0);
         break;
         case 4:
            Vs->V = TransFer (Qs->CReply, 1, 0);
         break;
         case 5:
         case 10:
         case 15:
            I = (Qs->ID - 5) / 5;
            Vs->Group[I] = Qs->OpReply;
         break;
         case 6:
         case 11:
         case 16:
            I = (Qs->ID - 5) / 5;
            sscanf (Qs->AltVal, "%hd", &Vs->SenPN[I]);
         break;
         case 7:
         case 12:
         case 17:
            I = (Qs->ID - 5) / 5;
            sscanf (Qs->AltVal, "%hd", &Vs->SenUN[I]);
         break;
         case 8:
         case 13:
         case 18:
            I = (Qs->ID - 5) / 5;
            sscanf (Qs->CReply, "%f", &Vs->MinValid[I]);
         break;
         case 9:
         case 14:
         case 19:
            I = (Qs->ID - 5) / 5;
            sscanf (Qs->CReply, "%f", &Vs->MaxValid[I]);
         break;
      }
   }

   
   C = (ByTe_1 *)Wa.CStore;                  
   R = get_data_key (C + Vs->P, C + Vs->M, C + Vs->E, 
                     C + Vs->I, C + Vs->V, &Vs->Key);
   ErrorRpt ("GET_DATA_KEY", R, 1); 
}
