#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuPlotDef (ByTe_2 SrcN)
{
   extern struct UserDefs InFo;
   extern struct MeNuS Ms;
   extern struct WorkArea Wa;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct PlotDef *Pd;

   register ByTe_1  *c1, *c2, *c3, *c4;

   ReaL_4  TmpF; 
   size_t  B;
   ByTe_4  PN, ToolType; 
   ByTe_2  N0, N1, N2, Src, EnD;
   ByTe_2  VSrcs = 0;
   ByTe_1  TmpS[20], TmpT[20], DoDisplay = 0;

   c1 = (ByTe_1 *)Wa.CStore + InFo.PSrcs;

 /****************************************************************************/
 /* Retrieve the Nth Plot Definition Menu Page Number and the plot type      */
 /****************************************************************************/

   Src = -1;
   while (Src < SrcN)
   {
      c2 = TmpS;

      while (*c1 == ' ')
         ++c1;

      while((*c1 != ' ') && (*c1 != 0))
         *c2++ = *c1++;
      *c2 = 0;

      ++Src;
   }

   sscanf (TmpS, "%d", &PN);

 /****************************************************************************/
 /*                          LINE PLOT MENU TRANSFER                         */
 /*                                                                          */
 /*  ID[00] PLOT ROWS                                                        */
 /*  ID[01] PLOT COLUMNS                                                     */
 /*  ID[02] OUTPUT FORMAT                           [0 = CARTESIAN         ] */
 /*                                                 [1 = MERCATOR          ] */
 /*                                                 [2 = SINUSOIDAL        ] */
 /*                                                 [3 = MOLWEIDE          ] */
 /*                                                 [4 = ECKERT SINUSOIDAL ] */
 /*                                                 [5 = ECKERT ELLIPSOIDL ] */
 /*                                                 [6 = POLAR             ] */
 /*                                                 [7 = AZIMUTHAL         ] */
 /*                                                 [8 = CONIC             ] */
 /*  ID[03] LOWER X AXIS IS FUNCTION OF             [0 = TIME              ] */
 /*                                                 [1 = VALUE             ] */
 /*                                                 [2 = SCAN              ] */
 /*                                                 [3 = SPIN ANGLE        ] */
 /*                                                 [4 = PITCH ANGLE       ] */
 /*                                                 [5 = THETA ANGLE       ] */
 /*                                                 [6 = SENSOR NUMBER     ] */
 /*  ID[04] LEFT Y AXIS IS FUNCTION OF              [0 = TIME              ] */
 /*                                                 [1 = VALUE             ] */
 /*                                                 [2 = SCAN              ] */
 /*                                                 [3 = SPIN ANGLE        ] */
 /*                                                 [4 = PITCH ANGLE       ] */
 /*                                                 [5 = THETA ANGLE       ] */
 /*                                                 [6 = SENSOR NUMBER     ] */
 /*  ID[05] RIGHT Y AXIS IS FUNCTION OF             [1 = VALUE             ] */
 /*  ID[06] PLOT GAPS ALONG LOWER X AXIS            [0 = IGNORE            ] */
 /*                                                 [1 = FILL              ] */
 /*  ID[07] PLOT GAPS ALONG LEFT Y AXIS             [0 = IGNORE            ] */
 /*                                                 [1 = CONSTANT FILL     ] */
 /*                                                 [2 = LINEAR FILL       ] */
 /*  ID[08] METHOD TO STORE DATA ALONG LOWER X AXIS [0 = POINT             ] */
 /*                                                 [1 = BAND              ] */
 /*  ID[09] METHOD TO STORE DATA ALONG LEFT Y AXIS  [0 = POINT             ] */
 /*                                                 [1 = BAND              ] */
 /*  ID[10] PIXEL TIMING                            [0 = BY PLOT TIME      ] */
 /*                                                 [1 = USER DEFINED      ] */
 /*  ID[11] INTERVAL                                                         */
 /*  ID[12] UNITS                                   [0 = YEARS             ] */
 /*                                                 [1 = DAYS              ] */
 /*                                                 [2 = HOURS             ] */
 /*                                                 [3 = MINUTES           ] */
 /*                                                 [4 = SECONDS           ] */
 /*                                                 [5 = MILLISECONDS      ] */
 /*                                                 [6 = MICROSECONDS      ] */
 /*                                                 [7 = NANOSECONDS       ] */
 /*                                                 [8 = SPIN PERIODS      ] */
 /*                                                 [9 = MEASUREMENT       ] */
 /*  ID[13] SOURCE NUMBER                                                    */
 /*  ID[14] X-AXIS BINNING                          [0 = PIXEL NUMBER      ] */
 /*                                                 [1 = USER DEFINED      ] */
 /*  ID[15] X BEGIN                                                          */
 /*  ID[16] X END                                                            */
 /*  ID[17] NUMBER OF BINS                                                   */
 /*  ID[18] LIMITS ARE                              [0 = CENTERS, 1 = ENDS ] */
 /*  ID[19] BIN SCALING                             [0 = LINEAR, 1 = LOG   ] */
 /*  ID[20] Y-AXIS BINNING                          [0 = PIXEL NUMBER      ] */
 /*                                                 [1 = USER DEFINED      ] */
 /*  ID[21] Y BEGIN                                                          */
 /*  ID[22] Y END                                                            */
 /*  ID[23] NUMBER OF BINS                                                   */
 /*  ID[24] LIMITS ARE                              [0 = CENTERS, 1 = ENDS ] */
 /*  ID[25] BIN SCALING                             [0 = LINEAR, 1 = LOG   ] */
 /*  ID[26] SOURCES                                 [0 = MERGE             ] */
 /*                                                 [1 = SEPARATE          ] */
 /*  ID[27] IN AVERAGES                             [0 = INCLUDE ZEROS     ] */
 /*                                                 [1 = EXCLUDE ZEROS     ] */
 /*  ID[28] EMPTY PLOTS                             [0 = IGNORE, 1 = PLOT  ] */
 /*  ID[29] GAP WIDTHS                              [0, 1, 2 pixels        ] */
 /*  ID[30] MAP GRIDS                               [2 = NONE              ] */
 /*                                                 [0 = OVERLAY           ] */
 /*                                                 [1 = UNDERLAY          ] */
 /*  ID[31] GRID COLOR                                                       */
 /*  ID[32] DELTA LATITUDE                                                   */
 /*  ID[33] LATITUDE ROTATION                                                */
 /*  ID[34] LATITUDE TERMINATION                                             */
 /*  ID[35] DELTA LONGITUDE                                                  */
 /*  ID[36] LONGITUDE ROTATION                                               */
 /*  ID[37] MAP OUTLINES                            [2 = NONE              ] */
 /*                                                 [0 = OVERLAY           ] */
 /*                                                 [1 = UNDERLAY          ] */
 /*  ID[37] MAP COLOR                                                        */
 /*  ID[39] MAP RESOLUTION                                                   */
 /*  ID[40] UDF SOURCE                                                       */
 /*  ID[41] PLOT TOOLS                              [0 = FLOW REMOVAL      ] */
 /*                                                 [1 = SHOW VECTOR       ] */
 /*                                                 [2 = DO CONTOUR        ] */
 /****************************************************************************/

   Pd = (struct PlotDef *)InFo.PlotDefs + InFo.EmptyPd++;
   Pd->Src = 0;
   Pd->OutFmt = 0;
   Pd->SyncSrcs = 0;
   Pd->Tm.R = -1;
   Pd->Tm.OrigR = -1;
   Pd->Bx.R = 0;
   Pd->Byl.R = 0;
   Pd->Byr.R = 0;
   Pd->Bx.Pos = 1;
   Pd->Byl.Pos = 1;
   Pd->Byr.Pos = 1;
   Pd->Xb.Sca = 0;
   Pd->Xt.Sca = 0;
   Pd->Yl.Sca = 0;
   Pd->Yr.Sca = 0;
   Pd->Byr.Fmt = 0;
   Pd->IncCont = 0;
   Pd->Cont = 0;
   Pd->CCut = 0;
   Pd->LSCut = 0;
   Pd->P.dCr = 0;
   Pd->P.dCb = 0;
   Pd->P.ToPdY = 0.0;
   Pd->NTools = 0;
   Pd->Plane = 0;
   Pd->XLabs = 0;
   Pd->YRLabs = 0;
   Pd->YLLabs = 0;
   Pd->XLabStyle = 1;
   Pd->YRLabStyle = 1;
   Pd->YLLabStyle = 1;
   Pd->AlignPd = -1;

   Pg = (struct PaGe *) Ms.page + PN;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ;

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            sscanf (Qs->CReply, "%hd", &Pd->Rows); 
         break;
         case 1:
            sscanf (Qs->CReply, "%hd", &Pd->Cols); 
         break;
         case 2:
            Pd->OutFmt = Qs->OpReply;
         break;
         case 3:
            Pd->AData[0] = Qs->OpReply;
            if (Qs->NWins > 0)
            {
               sscanf (Qs->Wins, "%hd", &N1);
               Pd->IncCont = 1;
               MenuContour(Pd, N1);
            }
         break;
         case 4:
            Pd->AData[1] = Qs->OpReply;
         break;
         case 5:
            Pd->AData[2] = Qs->OpReply;
            if (Qs->NWins > 0)
            {
               sscanf (Qs->Wins, "%hd %hd", &N0, &N2);
               DoDisplay = 1;
               if (Qs->NWins > 1)
                  MenuLabels (Pd, N2);
            }
         break;
         case 6:
            Pd->Bx.Empty = Qs->OpReply;
         break;
         case 7:
            Pd->Byl.Empty = Qs->OpReply;
         break;
         case 8:
            Pd->Bx.Fill = Qs->OpReply;
         break;
         case 9:
            Pd->Byl.Fill = Qs->OpReply;
         break;
         case 10:
            Pd->Tm.Fmt = Qs->OpReply;
         break;
         case 11:
            if (Qs->state == 1)
            {
               sscanf (Qs->CReply, "%f", &TmpF);
               Pd->Tm.R = (ReaL_8)TmpF;
               Pd->Tm.OrigR = TmpF;
            }
         break;
         case 12:
            Pd->Tm.Sca = (Qs->state == 1) ? Qs->OpReply : -1;
            Pd->Tm.OrigSca = Pd->Tm.Sca;
         break;
         case 13:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Pd->SrcNum);
            else
               Pd->SrcNum = -1;
         break;
         case 14:
            Pd->Bx.Fmt = Qs->OpReply;
         break;
         case 15:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Bx.Start);
         break;
         case 16:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Bx.Stop);
         break;
         case 17:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Pd->Bx.N);
         break;
         case 18:
            Pd->Bx.Pos = Qs->OpReply;
         break;
         case 19:
            Pd->Bx.Sca = (Qs->state == 1) ? Qs->OpReply : 0;
         break;
         case 20:
            Pd->Byl.Fmt = Qs->OpReply;
         break;
         case 21:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Byl.Start);
         break;
         case 22:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Byl.Stop);
         break;
         case 23:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Pd->Byl.N);
         break;
         case 24:
            Pd->Byl.Pos = Qs->OpReply;
         break;
         case 25:
            Pd->Byl.Sca = (Qs->state == 1) ? Qs->OpReply : 0;
         break;
         case 26:
            Pd->DoSrcs = Qs->OpReply;
         break;
         case 27:
            Pd->ZeroInc = Qs->OpReply;
         break;
         case 28:
            Pd->IgnBlank = Qs->OpReply;
         break;
         case 29:
            Pd->Gap = Qs->OpReply;
         break;
         case 30:
            if (Qs->state == 1)
               Pd->Map.Grid = Qs->OpReply;
         break;
         case 31:
            if (Qs->state == 1)
               Pd->Map.GColor = Qs->OpReply;
         break;
         case 32:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Map.DLat);
         break;
         case 33:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Map.RotLat);
         break;
         case 34:
            if (Qs->state == 1)
            {
               sscanf (Qs->CReply, "%f", &TmpF);
               Pd->Map.LastNLat = (TmpF > 0) ? TmpF : -TmpF;
               Pd->Map.LastSLat = (TmpF > 0) ? -TmpF : TmpF;
            }
         break;
         case 35:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Map.DLong);
         break;
         case 36:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Pd->Map.RotLong);
         break;
         case 37:
            if (Qs->state == 1)
               Pd->Map.Map = Qs->OpReply;
         break;
         case 38:
            if (Qs->state == 1)
               Pd->Map.MColor = Qs->OpReply;
         break;
         case 39:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Pd->Map.MapRes);
         break;
         case 40:
            Pd->NSrcs = Qs->NWins;
            Pd->SrcPN = TransFer (Qs->Wins, 1, 0);
            Pd->EmptySrc = 0;

            B = Pd->NSrcs * sizeof (struct SrcInfo);
            if ((Pd->Src = malloc (B)) == 0)
               exit(-1); 

            EnD = Pd->NSrcs;
            for (N1 = 0; N1 < EnD; )
                MenuUDF(Pd, N1++);
         break;
         case 41:
            Pd->TSrcs = TransFer (Qs->Wins, 1, 0);
            Pd->TDefs = TransFer (Qs->AltVal, 1, 0);

            c1 = (ByTe_1 *)Wa.CStore + Pd->TDefs;
            Src = 0;
            while (Src < Qs->NWins)
            {
               c2 = TmpT;

               while (*c1 == ' ')
                  ++c1;

               while((*c1 != ' ') && (*c1 != 0))
                  *c2++ = *c1++;
               *c2 = 0;

               sscanf (TmpT, "%d", &ToolType);
               if (ToolType != 2)
               {
                  ++VSrcs;
                  ++Pd->NTools;
               }
               
               ++Src;
            }

            if (VSrcs > 0)
            {
               B = VSrcs * sizeof (struct ToolInfo);
               if ((Pd->Tools = malloc (B)) == 0)
                  exit(-1); 
            }

            c1 = (ByTe_1 *)Wa.CStore + Pd->TSrcs;
            c3 = (ByTe_1 *)Wa.CStore + Pd->TDefs;

            Src = 0;
            VSrcs = 0;
            while (Src < Qs->NWins)
            {
               c2 = TmpS;
               c4 = TmpT;

               while (*c1 == ' ')
                  ++c1;

               while (*c3 == ' ')
                  ++c3;

               while((*c1 != ' ') && (*c1 != 0))
                  *c2++ = *c1++;
               *c2 = 0;

               while((*c3 != ' ') && (*c3 != 0))
                  *c4++ = *c3++;
               *c4 = 0;

               sscanf (TmpS, "%d", &PN);
               sscanf (TmpT, "%d", &ToolType);

               switch (ToolType)
               {
                  case 0:
                  case 1:
                  case 3:
                  case 4:
                     MenuTools(Pd, PN, VSrcs++, ToolType);
                  break;
                  case 2:
                     Pd->IncCont = 1;
                     MenuContour(Pd, PN);
                  break;
               }

               ++Src;
            }
         break; 
         case 42:
            Pd->BlkOpen = Qs->OpReply;
         break;
         case 43:
            Pd->PAxes = Qs->OpReply;
         break;
         case 44:
            sscanf (Qs->CReply, "%hd", &Pd->Stack);
         break;
         case 45:
            Pd->TimeDir = Qs->OpReply;
         break;
         case 46:
            sscanf (Qs->CReply, "%hd", &Pd->AlignPd);
         break;
         case 47:
            Pd->SyncSrcs = Qs->OpReply;
         break;
      }
   }

   if (DoDisplay)
      MenuDisplay (Pd, N0);

   if (Pd->Tm.R >= 0) {                             /* BEG SIMPLIFY TM/PIX   */
       switch (Pd->Tm.Sca) {                        /* BEG TIME BASE SWITCH  */
           case 0:                                  /* START YEAR BASE       */
              Pd->Tm.Sca = 1;                       /* change base to days   */
              Pd->Tm.R *= 365.0;                    /* time / pixel to days  */
           break;                                   /* STOP YEAR BASE        */
       }                                            /* END TIME BASE SWITCH  */
   }                                                /* END SIMPLIFY TM/PIX   */
}
