#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuDisplay (struct PlotDef *Pd, ByTe_2 N)
{
   extern struct MeNuS Ms;

   struct PaGe *Pg;
   struct AxisInfo *Ax, *A;
   struct CutDef *cD, *Cd;
   struct QuEsTiOnS *Qs, *QsEnd;

   ByTe_2 TmpS;
   ByTe_2 Item;
   ByTe_2 Def;

 /****************************************************************************/
 /*                          DISPLAY AXIS INFO MENU                          */
 /*                                                                          */
 /*  ID[000-005] MINIMUMS                                                    */
 /*  ID[006-011] MAXIMUMS                                                    */
 /*  ID[012-017] SCALING                           [0=LINEAR, 1=LOG       ]  */
 /*  ID[018-023] MAJOR TICKS PER AXIS                                        */
 /*  ID[024-029] MAJOR TICK LENS                                             */
 /*  ID[030-035] MAJOR TICK FMTS                   [1 = INSIDE            ]  */
 /*                                                [2 = OUTSIDE           ]  */
 /*                                                [3 = STRADDLE          ]  */
 /*                                                [4 = SPAN              ]  */
 /*  ID[036-041] MINOR TICKS PER AXIS                                        */
 /*  ID[042-047] MINOR TICK LENS                                             */
 /*  ID[048-053] MAJOR TICK FMTS                   [1 = INSIDE            ]  */
 /*                                                [2 = OUTSIDE           ]  */
 /*                                                [3 = STRADDLE          ]  */
 /*                                                [4 = SPAN              ]  */
 /*  ID[054-059] NUMERICAL LABEL SIZES                                       */
 /*  ID[060-065] NUMERICAL LABEL FMTS                                        */
 /*  ID[066-071] NUMERICAL LABEL AUTOLEVELS        [0=OFF, 1=ON           ]  */
 /*  ID[072-077] NUMERICAL LABEL OFFSETS                                     */
 /*  ID[078-083] NUMERICAL LABEL SPACING                                     */
 /*  ID[084-089] NUMERICAL LABEL GAP                                         */
 /*  ID[090-095] NUMERICAL LABEL SKIP                                        */
 /*  ID[096-101] TEXT LABEL SIZES                                            */
 /*  ID[102-107] TEXT LABEL OFFSETS                                          */
 /*  ID[108-113] TEXT LABEL SPACING                                          */
/*****************************************************************************/

   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 
   if (Pd->LSCut != 0)
      cD = (struct CutDef *)Pd->LSCut;
   if (Pd->CCut != 0)
      cD = (struct CutDef *)Pd->CCut;

   for ( ; Qs < QsEnd; ++Qs)
   {
      if (Qs->ID < 0)
         continue;

      Item = Qs->ID / 6;
      Def = Qs->ID % 6;
      if (Def < 5)
         Ax = &Pd->Yl + Def;
      else {
         if (Pd->CCut == 0 && Pd->LSCut == 0)
            continue;
         Ax = &cD->Ay;
         if (Pd->CCut > 0)
            Ax = (cD->CutPlace == 0) ? &cD->Ay : &cD->Ax;
      }

      switch (Item) {
         case 0:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Ax->Min); 
         break;
         case 1:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%f", &Ax->Max); 
         break;
         case 2:
            Ax->Sca = Qs->OpReply;
         break;
         case 3:
            sscanf (Qs->CReply, "%hd", &TmpS); 
            Ax->MjTNum = TmpS;
         break;
         case 4:
            sscanf (Qs->CReply, "%hd", &Ax->MjTLen); 
         break;
         case 5:
            Ax->MjTFmt = Qs->OpReply;
         break;
         case 6:
            sscanf (Qs->CReply, "%hd", &TmpS); 
            Ax->MnTNum = TmpS;
         break;
         case 7:
            sscanf (Qs->CReply, "%hd", &Ax->MnTLen); 
         break;
         case 8:
            Ax->MnTFmt = Qs->OpReply;
         break;
         case 9:
            sscanf (Qs->CReply, "%hd", &Ax->NumSize); 
         break;
         case 10:
            if (Qs->state == 1)
               strcpy (Ax->NumFmt, Qs->CReply); 
         break;
         case 11:
            Ax->NumIntlv = Qs->OpReply;
         break;
         case 12:
            sscanf (Qs->CReply, "%f", &Ax->NumOffset); 
         break;
         case 13:
            sscanf (Qs->CReply, "%f", &Ax->NumSpace); 
         break;
         case 14:
            sscanf (Qs->CReply, "%f", &Ax->NumGap); 
         break;
         case 15:
            sscanf (Qs->CReply, "%hd", &TmpS); 
            Ax->NumSkip = TmpS;
         break;
         case 16:
            sscanf (Qs->CReply, "%hd", &Ax->LabSize); 
         break;
         case 17:
            sscanf (Qs->CReply, "%f", &Ax->LabOffset); 
         break;
         case 18:
            sscanf (Qs->CReply, "%f", &Ax->LabSpace); 
         break;
      }
   }

   if (Pd->LSCut != 0 && Pd->CCut != 0) {
      Cd = (struct CutDef *)Pd->LSCut;
      cD = (struct CutDef *)Pd->CCut;
      Ax = &Cd->Ay;
      Ax = (cD->CutPlace == 0) ? &cD->Ay : &cD->Ax;
      Ax->Min = A->Min; 
      Ax->Max = A->Max; 
      Ax->Sca = A->Sca;
      Ax->MjTNum = A->MjTNum;
      Ax->MjTLen = A->MjTLen;
      Ax->MjTFmt = A->MjTFmt;
      Ax->MnTNum = A->MnTNum;
      Ax->MnTLen = A->MnTLen;
      Ax->MnTFmt = A->MnTFmt;
      Ax->NumSize = A->NumSize; 
      strcpy (Ax->NumFmt, A->NumFmt); 
      Ax->NumIntlv = A->NumIntlv; 
      Ax->NumOffset = A->NumOffset; 
      Ax->NumSpace = A->NumSpace; 
      Ax->NumGap = A->NumGap; 
      Ax->NumSkip = A->NumSkip; 
      Ax->LabSize = A->LabSize; 
      Ax->LabOffset = A->LabOffset; 
      Ax->LabSpace = A->LabSpace; 
   }
   if (Pd->LSCut > 0) { 
      Cd = (struct CutDef *)Pd->LSCut;
      Ax = &Cd->Ax;
      Ax->Min = 0.0; 
      Ax->Max = 24.0; 
      Ax->Sca = 0;
      Ax->MjTNum = 4;
      Ax->MjTLen = cD->Ay.MjTLen;
      Ax->MjTFmt = cD->Ay.MjTFmt;
      Ax->MnTNum = 3;
      Ax->MnTLen = cD->Ay.MnTLen;
      Ax->MnTFmt = cD->Ay.MnTFmt;
      Ax->NumSize = cD->Ay.NumSize; 
      strcpy (Ax->NumFmt, "%.0f"); 
      Ax->NumIntlv = cD->Ay.NumIntlv; 
      Ax->NumOffset = cD->Ay.NumOffset; 
      Ax->NumSpace = cD->Ay.NumSpace; 
      Ax->NumGap = cD->Ay.NumGap; 
      Ax->NumSkip = cD->Ay.NumSkip; 
      Ax->LabSize = cD->Ay.LabSize; 
      Ax->LabOffset = cD->Ay.LabOffset; 
      Ax->LabSpace = cD->Ay.LabSpace; 
   }
   if (Pd->CCut > 0) { 
      cD = (struct CutDef *)Pd->CCut;
      Ax = (cD->CutPlace == 0) ? &cD->Ax : &cD->Ay;
      A =  (cD->CutPlace == 0) ? &Pd->Xb : &Pd->Yl;
      Ax->Min = A->Min;
      Ax->Max = A->Max;; 
      Ax->Sca = A->Sca;
      Ax->MjTNum = A->MjTNum;
      Ax->MjTLen = A->MjTLen;
      Ax->MjTFmt = A->MjTFmt;
      Ax->MnTNum = A->MnTNum;
      Ax->MnTLen = A->MnTLen;
      Ax->MnTFmt = A->MnTFmt;
      Ax->NumSize = A->NumSize; 
      strcpy (Ax->NumFmt, A->NumFmt); 
      Ax->NumIntlv = A->NumIntlv; 
      Ax->NumOffset = A->NumOffset; 
      Ax->NumSpace = A->NumSpace; 
      Ax->NumGap = A->NumGap; 
      Ax->NumSkip = A->NumSkip; 
      Ax->LabSize = A->LabSize; 
      Ax->LabOffset = A->LabOffset; 
      Ax->LabSpace = A->LabSpace; 
   }
}
