#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuContour (struct PlotDef *Pd, ByTe_2 N)
{
   extern struct MeNuS Ms;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct ConTouR *Ct;

   size_t B;
   ByTe_2 PN;
   ByTe_1 TmPc[50];

/*****************************************************************************/
/*                          CONTOUR DEFINITION                               */
/*                                                                           */
/* ID[00] FORMAT                             [ 0 = X vs Y              ]     */
/*                                           [ 1 = XY vs Z             ]     */
/*                                           [ 2 = Phi vs Theta        ]     */
/* ID[01] METHOD                             [ 0 = RANDOM(3D)          ]     */
/*                                           [ 1 = RANDOM (2D)         ]     */
/*                                           [ 2 = ORDERED GRID (2D)   ]     */
/*                                           [ 3 = HOLLOW GRID (2D)    ]     */
/*                                           [ 4 = PREGRIDDED (2D)     ]     */
/* ID[02] GRID                               [ 0 = CONSTANT            ]     */
/*                                           [ 1 = RECALCULATE         ]     */
/* ID[03] DUMP MESH                          [ 0 = NO;  1 = YES        ]     */
/* ID[04] NEG DATA                           [ 0 = TINY;  1 = SMALL    ]     */
/*                                           [ 2 = IGNORE; -1 = N/A    ]     */
/* ID[05] X MESH INFO  [SIZE, MAX, MIN]                                      */
/* ID[06] X-MESH SCALE                       [ 0 = LINEAR; 1 = LOG     ]     */
/* ID[07] X-CYCLIC                           [ 0 = LINEAR; 1 = LOG     ]     */
/* ID[08] VALUES AT DISCONTINUITY                                            */
/* ID[09] Y MESH INFO  [SIZE, MAX, MIN]                                      */
/* ID[10] Y-MESH SCALE                       [ 0 = LINEAR; 1 = LOG     ]     */
/* ID[11] FIT ORDER                                                          */
/* ID[12] FIT WEIGHT                                                         */
/* ID[13] ORDERED GRID PATTERN               [ 0 = TRIANGLE            ]     */
/*                                           [ 1 = DIAMOND             ]     */
/*                                           [ 2 = SQUARE              ]     */
/*                                           [ 4 = ALL                 ]     */
/* ID[14] MINIMUM NEIGHBORS                                                  */
/* ID[15] MINUMIM QUADRANTS FILLED                                           */
/* ID[16] MINUMIM RADIUS**2                                                  */
/* ID[17] RADIUS UNITS                       [ 0-ABSOLUTE; 1-GRIDS       ]   */
/* ID[18] DISPLAY FORMAT                     [ 0 = COLOR FILL            ]   */
/*                                           [ 1 = COLORED LINES         ]   */
/*                                           [ 2 = LINES                 ]   */
/*                                           [ 3 = COLOR FILL WITH LINES ]   */
/* ID[19] Z-SCALING                          [ 0 = LINEAR; 1 = LOG       ]   */
/* ID[20] COLOR CELLS PER MESH GRID                                          */
/* ID[21] CONTOUR LINES                                                      */
/* ID[22] MIN/MAX CONTOUR LINE VALUE                                         */
/* ID[23] CONTOUR LINE COLOR [WHITE-RED-YELLOW-GREEN-CYAN-BLUE-PURPLE-BLACK] */ 
/* ID[24] DISPLAY CONTOUR LABELS             [ 0-NO; 1-YES               ]   */
/* ID[25] LABEL COLOR        [WHITE-RED-YELLOW-GREEN-CYAN-BLUE-PURPLE-BLACK] */ 
/* ID[26] LABEL FMT, SIZE SKIP                                               */
/* ID[27] DISPLAY GRID                       [ 0-NO; 1-YES               ]   */
/* ID[28] GRID COLOR  [WHITE-RED-YELLOW-GREEN-CYAN-BLUE-PURPLE-BLACK-VALUE]  */ 
/* ID[29] LABEL FMT SIZE                                                     */
/* ID[30] DISPLAY DATA                       [ 0-NO; 1-YES               ]   */
/* ID[31] DATA COLOR  [WHITE-RED-YELLOW-GREEN-CYAN-BLUE-PURPLE-BLACK-VALUE]  */ 
/* ID[32] LABEL FMT SIZE                                                     */
/* ID[33] 1-D CUT                                                            */
/*****************************************************************************/

   Pg = (struct PaGe *) Ms.page + N;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   B = sizeof (struct ConTouR);
   if ((Pd->Cont = malloc (B)) == 0)
      exit(-1); 

   Ct = (struct ConTouR *)Pd->Cont;
           
   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            Ct->Format = Qs->OpReply; 
         break;
         case 1:
            Ct->Method = Qs->OpReply; 
            if (Qs->NWins == 1)
            {
               sscanf (Qs->Wins, "%hd", &PN);
               Menu3DPlane (Pd, PN);
            }
         break;
         case 2:
            Ct->NewGrid = Qs->OpReply; 
         break;
         case 3:
            Ct->PrMesh = Qs->OpReply; 
         break;
         case 4:
            Ct->NegData = (Qs->state == 1) ? Qs->OpReply : -1; 
         break;
         case 5:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%d %f %f", &Ct->XBins, &Ct->XMin, &Ct->XMax);
            }
         break;
         case 6:
            Ct->XSca = Qs->OpReply; 
         break;
         case 7:
            Ct->XCyclic = Qs->OpReply; 
         break;
         case 8:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%f %f", &Ct->CycDis1, &Ct->CycDis2); 
            }
         break;
         case 9:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%d %f %f", &Ct->YBins, &Ct->YMin, &Ct->YMax);
            }
         break;
         case 10:
            Ct->YSca = Qs->OpReply; 
         break;
         case 11:
            sscanf (Qs->CReply,"%hd", &Ct->Order);
         break;
         case 12:
            sscanf (Qs->CReply,"%f", &Ct->Weight);
         break;
         case 13:
            Ct->OrGridPat = (Qs->state == 1) ? Qs->OpReply : -1; 
         break;
         case 14:
            sscanf (Qs->CReply,"%d", &Ct->FitPts);
         break;
         case 15:
            sscanf (Qs->CReply,"%hd", &Ct->Quads);
         break;
         case 16:
            sscanf (Qs->CReply,"%f", &Ct->Radius);
            break;
         case 17:
            Ct->RBase = Qs->OpReply;
         break;
         case 18:
            Ct->DispFmt = Qs->OpReply;
         break;
         case 19:
            Ct->ZSca = Qs->OpReply;
         break;
         case 20:
            if (Qs->state != 0)
                sscanf (Qs->CReply,"%d", &Ct->NCells);
            else
               Ct->NCells = 0;
         break;
         case 21:
            if (Qs->state != 0)
                sscanf (Qs->CReply,"%d", &Ct->NContours);
            else
               Ct->NContours = 0;
         break;
         case 22:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%f %f", &Ct->MinContour, &Ct->MaxContour);
            }
            else
            {
               Ct->MinContour = 1;
               Ct->MaxContour = 2;
            }
         break;
         case 23:
            Ct->ContColor = (Qs->state == 1) ? Qs->OpReply : 0; 
         break;
         case 24:
            Ct->ShowCLabs = Qs->OpReply; 
         break;
         case 25:
            Ct->CLabColor = (Qs->state == 1) ? Qs->OpReply : 0; 
         break;
         case 26:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%s %hd %hd", 
                                  TmPc, &Ct->CLabSize, &Ct->CLabSkip);
               Ct->CLabFmt = TransFer(TmPc, 1, 0); 
            }
            else
            {
               Ct->CLabFmt = -1; 
               Ct->CLabSkip = 1; 
               Ct->CLabSize = 10; 
            }
         break;
         case 27:
            Ct->ShowGrids = Qs->OpReply; 
         break;
         case 28:
            Ct->GridColor = (Qs->state == 1) ? Qs->OpReply : 0; 
         break;
         case 29:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%s %hd", TmPc, &Ct->GridSize);
               Ct->GridFmt = TransFer(TmPc, 1, 0); 
            }
         break;
         case 30:
            Ct->ShowData = Qs->OpReply; 
         break;
         case 31:
            Ct->DataColor = (Qs->state == 1) ? Qs->OpReply : 0; 
         break;
         case 32:
            if (Qs->state != 0)
            {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply,"%s %hd", TmPc, &Ct->DataSize);
               Ct->DataFmt = TransFer(TmPc, 1, 0); 
            }
         break;
         case 33:
            if (Qs->NWins == 1)
            {
               sscanf (Qs->Wins, "%hd", &PN);
               MenuCut (Pd, PN);
            }
         break;
      }
   }
}
