#include <stdio.h>
#include <string.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "gph_shortcut_defs.h"

/*****************************************************************************/
/*  This program puts up all labels associated with a given line plot which  */
/*  need to be put up immediately after the plot is put up on the screen     */
/*  least they be lost.                                                      */
/*****************************************************************************/

ByTe_4 LabelMkr (ByTe_4 N, ByTe_4 sN, ByTe_4 pN, ByTe_4 RpN, ByTe_2 LabN, 
                 ByTe_2 LabSN, ByTe_1 *L)
{
   extern struct UserDefs InFo;
   extern struct three_d_cut cut;
   extern ByTe_1 *ScatSym[];
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfMode *Pm;
   struct PidfAnc *Pa;
   struct PidfSensor *Ps;
   struct PlaneInfo *Pn;

   ReaL_4 Tp, Bt, Cn;
   ByTe_4 Tm[8], SLen, TmP;
   ByTe_1 *TFmt = "%4d %03d %02d:%02d:%02d.%03d";
   ByTe_1 *Side = "B-T-L-R";
   ByTe_1 *Ax = "XYZ";
   ByTe_1 L1[30], L2[30], L3[80], L4[20], MeaID[160];
   ByTe_1 *Wc;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */
   Wc = (ByTe_1 *)Wa.CStore;
   L[0] = 0;
   
   switch (LabN)                                       /* switch on label    */
   {                                                   /* BEG LABEL SWITCH   */
      case 0:                                          /* START TIME LABEL   */
        S = (struct SrcInfo *)Pd->Src + sN;            /* ptr to src         */
        if (LabSN == 0)                                /* begin time?        */
           TmBrkOut (&Pd->Pb, Tm);                     /* time components    */
        else  {                                        /* must be end time   */
           if (Pd->PStat == 1)                         /* something plotted  */
              TmBrkOut (&S->Eg, Tm);                   /* time components    */
           else                                        /* empty plot         */
              TmBrkOut (&Pd->Pe, Tm);                  /* time components    */
        }
        sprintf (L, TFmt, Tm[0], Tm[1], Tm[2], Tm[3], Tm[4], Tm[5]);
      break;                                           /* STOP END TIME PLT  */
      case 1:                                          /* START SRC LABEL    */
      case 2:                                          /* START SRC LABEL    */
        L1[0] = 0;                                     /* init side label    */
        L2[0] = 0;                                     /* init plot symb     */
        L3[0] = 0;                                     /* init collapse lab  */
        S = (struct SrcInfo *)Pd->Src + sN;            /* ptr to src         */
        if (Pd->DoSrcs == 0)                           /* sources merged     */
           strcpy (L1, " [M]");                        /* set indicator      */
        else                                           /* independent        */
           sprintf (L1, " [%c]", Side[(ByTe_2)S->PAxis]); /* set plot axis   */

        if (Pd->Li[1].LocA > 3 && Pd->Li[1].LocB == 2 && S->LpType == 10)
           L1[0] = 0;

        if (S->LpType == 2)                            /* scatter plot       */
        {
           if (S->ScatSym < 10)
              strcpy (L2, ScatSym[S->ScatSym]);        /* need sym indicator */
           else
              strcpy (L2, Wc + S->ScatSym);            /* need sym indicator */
        }

        ReadPidf(S->Key, InFo.PIDF);                   /* Get PIDF info      */
        P = (struct Pidf *) InFo.PIDF;                 /* pointer to info    */

        MeaID[0] = 0;                               /* NULL label            */
        switch (Pd->Li[2].Fmt)                      /* src label             */
        {                                           /* BEG SOURCE LABEL      */
           case 0:                                  /* START P               */
             strcpy (MeaID, Wc + S->P);             /* project label         */ 
           break;                                   /* STOP P                */
           case 1:                                  /* START P.M             */
             strcpy (MeaID, Wc + S->P);             /* project label         */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
           break;                                   /* STOP P.M              */
           case 2:                                  /* START P.M.E           */
             strcpy (MeaID, Wc + S->P);             /* project label         */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
           break;                                   /* STOP P.M.E            */
           case 3:                                  /* START P.M.E.I         */
             strcpy (MeaID, Wc + S->P);             /* project label         */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
           break;                                   /* STOP P.M.E.I          */
           case 4:                                  /* START P.M.E.I.V       */
             strcpy (MeaID, Wc + S->P);             /* project label         */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->V);             /* Add sub-inst label    */ 
           break;                                   /* STOP P.M.E.I.V        */
           case 5:                                  /* START M               */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
           break;                                   /* STOP M                */
           case 6:                                  /* START M.E             */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
           break;                                   /* STOP M.E              */
           case 7:                                  /* START M.E.I           */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
           break;                                   /* STOP M.E.I            */
           case 8:                                  /* START M.E.I.V         */
             strcat (MeaID, Wc + S->M);             /* Add mission label     */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->V);             /* Add sub-inst label    */ 
           break;                                   /* STOP M.E.I.V          */
           case 9:                                  /* START E               */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
           break;                                   /* STOP E                */
           case 10:                                 /* START E.I             */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
           break;                                   /* STOP E.I              */
           case 11:                                 /* START E.I.V           */
             strcat (MeaID, Wc + S->E);             /* Add experiment label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->V);             /* Add sub-inst label    */ 
           break;                                   /* STOP E.I.V            */
           case 12:                                 /* START I               */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
           break;                                   /* STOP I                */
           case 13:                                 /* START I.V             */
             strcat (MeaID, Wc + S->I);             /* Add instrument label  */ 
             strcat (MeaID, ".");                   /* add . separator       */
             strcat (MeaID, Wc + S->V);             /* Add sub-inst label    */ 
           break;                                   /* STOP I.V              */
           case 14:                                 /* START V               */
             strcat (MeaID, Wc + S->V);             /* Add sub-inst label    */ 
           break;                                   /* STOP V                */
        }                                           /* BEG SOURCE LABEL      */

        if (Pd->Li[1].Fmt == 0)                     /* Include Src Label     */
        {                                           /* BEG MAKE SRC LABEL    */
           if (MeaID[0] != 0)                       /* Label made            */
              strcat (MeaID, " ");                  /* add space at end      */
           
           switch (S->DType)
           {
              case 0:
              case 1:
                 Ps = (struct PidfSensor *)P->Sensors + S->GetPN; 
                 strcat (MeaID, Ps->Name);
                 if (S->SType == 3 && Pd->DoSrcs == 1)
                 {
                    if (S->OneAll == 3)
                    {
                       TmP = (S->Col.N <= 0) ? 1 : S->Col.N;
                       sprintf (L4, "/C%d", RpN/TmP);
                    }
                    else
                       sprintf (L4, "/C%d", S->SenCN);

                    strcat (MeaID, L4);
                 }
              break;
              case 2:
                 Pa = (struct PidfAnc *)P->Ancil + S->GetPN;
                 strcat (MeaID, Pa->LDesc);
              break;
              case 6:
                 Pm = (struct PidfMode *)P->Modes + S->GetPN;
                 strcat (MeaID, Pm->LDesc);
              break;
           }

           if (L2[0] == 0)                             /* no plot symbol     */
              sprintf (L, "%s", MeaID);                /* use this label     */
           else                                        /* plot symbol        */
              sprintf (L, "%s %s", L2, MeaID);         /* use this label     */
           if (L1[0] != 0)                             /* side label?        */
           {                                           /* BEG EXTRA          */
              if (!((Pd->AData[0] == 0 && Pd->AData[1] == 2) ||
                  (Pd->AData[0] == 0 && Pd->AData[1] == 9)) || 
                   L1[2] == 'M')
                 strcat (L, L1);                       /* add side label     */
           }                                           /* END EXTRA          */

        }                                              /* END MAKE SRC LABEL */
        else                                           /* just PMEIV         */
           strcat (L, MeaID);                          /* that is the label  */
      break;                                           /* STOP SRC LABEL     */

      case 3:                                          /* START COL LABEL    */
        S = (struct SrcInfo *)Pd->Src + sN;            /* ptr to src         */
        GetBinStats (&S->Col, pN, &Bt, &Tp, &Cn, 0);   /* collapse limits    */
        if (Pd->Li[3].Fmt == 0)                        /* need collapse type */
        {                                              /* BEG GET COL TYPE   */
           if (S->Col.Fmt == 0)                        /* data avgeraged?    */
              strcpy (L1, "'SIGMA'");                  /* summation sign     */
           else                                        /* must be integrated */
              strcpy (L1, "'INT'");                    /* integral sign      */
        }                                              /* END GET COL TYPE   */

        L2[0] = 0;                                       /* null label       */
        if ((Pd->Li[3].Fmt < 2) || (Pd->Li[3].Fmt == 3)) /* need units       */
        {                                                /* BEG GET UNITS    */
           ReadPidf(S->Key, InFo.PIDF);                  /* Get PIDF info    */
           P = (struct Pidf *) InFo.PIDF;                /* pointer to info  */
           Pu = (struct PidfUnit *)P->Units + S->AltUN;  /* PIDF scan units  */
           sprintf (L2, "%s", Pu->ULab);                 /* units label      */
        }                                                /* END GET UNITS    */

        if (Pd->Li[3].Fmt == 0) 
           sprintf (L, "%s {%.2e - %.2e} %s", L1, Bt, Tp, L2); 
        else
        {
           if (Pd->Li[3].Fmt < 3 ) 
               sprintf (L, "{%.2e - %.2e} %s", Bt, Tp, L2); 
           else
               sprintf (L, "%.2e %s",  Cn, L2); 
        }
      break;                                           /* STOP COL LABEL     */
      case 4:                                          /* START TOOL LABEL   */
         switch (LabSN) {                              /* BEG TOOL SUB LABEL */
            case 0:                                    /* START FLOW REMOVAL */
               strcpy (L, "REMOVE FLOW");              /* flow removal       */
            break;                                     /* STOP FLOW REMOVAL  */
            case 1:                                    /* START VECTOR       */
               strcpy (L, "SHOW VECTOR");              /* show vector        */
            break;                                     /* STOP VECTOR        */
            case 2:                                    /* START CONTOUR      */
               strcpy (L, "CONTOUR ON");               /* show contour       */
            break;                                     /* STOP CONTOUR       */
            case 3:                                    /* START GLOBE        */
               strcpy (L, "SHOW GLOBE/OBJ");           /* show globe         */
            break;                                     /* STOP GLOBE         */
            case 4:                                    /* START OBJECT       */
               strcpy (L, "SHOW OBJECT");              /* show object        */
            break;                                     /* STOP OBJECT        */
         }                                             /* END TOOL SUB LABEL */
      break;                                           /* STOP TOOL LABEL    */
      case 5:                                          /* START 3D PLANE     */
         switch (LabSN)                                /* SUB LABEL SWITCH   */
         {                                             /* BEG 3D SUB LABEL   */
            case 0:                                    /* START AXIS ROT     */
              Pn = (struct PlaneInfo *)Pd->Plane;      /* plane def info     */
              L1[0] = (Pn->RotateTo < 3) ? '+' : '-';  /* axis sign          */
              L1[1] = Ax[Pn->RotateTo % 3];            /* axis               */
              L1[2] = 0;                               /* axis label end     */
              sprintf (L, "A: %s", L1);                /* units label        */
            break;                                     /* STOP AXIS ROT      */
            case 1:                                    /* START Z TRANS      */
              sprintf (L, "T: %.1f", cut.TransZ);      /* units label        */
            break;                                     /* STOP Z TRANS       */
            case 2:                                    /* START RHO ROT      */
              sprintf (L, "'rho': %.1f", cut.Rho);     /* units label        */
            break;                                     /* STOP RHO ROT       */
            case 3:                                    /* START THETA ROT    */
              sprintf (L, "'theta': %.1f", cut.Theta); /* units label        */
            break;                                     /* STOP THETA ROT     */
            case 4:                                    /* START PHI ROT      */
              sprintf (L, "'phi': %.1f", cut.Phi);     /* units label        */
            break;                                     /* STOP PHI ROT       */
         }                                             /* END 3D SUB LABEL   */
      break;                                           /* STOP 3D PLANE      */
   }                                                   /* END LABEL SWITCH   */

   SLen = strlen (L);                                  /* string length      */
   return (SLen);
}
