#include <stdlib.h>
#include <string.h>
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "gph_opind.h"
#include "gph_str.h"
#include "gph_ansi.h"

void LShells (ByTe_1 wN, ByTe_4 N, ReaL_4 SubPt, struct ToolInfo *Ti, 
               ByTe_4 pN)
{
   extern struct UserDefs InFo;
   extern struct config parm;
   extern struct mapinfo map;
   extern struct WorkArea Wa;
   extern struct cont_alloc cal;

   struct PlotDef  *Pd;
   struct CutDef   *cD;
   struct window   *wn, *wna;

   void *V = NULL;
   register ReaL_4 *mLt, *FluX, *pV, *wS;
   ReaL_4 xMin, yMin, xMax, yMax, dR, dC, bB, bC;
   ReaL_4 X, Y, T, R, mP = -70.0, tM = 11.0;
   ReaL_4 P, pB, pE, dP = 1.0, Bad;
   ReaL_4 x1, x2, y1, y2;
   ReaL_4 sx, ix, sy, iy;
   ReaL_4 NoonBeg, NoonEnd;
   size_t B;
   ByTe_4 Np, Totx, Toty, cN, rN, Pos;
   ByTe_2 sLc, *s1, C, J;
   ByTe_1 sU, nW = 51, Cmd[4], NeedExp = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + N; 
   copy_win (Pd->Wn, nW);

   NeedExp = (Pd->Cont > 0) ? Pd->Cb.Sca : 0;     /* plot scaling used     */
   Bad = (NeedExp) ? log10(FILL) : FILL;          /* bad data              */
   if (Pd->LSCut != 0) {
      cD = (struct CutDef *)Pd->LSCut;
      bB = (cD->Ay.Sca == 1) ? log10(cD->Ay.Min/100.0) : cD->Ay.Min - 10.0;   
      bC = (cD->Ay.Sca == 1) ? cD->Ay.Min/90.0 : cD->Ay.Min - 9.9;   
   }

   window (wN, "LSHELLS");
   wn = parm.win;
   sx = (wn->plot[3] - wn->plot[0]) / (wn->real[3] - wn->real[0]);
   ix = wn->plot[3] - sx * wn->real[3];
   sy = (wn->plot[4] - wn->plot[1]) / (wn->real[4] - wn->real[1]);
   iy = wn->plot[4] - sx * wn->real[4];
   
   window (Pd->Wn, "LSHELLS");
   wn = parm.win;
   window (nW, "LSHELLS");
   wna = parm.win;

   wna->plot[0] = sx * wn->real[0] + ix;
   wna->plot[3] = sx * wn->real[3] + ix;
   wna->plot[1] = sy * wn->real[1] + iy;
   wna->plot[4] = sy * wn->real[4] + iy;
   scale_win(3);

   xMin = wna->plot[0];
   yMin = wna->plot[1];
   xMax = wna->plot[3];
   yMax = wna->plot[4];
   dC = (xMax - xMin) / (ReaL_4)Pd->Bx.N;
   dR = (yMax - yMin) / (ReaL_4)Pd->Byl.N;
   Totx = Pd->Bx.N;
   Toty = Pd->Byl.N;
   if (Pd->LSCut > 0) {
      cD = (struct CutDef *)Pd->LSCut;
      B = 730 * sizeof (ReaL_4);
      if ((V = malloc(B)) == 0)
         exit (-2);
      wS = (ReaL_4 *)Wa.WorkSpace;
      pV = (Pd->Cont > 0) ? cal.z : wS + 2 * Pd->PlotLen * pN;
   }

   sU = parm.univ;
   sLc = parm.l_color;
   parm.univ = 0;

   s1 = &parm.white;
   clip (nW, 1);

   X = sine (map.center);
   Y = cosin (map.center);
   pB = SubPt - 180.0;
   pE = SubPt + 180.0;

   for (J = 0, R = Ti->LRng[0]; R <= Ti->LRng[1]; R += Ti->LRng[2], ++J) {
      plt_color (0, *(s1 + Ti->Color4));
      mLt = (ReaL_4 *)V;
      FluX = mLt + 365;
      T = tM * cosin (pB + mP) + tM * sine(pB + mP);
      x1 = R * cosin (T) * sine(pB + map.rotlong);
      y1 = R * (cosin (T) * cosin (pB + map.rotlong) * X + sine (T) * Y);
      Np = 0;
      for (P = pB + dP; P <= pE; P += dP) {
         T = tM * cosin (P + mP) + tM * sine(P + mP);
         x2 = R * cosin (T) * sine(P + map.rotlong);
         y2 = R * (cosin (T) * cosin (P + map.rotlong) * X + sine (T) * Y);
         line (nW, x1, y1, 0., x2, y2, 0.);
         if (Ti->LShell > 1) {
            cN = ((x1 + x2) / 2.0 - xMin) / dC;
            rN = ((y1 + y2) / 2.0 - yMin) / dR;
            Pos = cN * Pd->Byl.N + rN;
            *mLt = 24.0 * (P - dP - pB) / 360.0;
            *mLt += (*mLt > 24.0) ? -24.0 : (*mLt < 0.0) ? 24.0 : 0.0;
            if ((cN >= 0 && cN < Totx) && (rN >= 0 && rN < Toty))
               *FluX = (*(pV + Pos) >= Bad) ? bB : *(pV + Pos);
            else
               *FluX = bB;
            if (NeedExp) *FluX = pow (10.0, *FluX);
            ++FluX;
            ++mLt;
            ++Np;
         }
         x1 = x2;
         y1 = y2;
      }

      if (Ti->Type == 3 || Ti->Type == 4) {
         if (Ti->Color4 == 0)
           plt_color (0, parm.black);
         else
           plt_color (0, parm.white);
         NoonBeg = SubPt - dP; 
         NoonEnd = SubPt + dP; 
         T = tM * cosin (NoonBeg + mP) + tM * sine(NoonBeg + mP);
         x1 = R * cosin(T) * sine(NoonBeg + map.rotlong);
         y1 = R * (cosin(T) * cosin (NoonBeg + map.rotlong) * X + sine (T) * Y);
         T = tM * cosin(NoonEnd + mP) + tM * sine(NoonEnd + mP);
         x2 = R * cosin(T) * sine(NoonEnd + map.rotlong);
         y2 = R * (cosin(T) * cosin (NoonEnd + map.rotlong) * X + sine (T) * Y);
         line (nW, x1, y1, 0., x2, y2, 0.);
      }

      if (Ti->LShell > 1) {
         Cmd[0] = 1;
         Cmd[1] = 0;
         C = *(s1 + J % 7);
         mLt = (ReaL_4 *)V;
         FluX = mLt + 365;
         set_qual (cD->CutPn, 'y', 'L', bC);
         plot_2d (cD->CutPn, 0, 4, 8, mLt, FluX, mLt, 0, Np-1, Cmd, C);
      }
   }

   parm.univ = sU;
   plt_color (0, sLc);
   if (V != NULL)
      free (V);
}
