#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void GrowSrcs (struct PlotDef *Pd, ByTe_1 GrowBy)
{
   extern struct UserDefs InFo;
   struct SrcInfo *S;

   struct Pidf *P;
   struct PidfSensor *Ps, *PsEnD;
   struct PidfMode *Pm;

   ByTe_4 Sz, B, NumInGrp;
   ByTe_2 I, Cnt, SrcB;

   if (GrowBy == 0 || GrowBy == 3)                  /* no growth for 1 sen  */
      return;                                       /* or for matrix cols   */

   Sz = sizeof (struct SrcInfo);
   SrcB = Pd->EmptySrc - 1;
   S = (struct SrcInfo *)Pd->Src + SrcB;

   ReadPidf (S->Key, InFo.PIDF); 

   P = (struct Pidf *) InFo.PIDF;                   /* PIDF interface struct */ 
   Ps = (struct PidfSensor *) P->Sensors;           /* Sensor Info           */ 
   PsEnD = Ps + P->Ps.NSensors;                     /* Last Sensor           */ 

   if (GrowBy == 2)
   {
      NumInGrp = 0;                                 /* Sensors in Group      */
      Ps = (struct PidfSensor *) P->Sensors;        /* Sensor Info           */ 
      PsEnD = Ps + P->Ps.NSensors;                  /* Last Sensor           */ 
      for ( ; Ps < PsEnD; ++Ps)                     /* Sensor Group Loop     */
         if (S->Group == Ps->GroupNum)              /* Sensor in Group?      */
            ++NumInGrp;                             /* Count It              */
      
      Pd->NSrcs += NumInGrp - 1;                    /* New Num Srcs          */
      B = Pd->NSrcs * Sz;                           /* New Storage Size      */
      if ((Pd->Src = realloc (Pd->Src, B)) == 0)    /* Get new space         */ 
         exit(-1);                                  /* if error then - bye   */

      S = (struct SrcInfo *)Pd->Src + SrcB;         /* Reset Src pointer     */
      Ps = (struct PidfSensor *) P->Sensors;        /* Sensor Info           */ 
      for (I = 0, Cnt = 1; I < P->Ps.NSensors; ++Ps, ++I) /* Sensor Pickup   */
      {                                             /* BEG GATHER SENSORS    */
         if ((S->Group == Ps->GroupNum) &&   S->GetPN != Ps->PidfNum) 
            DupSrc (Pd, SrcB, I, Cnt++, ChkUnits(S, I));
      }                                             /* END GATHER SENSORS    */
   }
   else
   {
      switch (S->DType)                             /* Data Type Switch      */
      {                                             /* BEG DATA TYPE SWITCH  */
         case 0:                                    /* START SENSOR          */
         case 1:                                    /* START SCAN            */

           Pd->NSrcs += P->Ps.NSensors - 1;         /* New Num Srcs          */
           B = Pd->NSrcs * Sz;                      /* New Storage Size      */
           if ((Pd->Src = realloc (Pd->Src, B)) == 0) /* Get new space       */ 
               exit(-1);                              /* if error then - bye */

           S = (struct SrcInfo *)Pd->Src + SrcB;       /* source pointer     */
           Ps = (struct PidfSensor *) P->Sensors;      /* Sensor Info        */ 
           for (I = 0, Cnt = 1; I < P->Ps.NSensors; ++Ps, ++I)
           {                                           /* BEG GATHER SENSORS */
              if ( S->GetPN != Ps->PidfNum)            /* Not Base sensor?   */
                 DupSrc (Pd, SrcB, I, Cnt++, ChkUnits(S, I));
           }                                           /* END GATHER SENSORS */

         break;                                     /* STOP SENSOR AND SCAN  */

         case 6:                                    /* START MODES           */

           Pd->NSrcs += P->Ps.NModes - 1;           /* New Num Srcs          */
           B = Pd->NSrcs * Sz;                      /* New Storage Size      */
           if ((Pd->Src = realloc (Pd->Src, B)) == 0) /* Get new space       */ 
              exit(-1);                               /* if error then - bye */

           S = (struct SrcInfo *)Pd->Src + SrcB;       /* source pointer     */
           Pm = (struct PidfMode *) P->Modes;          /* Sensor Info        */ 
           for (I = 0, Cnt = 1; I < P->Ps.NModes; ++Pm, ++I)
           {                                           /* BEG GATHER SENSORS */
              if (S->GetPN != Pm->PidfNum)             /* Not Base mode?     */
                 DupSrc (Pd, SrcB, I, Cnt++, ChkUnits(S, I));
           }                                           /* END GATHER SENSORS */

         break;                                     /* STOP MODES            */
      }                                             /* END GATHER SENSORS    */
   }
}
