#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "Gmenu_str.h"
#include "libbase_udf.h"
#include "libCfg.h"

ByTe_1 GetVPidfStuff (struct VSrcInfo *V)
{
   extern struct UserDefs InFo;

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfSensor *Ps;

   ByTe_4 I;

   ReadPidf(V->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;

   for (I = 0; I < 3; ++I)
   {
      Ps = (struct PidfSensor *)P->Sensors + V->SenPN[I];
      Pu = (struct PidfUnit *)P->Units + V->SenUN[I];


      V->SenVN[I] = (Ps->Src == 'A') ? Ps->AncSen : Ps->VidfNum;
      V->SenAVN[I] = (Ps->Src == 'A') ? Ps->VidfNum : 0;
      V->DLoc[I] = (Ps->Src == 'A') ? 'A' : 'S';
      V->SenNAS[I] = Pu->NTbls;

      if (Pu->NTbls > 0)                                       
      {
         V->SenTbls[I] = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
         V->SenOps[I] = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
      }
   }

   return (1);
}
