#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"
#include "Gmenu_str.h"
#include "libbase_udf.h"
#include "libCfg.h"

ByTe_1 GetPidfStuff (struct SrcInfo *S)
{
   extern struct UserDefs InFo;

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfMode *Pm;
   struct PidfAnc *Pa;
   struct PidfSensor *Ps;
   struct PidfScan *Pc;

   ReadPidf(S->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;

   S->UDFSrc = S->DType;
   switch (S->DType)
   {
      case 0:
      case 1:
        Ps = (struct PidfSensor *)P->Sensors + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;
        S->SenVN =  (Ps->Src == 'A') ? Ps->AncSen : Ps->VidfNum;
        if (Ps->Src == 'A')
           S->UDFSrc = 2;

        S->GetVN = Ps->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }

        NeedAlt (S);
      break;

      case 2:
        Ps = (struct PidfSensor *)P->Sensors + S->SenPN;
        Pa = (struct PidfAnc *)P->Ancil + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;

        S->SenVN = Ps->VidfNum;
        S->GetVN = Pa->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }

        NeedAlt (S);
      break;

      case 6:
        Pm = (struct PidfMode *)P->Modes + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;

        S->SenVN = 0;
        S->GetVN = Pm->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }
      break;
   }

   return (1);
}
