#include <stdio.h>
#include "LinkList.h"
#include "gen_defs.h"
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

/****************************************************************************/
/*  N:       the offset into the plotdef structure array                    */
/*  K:       UDF data key                                                   */
/*  V:       UDF version number                                             */
/*  T:       Time Sync                                                      */
/****************************************************************************/

ByTe_2 GetIt (ByTe_4 N, u_ByTe_4 K, u_ByTe_2 V, struct TiMiNg *T)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct Pidf *P;

   ByTe_4 Bs, Es;
   ByTe_2 By, Bd;
   ByTe_2 R;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;
   ExDa = (struct idf_data *) InFo.UDF;

   if (T->Yr < 0) {                                     /* BEG ASYNC SETS    */
      By = InFo.TB.Yr;                                  /* beg plot year     */
      Bd = InFo.TB.Dy;                                  /* beg plot day      */
      Bs = InFo.TB.Ms/1000;                             /* beg plot sec      */
   } else {                                             /* BEG SYNC SETS     */
      By = T->Yr;                                       /* beg plot year     */
      Bd = T->Dy;                                       /* beg plot day      */
      Bs = T->Ms/1000;                                  /* beg plot sec      */
   }                                                    /* END SYNC SETS     */
   Es = InFo.TE.Ms/1000;                                /* end plot in sec   */

   R = file_open (K, "", V, By, Bd, Bs,                 /* open the UDF file */
           0, InFo.TE.Yr, InFo.TE.Dy, Es, 0, 0);
   ErrorRpt ("FILE_OPEN", R, 1);                        /* rpt any errors    */

   ReadPidf (K, InFo.PIDF);                             /* into the PIDF     */
   P = (struct Pidf *) InFo.PIDF;                       /* pointer to info   */

   if (P->Pf.Blocking == 1) {                           /* BEG REC BLOCKING  */
      if (Pd->BlkOpen) {                                /* BEG RESET BEG TM  */
         Pd->Pb.Yr = -1;                                /* dummy plot Yr     */
         S = (struct SrcInfo *)Pd->Src;                 /* Base UDF structs  */
         if (S->Bt.Yr > 0) {                            /* BEG VALID START   */
            By = S->Bt.Yr;                              /* this is beg year  */
            Bd = S->Bt.Dy;                              /* this is beg day   */
         } 
      }

      R = FilePosRec (K, "", V, InFo.UDF, By, Bd, Bs,    /* pos in file      */
                     0, InFo.TE.Yr, InFo.TE.Dy, Es, 0);  /* to nearest time  */
   }                                                    /* END REC BLOCKING  */
   else
      R = file_pos (K, "", V, InFo.UDF, By, Bd, Bs, 0,  /* pos in file       */
                    InFo.TE.Yr, InFo.TE.Dy, Es, 0);     /* to nearest time   */

   ErrorRpt ("FILE_POS", R, 1);                         /* rpt any errors    */

   if (Pd->SyncSrcs == 1 && T->Yr < 0) {
      R = read_drec (K, "", V, InFo.UDF, -1, 0, 0, 0);
      ErrorRpt ("READ_DREC", R, 0);
      T->Yr = ExDa->byear;
      T->Dy = ExDa->bday;
      T->Ms = ExDa->bmilli;
   }

   return (1);
}
