#include <math.h>
#include <stdio.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void GetBinStats (struct Binning *B, ByTe_4 N, ReaL_4 *Min, ReaL_4 *Max, 
                         ReaL_4 *Cen, ByTe_1 NSca)
{
   ReaL_4 A;

   if (B->N == 1) {                                       /* BEG ONE BIN     */
      *Min = B->Start;                                    /* lower edge      */
      *Max = B->Stop;                                     /* upper edge      */
      *Cen = (*Min + *Max)/2.0;                           /* center value    */
   }                                                      /* END ONE BIN     */
   else                                                   /* multi bin       */
   {                                                      /* BEG MANY BINS   */
      A = (B->Pos == 0) ? B->Start - B->R / 2.0 : B->Start;  /* first edge   */
      *Min = B->R * N + A;                                /* lower bin edge  */
      *Max = B->R * (N + 1) + A;                          /* upper bin edge  */
      *Cen = (*Min + *Max)/2.0;                           /* center value    */
    
      if (B->Sca == 1 && !NSca)                           /* if log scaling  */
      {                                                   /* BEG DELIN EM    */
         *Min = exp(*Min);                                /* lower edge      */
         *Max = exp(*Max);                                /* upper edge      */
         *Cen = exp(*Cen);                                /* bin center      */
      }                                                   /* BEG DELIN EM    */
   }                                                      /* BEG MANY BINS   */
}
