#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void Gen1DPlots (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct config parm;
   extern char *ScatSym[];

   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4  *f1, *f2, *f3, *f4, *fEnD;
   register ByTe_2 *s1;

   ReaL_8 dT;
   ReaL_4 *X, *V, Y1, Y2, Top, Bot, Chk;
   ByTe_4 dY, dYs, Rem;
   ByTe_4 M, Tn, K, TotP, Beg, End, pN, RpN, rN, cO, PN;
   ByTe_2 rV, SrcN, C, *Cp;
   ByTe_1 Cmd[20], *c1, *Cs;
   ByTe_1 EndP;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;
   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S = (struct SrcInfo *)Pd->Src;                      /* pntr to first src  */
   Cs = (ByTe_1 *)Wa.CStore;
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   if (S->LpType == 10)                                /* spectro-scalar     */
      PopUpCBar (PNuM);                                /* colorbar           */

   K = 0;                                              /* 1st plot in series */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      TimeAlign (PN, K, 0);
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1);

      if ((Pd->PStat == 0 && rV == 0) || 
             (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */

      if (Pd->PStat == 0 && CanIgn)                    /* no plot && ignore  */
      {                                                /* BEG IGNORE EMPTIES */
         dT = Pd->Tm.R * Pd->Bx.N;                     /* time across plot   */
         IncTm (&Pd->Pb, &Pd->Pe, dT, Pd->Tm.Sca, 0);  /* next plot tms      */
         continue;                                     /* try the next       */
      }                                                /* END IGNORE EMPTIES */

      s1 = (ByTe_2 *)Pd->SOrder;                       /* source order array */
      SrcN = *s1++;                                    /* first source num   */

      RpN = 0;                                         /* relative plot num  */
      End = Pd->Byl.N - 1;                             /* end of data        */
      for (pN = 0, rN = 1; pN < Pd->nGL; ++pN, ++rN)   /* plot loop          */
      {                                                /* BEG PLOT LOOP      */
         S = (struct SrcInfo *)Pd->Src + SrcN;         /* pntr to data src   */
         EndP = ((rN % Pd->Stack == 0) || rN == Pd->nGL) ? 1 : 0;
         if (pN % Pd->Stack == 0)                      /* need new plot?     */
         {                                             /* BEG NEW PLOT       */
            SetUpRecPlot (PN, K, 0);                   /* set up plot        */
            PopUpPlot (PN, 1, 0);                      /* pre plot stuff     */
         }                                             /* END NEW PLOT       */

         V = (ReaL_4 *)Wa.WorkSpace + 2 * pN * Pd->PlotLen;  /* data is here */
         X = V + Pd->PlotLen;                          /* norms are here     */

         if (Pd->Bx.Empty != 0)                        /* some kind of fill  */
         {                                             /* BEG FILL GAPS      */
            if (Pd->AData[1] != 7 && Pd->AData[0] != 7)
               Normalize (V, X, Pd->Bx.N, 1, 0.0);     /* normalize data     */
            Tn = Pd->Byl.N;                            /* save current Y len */
            Pd->Byl.N = 1;                             /* set to 1           */
            FillGaps (PN, pN, 'X');                    /* fill in X blanks   */
            End = Pd->Bx.N;                            /* this many pixels   */
            Pd->Byl.N = Tn;                            /* restore Y length   */

            f1 = X;                                    /* normals            */
            Beg = 0;                                   /* begin here         */
            while (Beg < Pd->Bx.N && *f1++ < 0.0)      /* get to 1st data    */
               ++Beg;                                  /* increment pos      */

            if (Beg < Pd->Bx.N)                        /* something here     */
            {                                          /* BEG LAST GOOD DATA */
               End = Pd->Bx.N - 1;                     /* End of data        */
               f1 = X + End;                           /* end normal         */
                while (End >= 0 && *f1-- < 0.0)        /* get to last data   */
                  --End;                               /* decrement pos      */
            }                                          /* END LAST GOOD DATA */

            f1 = X + Beg;                              /* start of data      */
            for (M = Beg; M <= End; )                  /* loop over X        */
               *f1++ = M++ + 1;                        /* set X              */

         } else {                                      /* END FILL GAPS      */
            if (Pd->AData[1] != 7 && Pd->AData[0] != 7)
            {
               Normalize (V, X, Pd->Bx.N, 0, 0.0);     /* normalize data     */
               Chk = 0.0;
            }
            else
               Chk = -2.0;
            f1 = X;                                    /* norms are here     */
            f2 = X;                                    /* X's put over norms */
            f3 = V;                                    /* X's put over norms */
            f4 = V;                                    /* X's put over norms */
            Beg = 0;                                   /* num of good data   */
            End = 0;                                   /* num of good data   */
            for (M = 1; M <= Pd->Bx.N; ++M, ++f3)      /* loop over X        */
               if (*f1++ >= Chk)                       /* good data here?    */
               {                                       /* BEG FOUND DATA     */
                  GetBinStats (&Pd->Bx, M, &Top, &Bot, f2++, 0);
                  *f4++ = *f3;
                  ++End;                               /* inc num data pts   */
               }                                       /* BEG FOUND DATA     */
            --End;                                     /* real end           */
         }                                             /* END NO FILL        */

         if (S->LpType < 10)                           /* normal line plot   */ 
         {                                             /* BEG NORMAL PLOT    */
            M = 0;                                     /* counter            */
           Cmd[M++] = S->LpType;                       /* the plot format  */
            if (S->LpType == 2 || S->LpType == 6)      /* scatter or labline */ 
            {
               if (S->ScatSym < 10)
                  c1 = ScatSym[S->ScatSym];
               else
                  c1 = Cs + S->ScatSym;

               while (*c1 != 0)
                  Cmd[M++] = *c1++;
               Cmd[M++] = 0;                           /* format terminator  */

               c1 = Cs + S->SymSize;
                while (*c1 != 0)
                   Cmd[M++] = *c1++;
            }
            else
               Cmd[M++] = 0;                           /* format terminator  */

            Cmd[M++] = 0;                              /* format terminator  */
            Cmd[M] = 0;                                /* format terminator  */
            Cp = &parm.white;                          /* ptr to color info  */
            cO = (S->PCol < 0) ? 10 + (pN % Pd->Stack) % 7 : 0;
            C = *(Cp + S->PCol + cO);                  /* requested plot col */

            if (End >= 0) {
               if (Pd->AData[0] == 7)
                  plot_2d (Pd->Pn, 0, S->PAxis, 8, V, X, X, Beg, End, Cmd, C);
               else
                  plot_2d (Pd->Pn, 0, S->PAxis, 8, X, V, X, Beg, End, Cmd, C);
               if (S->AddErr >= 0) {                   /* add error bars     */ 
                  Cmd[0] = 0;
                  Cmd[1] = (S->AddErr == 4) ? 1 : 0;
                  Cmd[2] = (S->AddErr == 4) ? 3 : S->AddErr;
                  Cmd[3] = 0;
                  Cmd[4] = 0;
                  Cmd[5] = 0;
                  C = *(Cp + S->ECol + cO);
                  if (Pd->AData[0] == 7)
                  {
                     if (Cmd[2] == 0)
                        Cmd[2] = 1;
                     else
                     {
                        if (Cmd[2] == 1)
                           Cmd[2] = 0;
                     }
                     add_ebars (Pd->Pn ,0, S->PAxis, 8, V, X, V, V, X, V, 
                                 Beg, End, Cmd, C, C);    
                  }
                  else
                     add_ebars (Pd->Pn ,0, S->PAxis, 8, X, V, X, X, V, X, 
                                 Beg, End, Cmd, C, C);    
               }
            }
         }                                             /* END NORMAL PLOT    */
         else                                          /* spectoscalar       */
         {                                             /* BEG SPECSCALAR     */
            dY = Pd->P.dY - 1 - Pd->Gap * (Pd->EmptySrc - 1);  /* Y pixels   */
            dYs = dY / Pd->EmptySrc;                   /* pixels per strip   */
            Rem = dY % Pd->EmptySrc;                   /* left over pixels   */
            if (pN > Rem)                              /* used extra pixels  */
            {                                          /* BEG EXTRAS GONE    */
               Y1 = Pd->Yr.Min + pN * (dYs + Pd->Gap) + Rem + 1;  /* begin Y */
               Y2 = Y1 + dYs - 1;                      /* end Y              */
            }                                          /* END EXTRAS GONE    */
            else                                       /* still some to use  */
            {                                          /* BEG MORE EXTRAS    */
               Y1 = Pd->Yr.Min + pN * (dYs + Pd->Gap) + pN + 1;   /* begin Y */
               Y2 = Y1 + dYs;                          /* end Y              */
            }                                          /* END MORE EXTRAS    */

            f1 = X + Beg;                              /* starting X value   */
            f2 = V + Beg;                              /* begin data value   */
            fEnD = X + End;                            /* end of data        */
            for ( ; f1 <= fEnD; ++f1, ++f2)            /* loop over data     */
            {                                          /* BEG DRAW LOOP      */ 
               C = ValToColor (*f2, Pd->Cb.Sca, Pd->CInfo);  /* get color    */
               plt_color (-1, C);                      /* set color          */
               line (Pd->Wn, *f1, Y1, 0., *f1, Y2, 0); /* draw line          */
            }                                          /* END DRAW LOOP      */ 
         }                                             /* END DO ALL PLOTS   */

         if (EndP) {                                   /* need new plot?     */
            PopUpPlot (PN, 0, S->LpType);              /* post plot stuff    */
            AxisLabs (PN, K, S->LpType);               /* axis labels        */
         }                                             /* END NEW PLOT       */
         PlotText (PNuM, SrcN, K, pN, cO);             /* Per Plot Labels    */
         if (EndP)                                     /* need new plot?     */
            ++K;                                       /* to next plot       */
         if (S->SType == 3 && S->OneAll == 3) {        /* all matrix cols    */
            if (++RpN >= S->TCols * S->Col.N) {        /* done with this src */
               SrcN = *s1++;                           /* next src           */
               RpN = 0;                                /* no lines this src  */
            }                                          /* END DONE WITH SRC  */
         } else {
            if (++RpN >= S->Col.N) {                   /* done with this src */
               SrcN = *s1++;                           /* next src           */
               RpN = 0;                                /* no lines this src  */
            }                                          /* END DONE WITH SRC  */
         }
      }                                                /* END PLOT LOOP      */
                                                       /* END PLOT LOOP      */
      ZeroWkSp();                                      /* clear plot arrays  */
      if (Pd->Tm.Fmt != 0) {
         dT = Pd->Tm.R;                                /* time across plot   */
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else 
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, CanIgn);
      }
      dT = Pd->Tm.R * Pd->Bx.N;                        /* time across plot   */

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */
}
