#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_2 FormEdges (ByTe_4 N, void **Edges, ByTe_1 Axis, ByTe_1 Scan, 
                  ByTe_1 C_Only)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct idf_data  *ExDa;
   struct Binning *B;

   register ReaL_4 *f1, *f2, *f3, *fEnD;
   register ByTe_4 *l1;

   ReaL_4 dX, Bi;
   ByTe_4 I, bytes;
   ByTe_2 *Ss, CurLen, LastEdge;
   ByTe_1 *Cs;
   ByTe_1 *X = "", Sc;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;         /* pointer to plot def  */
   B = (Axis == 'X') ? &Pd->Bx : &Pd->Byl;           /* binning info here    */

   bytes = (B->N + 2) * sizeof(ReaL_4);              /* this many bytes      */
   if ((*Edges = malloc(bytes)) == 0)                /* grab space           */
         ErrorRpt ("CUSTOMSCAN", 0, 2);              /* EGADS! an error      */

   if (Scan == 0) {                                  /* BEG BUILD FROM INDEX */
      S = (struct SrcInfo *)Pd->Src;                 /* first Src            */
      Cs = (ByTe_1 *)Wa.CStore;                      /* 1-byte storage       */
      Ss = (ByTe_2 *)Wa.SStore;                      /* 2-byte storage       */
      ExDa = (struct idf_data *) InFo.UDF;           /* UDF return data      */

      if (B->N == ExDa->num_swp_steps) {             /* BEG XFER CENTERS     */
         f1 = (ReaL_4 *) *Edges + 1;                 /* put centers here     */
         f2 = (ReaL_4 *) S->Alt;                     /* converted scan       */
         fEnD = f1 + B->N;                           /* and end here         */
         for ( ; f1 < fEnD; ) { *f1++ = *f2++; }     /* xfer                 */
      } else {                                       /* BEG BUILD CENTERS    */
         I = 0;                                      /* first index          */
         CurLen = ExDa->num_swp_steps;               /* current swp len      */
         while (I < B->N) {                          /* BEG COLLECT INDICES  */
             ExDa->num_swp_steps = 0;                /* no steps             */
             l1 = ExDa->swp_data;                    /* load new steps here  */
             while (I < B->N && ExDa->num_swp_steps < CurLen) 
             {                                        /* BEG FILL INDICES    */
                *l1++ = I++;                          /* add this index      */
                ++ExDa->num_swp_steps;                /* inc num of indices  */
             }                                        /* END FILL INDICES    */

             f1 = (ReaL_4 *) *Edges + ExDa->swp_data[0] + 1;
             convert_to_units (S->Key, X, S->Ver, InFo.UDF,
                           SCAN_INDEX, 0, S->AltNAS, Cs + S->AltTbls,
                           Ss + S->AltOps, f1, 0, 0L);
         }                                            /* BEG COLLECT INDICES */
      }                                               /* END BUILD CENTERS   */

      Sc = (S->AltSca == 'L') ? 1 : 0;                /* set bin scaling      */

      if (Sc == 1)                                    /* Log scaled array    */
      {                                               /* BEG LINEARIZE EM    */
         f1 = (ReaL_4 *) *Edges + 1;                  /* centers beg here    */
         fEnD = f1 + B->N;                            /* and end here        */
         for ( ; f1 < fEnD; ++f1)                     /* loop over values    */
            *f1 = log(*f1);                           /* and linearize       */
      }                                               /* END LINEARIZE EM    */

      if (C_Only == 0)                                /* pass back edges     */
      {                                               /* BEG FORM EDGES      */
         f1 = (ReaL_4 *) *Edges + 1;                  /* ptr to 1st center   */
         f2 = (ReaL_4 *) *Edges + 2;                  /* ptr to 2nd center   */
         f3 = (ReaL_4 *) *Edges;                      /* pointer to bands    */
         fEnD = f1 + B->N;                            /* stop loop here      */
         LastEdge = B->N;                             /* number of edged     */
         dX = (*(fEnD - 1) - *(fEnD - 2)) / 2.0;      /* last bandwidth      */

         *f3++ = *f1 - (*f2 - *f1)/2.0;               /* first edge          */
         for ( ; f2 < fEnD; ++f1 , ++f2)              /* make band loop      */
            *f3++ = *f1 + (*f2 - *f1) / 2.0;          /* upper band edge     */

         *f3 = *f1 + dX;                              /* last band edge      */
      }                                               /* END FORM EDGES      */
      else                                            /* give me centers     */
      {                                               /* BEG FORM CENTERS    */
         LastEdge = B->N - 1;                         /* number of edged     */
         f1 = (ReaL_4 *) *Edges + 1;                  /* ptr to 1st center   */
         f3 = (ReaL_4 *) *Edges;                      /* pointer to bands    */
         fEnD = f1 + B->N;                            /* stop loop here      */
 
         for ( ; f2 < fEnD; ++f1)                     /* make centers loop   */
            *f3++ = *f1++;                            /* band center         */
      }                                               /* END FORM CENTERS    */
   }                                                  /* END SCAN INDEX      */
   else                                               /* build from specs    */
   {                                                  /* BEG BUILD USER BNDS */
      Sc = B->Sca;                                    /* hold scaling here   */
      f1 = (ReaL_4 *) *Edges;                         /* put centers here    */
      Bi = B->Start;                                  /* first edge          */
      if (C_Only == 0)                                /* pass back edges     */
      {                                               /* BEG USER BAND EDGES */
         LastEdge = B->N;                             /* number of edged     */
         if (B->Pos == 0)                             /* value is center     */
            Bi -= B->R / 2.0;                         /* so center it        */
         for ( I = 0; I <= B->N; )                    /* contig band loop    */
            *f1++ = B->R * I++ + Bi;                  /* build band edges    */
      }                                               /* END USER BAND EDGES */
      else                                            /* give me centers     */
      {                                               /* BEG USER CENTERS    */
         LastEdge = B->N - 1;                         /* number of edged     */
         if (B->Pos == 1)                             /* value is edge       */
            Bi += B->R / 2.0;                         /* so center it        */
         for ( I = 0; I < B->N; )                     /* contig band loop    */
            *f1++ = B->R * I++ + Bi;                  /* build band edges    */
      }                                               /* END USER CENTERS    */
   }                                                  /* END USER SCAN ARRAY */

   if (Sc == 1)                                       /* if log scaling      */
   {                                                  /* BEG UNLINEARIZE EM  */
      f1 = (ReaL_4 *) *Edges;                         /* bin edges beg here  */
      fEnD = f1 + B->N + 1;                           /* and end here        */
      for ( ; f1 < fEnD; ++f1)                        /* loop over values    */
         *f1 = exp(*f1);                              /* and linearize       */
   }                                                  /* END UNLINEARIZE EM  */

   return (LastEdge);
}
