#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_2 FetchData (ByTe_4 PN, ByTe_4 SrcN, ByTe_1 FwD)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct idf_data  *ExDa;

   ReaL_4 *f1, *f2, *f3, *f4, *fEnD;
   ByTe_4 sS, nS;
   ByTe_2 *Ss, R, Rs, N;
   ByTe_1 *Cs, *Sp;
   ByTe_1 *X = "";


   Pd = (struct PlotDef *)InFo.PlotDefs + PN;
   S = (struct SrcInfo *)Pd->Src + SrcN;

   if (S->PrevRead == 1 && !FwD)
      return (1);

   Cs = (ByTe_1 *)Wa.CStore;
   Ss = (ByTe_2 *)Wa.SStore;
   ExDa = (struct idf_data *) InFo.UDF;

   Rs = read_drec (S->Key, X, S->Ver, InFo.UDF, S->SenVN, S->SenCN, FwD, 0);
   ErrorRpt ("READ_DREC", Rs, 0);

   if (!S->PrevRead) {
      S->DPres = ExDa->filled_data;
      S->TCols = ExDa->TotCols;
   }

   if ((Rs == ALL_OKAY || ExDa->filled_data) && !S->PrevRead)
   {
      CheckMem (Pd, SrcN);

   /**************************************************************************/
   /*  Switch on the type of data which is being requested                   */
   /*                                                                        */
   /*  0: Sensor                                                             */
   /*  1: Scan                                                               */
   /*  2: Ancillary                                                          */
   /*  3: Spin Angle                                                         */
   /*  4: Pitch Angle                                                        */
   /*  5: Quality                                                            */
   /*  6: Mode                                                               */
   /**************************************************************************/

      S->PrevRead = 1;
      switch (S->UDFSrc) 
      {
         case 0: 
           f1 = (ReaL_4 *)S->Pri;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, SENSOR, 0, 
                                 S->GetNAS, Cs + S->GetTbls, Ss + S->GetOps, 
                                 f1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = ExDa->num_sample;

         case 1:
           FetchAlt (PN, SrcN);
         break;

         case 2: 
           f1 = (ReaL_4 *)S->Pri;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, ANCILLARY, 
                                (ByTe_1)S->GetVN, S->GetNAS, Cs + S->GetTbls,
                                 Ss + S->GetOps, f1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = ExDa->num_sample;
           FetchAlt (PN, SrcN);
         break;

         case 5:
           f1 = (ReaL_4 *)S->Pri;
           *f1 = ExDa->d_qual;
           S->DLen  = 1;
         break;

         case 6: 
           f1 = (ReaL_4 *)S->Pri;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, MODE, 
                                (ByTe_1)S->GetVN, S->GetNAS, Cs + S->GetTbls,  
                                Ss + S->GetOps, f1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = 1;

          break;

      }

 /****************************************************************************/
 /* NOTE:  Only need to consider left-hand Y axis in data considerations     */
 /*        right-hand Y axis is limited to VALUE only                        */
 /****************************************************************************/

      Sp = Cs + Pd->SecPos + 3;                 /* Sec offsets beg at spin   */
     
      for (N = 3; N < DATADEFS; ++Sp, ++N)      /* secondary data prod loop  */
      {                                         /* BEG FILL SECONDARYS       */
         f1 = (ReaL_4 *)S->Sec;                 /* beg secondary data        */
         if (*Sp >= 0)                          /* valid offset?             */
         {                                      /* BEG THE FILL              */
            f1 += *Sp * S->DLen;                /* beg putting data here     */
            fEnD = f1 + S->DLen;                /* end xfer                  */
            switch (N)                          /* switch on item            */
            {                                   /* BEG ITEM SWITCH           */
               case 3:                          /* START SPIN ANGLE          */
                 f2 = f1 + S->DLen;             /* end angle here            */
                 f3 = (ReaL_4 *)ExDa->start_az; /* beg azimuth angles        */
                 f4 = (ReaL_4 *)ExDa->stop_az;  /* end azimuth angles        */
                 for ( ; f1 < fEnD; )           /* xfer loop                 */
                 {                              /* BEGIN ANGLE XFER LOOP     */
                    *f1++ = *f3++;              /* xfer a beg azimuth        */
                    *f2++ = *f4++;              /* xfer an end azimuth       */
                 }                              /* BEGIN ANGLE XFER LOOP     */
               break;                           /* STOP SPIN ANGLE           */
               case 4:                          /* START PITCH ANGLE         */
                  f2 = ExDa->pitch_angles;      /* pitch angles here         */
                  for ( ; f1 < fEnD; )          /* xfer loop                 */
                     *f1++ = *f2++;             /* xfer a beg azimuth        */
               break;                           /* STOP PITCH ANGLE          */
               case 5:                          /* START THETA ANGLE         */
                 f2 = f1 + S->DLen;             /* end angle here            */
                 f3 = (ReaL_4 *)ExDa->start_theta; /* beg polar angles       */
                 f4 = (ReaL_4 *)ExDa->stop_theta;  /* end polar angles       */
                 if (*f3 < 0.0)                 /* no valid theta values     */
                 {                              /* BEG NO THETA              */
                    f3 = (ReaL_4 *)S->Alt;      /* ptr to array indices      */
                    for ( ; f1 < fEnD; )        /* xfer loop                 */
                    {                           /* BEG ANGLE XFER LOOP       */
                       *f1++ = *f3;             /* xfer a beg theta          */
                       *f2++ = *f3++;           /* xfer an end theta         */
                    }                           /* END ANGLE XFER LOOP       */
                 }                              /* END NO THETA              */
                 else                           /* VIDF const theta values   */
                 {                              /* BEG VIDF THETA            */
                    for ( ; f1 < fEnD; )        /* xfer loop                 */
                    {                           /* BEG ANGLE XFER LOOP       */
                       *f1++ = 90.0 - *f3++;    /* xfer a beg theta          */
                       *f2++ = 90.0 - *f4++;    /* xfer an end theta         */
                    }                           /* END ANGLE XFER LOOP       */
                 }                              /* END VIDF THETA            */
               break;                           /* STOP SPIN ANGLE           */
            }                                   /* END ITEM SWITCH           */
         }                                      /* END THE FILL              */
      }                                         /* END FILL SECONDARYS       */

      if (S->Eg.Yr > 0) {                               /* BEG LAST END TIME */
         S->Eg.Yr = S->Et.Yr;                           /* last ending year  */
         S->Eg.Dy = S->Et.Dy;                           /* last ending day   */
         S->Eg.Ms = S->Et.Ms;                           /* last ending msec  */
         S->Eg.Ns = S->Et.Ns;                           /* last ending nsec  */
      }                                                 /* END LAST END TIME */
      S->Bt.Yr = ExDa->byear;                           /* ending year       */
      S->Bt.Dy = ExDa->bday;                            /* ending day        */
      S->Bt.Ms = ExDa->bmilli;                          /* ending msec       */
      S->Bt.Ns = ExDa->bnano;                           /* ending nsec       */
      S->Et.Yr = ExDa->eyear;                           /* ending year       */
      S->Et.Dy = ExDa->eday;                            /* ending day        */
      S->Et.Ms = ExDa->emilli;                          /* ending msec       */
      S->Et.Ns = ExDa->enano;                           /* ending nsec       */
      if (S->Eg.Yr < 0) {                               /* BEG LAST END TIME */
         S->Eg.Yr = S->Et.Yr;                           /* last ending year  */
         S->Eg.Dy = S->Et.Dy;                           /* last ending day   */
         S->Eg.Ms = S->Et.Ms;                           /* last ending msec  */
         S->Eg.Ns = S->Et.Ns;                           /* last ending nsec  */
      }                                                 /* END LAST END TIME */
   }

   if (FwD == 1)
   {
      sS = (InFo.TE.Ms + (InFo.TE.Ns / 1000000)) / 1000;
      nS = (InFo.TE.Ms % 1000) * 1000000 + InFo.TE.Ns;
      Rs = ReOpenFile (S->Key, X, S->Ver, InFo.UDF, 0, 0, 0, 0,
                       InFo.TE.Yr, InFo.TE.Dy, sS, nS, Rs); 
      ErrorRpt ("REOPENFILE", Rs, 0);
   }

   return (Rs);
}
