#include <stdio.h>
#include <strings.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all contour specific labels especially those        */
/*  associated with the positioning of the 3D plane.                         */
/*****************************************************************************/

void ContLabs (ByTe_4 N, ByTe_2 sN, ByTe_4 pN, ByTe_4 RelPn, ByTe_2 LSrc)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;

   ReaL_4 X, Y, Sz[2], R, XL, XR, Sn, Lv, dX, dY; 
   ByTe_4 Lev;
   ByTe_2 *s1, C;
   ByTe_1 L[100], Wn; 
   ByTe_1 J;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */

   if (Pd->Li[6].Fmt < 0)                              /* no labeling        */
      return;                                          /* nothing to do      */

   Wn = Pd->Wn;                                        /* plot number        */
   s1 = &parm.white;                                   /* base color         */
   Lev = (Pd->Li[5].LocB == 0) ? LSrc / 2 : LSrc;      /* label level        */

   clip (Wn, 0);                                       /* turn off clipping  */
   chr_size (Pd->Li[5].Size);                          /* label size         */
   get_chsz (Sz);                                      /* character size     */

   C = *(s1 + Pd->Li[5].Color);                        /* label color        */
   if (parm.ostyle == 0)                               /* landscape          */
   {                                                   /* BEG LANDSCAPE SETS */
      XL = 0.0;                                        /* Left X Coordinate  */
      XR = 1.0;                                        /* Right X Coordinate */
      Sn = 1.0;                                        /* no reversal        */
   }                                                   /* END LANDSCAPE SETS */
   else                                                /* portrait           */
   {                                                   /* BEG PORTRAIT SETS  */
      XL = 1.0;                                        /* Left X Coordinate  */
      XR = 0.0;                                        /* Right X Coordinate */
      Sn = -1.0;                                       /* reversal           */
   }                                                   /* END PORTRAIT SETS  */

   if (Pd->Li[5].LocA < 4)                             /* Label Along X-Axis */
   {                                                   /* BEG X SETS         */
      R = 0.0;                                         /* non-rotated labels */
      Y = (Pd->Li[5].LocA == 0) ? 0.0 : 1.0;           /* L0 Y begin point   */
      Y += Pd->Li[5].YOff * Sz[1];                     /* corrected L0 Y pos */
      Lv = 1.25 * Lev * Sz[1]; 
      Y = (Pd->Li[5].YOff > 0.0) ? Y + Lv : Y - Lv; /* level displacement */

      dX = Sn * Pd->Li[5].XOff * Sz[0];                /* Xoffset            */
      switch (Pd->Li[5].LocB)                          /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           if ((LSrc % 2) == 0)                        /* left or right lab  */
           {                                           /* BEG LEFT SETS      */
              X = XL + dX;                             /* pos at left axis   */
              J = -1;                                  /* and left justify   */
           }                                           /* END LEFT SETS      */
           else                                        /* on the right       */
           {                                           /* BEG RIGHT SETS     */
              X = XR - dX;                             /* pos at right axis  */
              J = 1;                                   /* and right justify  */
           }                                           /* END RIGHT SETS     */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           X = XL + dX;                                /* pos at left axis   */
           J = -1;                                     /* and left justify   */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           X = 0.5 + dX;                               /* pos at center axis */
           J = 0;                                      /* and center justify */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           X = XR + dX;                                /* pos at right axis  */
           J = 1;                                      /* and right justify  */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END X SETS         */
   else                                                /* label along Y      */
   {                                                   /* BEG Y SETS         */
      if (Pd->Li[5].LocB == 2)                         /* if centered lab    */
         R = (Pd->Li[5].LocA == 4) ? 90.0 : -90.0;     /* L0 label rotation  */
      else                                             /* not centered       */
         R = 0.0;                                      /* horizontal label   */
      X = (Pd->Li[5].LocA == 4) ? XL : XR;             /* L0 X begin point   */
      X += Sn * Pd->Li[5].XOff * Sz[0];                /* corrected L0 X pos */

      dY = Lev * Pd->Li[5].YOff * Sz[1];               /* YOffset            */
      switch (Pd->Li[5].LocB)                          /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           Y = 0.5 + dY;                               /* pos at left axis   */
           J = 0;                                      /* and left justify   */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           Y = dY;                                     /* pos at left axis   */
           J = -1;                                     /* and left justify   */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           Y = 0.5 + dY;                               /* pos at center axis */
           J = 0;                                      /* and center justify */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           Y = 1.0 + dY;                               /* pos at right axis  */
           J = -1;                                     /* and right justify  */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END Y SETS         */

   LabelMkr (N, sN, pN, RelPn, 4, LSrc,  L);           /* form source label  */
   chr_dspl (Wn, X, Y, 0., R, 0., 0., 0, J, L, -1, C);
}
