#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_2 ChkUnits (struct SrcInfo *S, ByTe_2 N)
{
   extern struct UserDefs InFo;

   struct Pidf *P;
   struct PidfSensor *Ps;
   struct PidfUnit *Pbu, *Pu;
   struct PidfMode *Pm;
   struct PidfScan *Pc;

   register ByTe_2 *s1, *sEnD;

   ByTe_2 LId, NumUnits;
   ByTe_1 Status = -1;

   P = (struct Pidf *) InFo.PIDF;                  /* PIDF interface struct  */ 
   Pbu = (struct PidfUnit *)P->Units;              /* Base Unit Info         */
   Pu = Pbu + S->GetUN;                            /* current Unit Info      */
   LId = Pu->LocalId;                              /* Local ID of sel unit   */

   switch (S->DType)                               /* switch on data type    */
   {                                               /* BEG DATA TYPE SWITCH   */
      case 0:                                      /* START SENSOR           */
        Ps = (struct PidfSensor *)P->Sensors + N;  /* Sensor Info            */ 
        Pu = Pbu + S->GetUN;                       /* Selected Unit Info     */
        NumUnits = Ps->NUnits;                     /* total number of units  */
        s1 = Ps->Units;                            /* Unit nums are here     */
      break;                                       /* STOP SENSOR            */
      case 1:                                      /* START SCAN             */
        Ps = (struct PidfSensor *)P->Sensors + N;  /* Sensor Info            */ 
        Pc = (struct PidfScan *)P->Scans + Ps->ScanBlk;  /* Scan Info        */ 
        Pu = Pbu + S->AltUN;                       /* Selected Unit Info     */
        NumUnits = Pc->NUnits;                     /* total number of units  */
        s1 = Pc->Units;                            /* Unit nums are here     */
      break;                                       /* STOP SCAN              */
      case 6:                                      /* START MODE             */
        Pm = (struct PidfMode *)P->Modes + N;      /* Sensor Info            */ 
        Pu = Pbu + S->AltUN;                       /* Selected Unit Info     */
        NumUnits = Pm->NUnits;                     /* total number of units  */
        s1 = Pm->Units;                            /* Unit nums are here     */
      break;                                       /* STOP MODE              */
   }                                               /* BEG DATA TYPE SWITCH   */

   if (NumUnits  > 0)                              /* Do we have units?      */
   {                                               /* BEG HAVE UNITS         */
      sEnD = s1 + NumUnits;                        /* Last Unit Number       */
      for ( ; s1 < sEnD; ++s1)                     /* Loop over units        */
      {                                            /* BEG UNIT SRCH LOOP     */
         if (*s1 == S->GetUN)                      /* Match Base Sen Units?  */
            Status = *s1;                          /* set Status             */
         else                                      /* not upper level match  */
         {                                         /* BEG 2nd LEVEL UNIT CHK */
            if (LId >= 0)                          /* Local Units Id set?    */
            {                                      /* BEG CHK LOCAL UNIT ID  */
               Pu = Pbu + *s1;                     /* unit info here         */
               if (Pu->LocalId == LId)             /* 2nd level match?       */
                  Status = *s1;                    /* WOW! Set Status        */
            }                                      /* BEG CHK LOCAL UNIT ID  */
         }                                         /* END 2nd LEVEL UNIT CHK */
      }                                            /* BEG UNIT SRCH LOOP     */
   }                                               /* END HAVE UNITS         */

   return (Status);
}
