#include <stdio.h>
#include <stdlib.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void CPlots (ByTe_4 PNuM)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct cont_info cinfo;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct ConTouR *Ct;
   struct PlaneInfo *Pn;

   ReaL_4 *X, *Y, *Z, *V;
   ReaL_4 Bad;
   ByTe_4 K, TotP, pN, nP, Len, PN;
   ByTe_2 rV;
   ByTe_1 New, CuT;
   ByTe_1 CanIgn, tBase;

   PN = PNuM % InFo.NPDefs;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   Ct = (struct ConTouR *)Pd->Cont;                    /* contour info       */
   CuT = (Pd->CCut == 0) ? 0 : 1;                      /* cut defined flag   */

   if (Ct->Method == 0)                                /* 3D data?           */
      Pn = (struct PlaneInfo *)Pd->Plane;              /* plane def info     */

   S = (struct SrcInfo *)Pd->Src;                      /* pntr to first src  */
   TotP = Pd->Rows * Pd->Cols - Pd->ExPlots;           /* total plots        */
   PlotInits (PN);                                     /* init plot params   */
   CanIgn = (Pd->AlignPd < PN && Pd->AlignPd >= 0) ?   /* ignore blanks flag */
             0 : (Pd->IgnBlank == 0) ? 1 : 0;

   PopUpCBar (PNuM);                                   /* colorbar           */

   K = 0;                                              /* 1st plot in series */
   while (K < TotP)                                    /* loop over plots    */
   {                                                   /* BEG DO ALL PLOTS   */
      Pd->PlotLen = 0;                                 /* zero plot length   */
      TimeAlign (PN, K, 0);
      rV = BuildPlots (PN);                            /* build plots        */
      TimeAlign (PN, K, 1);

      if ((Pd->PStat == 0 && rV == 0) || 
             (Pd->PStat == 0 && Pd->More == -1))
         break;                                        /* done               */

      if (Pd->PStat == 0 && CanIgn) {                  /* BEG IGNORE EMPTIES */
         Pd->Pb.Yr = S->Bt.Yr;                           /* end yr to beg yr */
         Pd->Pb.Dy = S->Bt.Dy;                           /* end dy to beg dy */
         Pd->Pb.Ms = S->Bt.Ms;                           /* end ms to beg ms */
         IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, 1); /* next plot tms */
         continue;                                          /* try the next  */
      }                                                /* END IGNORE EMPTIES */

      New = 1;                                       /* new tool data        */
      if (Ct->Method == 0)                           /* 3D data              */
      {                                              /* BEG 3D               */
         Len = Wa.SizeWork / 7;                      /* length each varaible */
         V = (ReaL_4 *)Wa.WorkSpace;                 /* Intentsity           */
         X = V + Len;                                /* X                    */
         Y = X + Len;                                /* Y                    */
         Z = Y + Len;                                /* Z                    */
         nP = Pn->Steps;                             /* number of sub-plots  */
      }                                              /* END 3D               */
      else                                           /* normal 2D data       */
      {                                              /* BEG 2D               */
         Len = Wa.SizeWork/3;                        /* length each varaible */
         V = (ReaL_4 *)Wa.WorkSpace;                 /* Intentsity           */
         X = V + Len;                                /* X                    */
         Y = X + Len;                                /* Y                    */
         nP = 1;                                     /* max one plot         */
      }                                              /* END 2D               */

      for (pN = 0; pN < nP; ++pN)                      /* collapse plot loop */
      {                                                /* BEG CONT PLOT LOOP */
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             PolarToCartesian (PN, New);               /* convert data       */
             XferContour(PN, pN, New);                 /* cont struc inits   */
             Bad = 10.0 * cinfo.Utol;                  /* out of limits      */
          }                                            /* END NON EMPTY PLOT */

          if (Pd->OutFmt == 0)                         /* cartesian output   */
             SetUpRecPlot (PN, K, 0);                  /* set up plot        */
          else                                         /* carteographic      */
             SetUpMapPlot (PN, K);                     /* set up plot        */
          if (CuT)                                     /* Cut plot defined   */
             SetUpRecPlot (PN, K, 1);                  /* set up plot        */
          PopUpPlot (PN, 1, 0);                        /* plot box and text  */
          
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             PlotCut (PN, 0);                          /* plot cuts          */
             MkContour (Pd->Wn, V, X, Y, Z, Pd->PlotLen); /* make plot       */
             PlotCut (PN, 1);                          /* plot cuts          */
          }                                            /* END NON EMPTY PLOT */
          PopUpPlot (PN, 0, 1);                        /* plot box and text  */
          if (Pd->PStat == 1) {                        /* BEG NON EMPTY PLOT */
             Tools (PN, 0, 1, New, 0);                 /* vector plot tool   */
             Tools (PN, 0, 3, New, pN);                /* draw globe         */
             Tools (PN, 0, 4, New, pN);                /* draw globe         */
             New = 0;                                  /* hold vector data   */
          }                                            /* END NON EMPTY PLOT */
          PlotText (PNuM, 0, K, 0, 0);                 /* Per Plot Labels    */
          if (Pd->OutFmt == 0)                         /* cartesian output   */
             AxisLabs (PN, K++, 0);                    /* axis labels        */
          else                                         /* carteographic      */
             ++K;                                      /* just advance plot  */
      }                                                /* END CONT PLOT LOOP */
      ZeroWkSp();                                      /* clear plot arrays  */
      if (CanIgn) {                                    /* BEG RESET TIME     */
         Pd->Pb.Yr = S->Bt.Yr;                         /* end yr to beg yr   */
         Pd->Pb.Dy = S->Bt.Dy;                         /* end dy to beg dy   */
         Pd->Pb.Ms = S->Bt.Ms;                         /* end ms to beg ms   */
      }                                                /* END RESET TIME     */

      if (Pd->Tm.Fmt != 0) {
         if (Pd->Tm.OrigSca == 9) {
            tBase = (CanIgn) ? Pd->Tm.OrigSca : Pd->Tm.Sca;
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, tBase, 0);
         } else 
            IncTm (&Pd->Pb, &Pd->Pe, Pd->Tm.R, Pd->Tm.Sca, CanIgn);
      }

      if (rV == 0)                                     /* out of data        */
         break;                                        /* then done          */
   }                                                   /* END DO ALL PLOTS   */
}
