#include <stdlib.h>
#include <math.h>
#include "util_str.h"
#include "idf_defs.h"
#include "user_defs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void AxisRes (struct PlotDef *Pd, ByTe_2 AxisN)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct Binning  *Bn;
   struct AxisInfo  *Ax;
   struct SrcInfo  *S;

   ReaL_8 PRes, dT, dR;
   ByTe_2 dS, R;   
   ByTe_1 Axis;

   ExDa = (struct idf_data *) InFo.UDF;              /* ptr to data          */
   switch (AxisN)                                    /* axis specific setup  */
   {                                                 /* BEG POINTER SETUP    */
      case 0:                                        /* START X AXIS         */
         Bn = &Pd->Bx;                               /* binning info         */
         Ax = &Pd->Xb;                               /* axis info            */
         PRes = Pd->P.dX;                            /* X pixel resolution   */
         Axis = 0;                                   /* graphics X axis      */
      break;                                         /* STOP X AXIS          */
      case 1:                                        /* START LEFT Y AXIS    */
         Bn = &Pd->Byl;                              /* binning info         */
         Ax = &Pd->Yl;                               /* axis info            */
         Axis = 4;                                   /* graphics Y left axis */
         PRes = Pd->P.dY;                            /* Y pixel resolution   */
      break;                                         /* STOP LEFT Y AXIS     */
      case 2:                                        /* START RIGHT Y AXIS   */
         Bn = &Pd->Byr;                              /* binning info         */
         Ax = &Pd->Yr;                               /* axis info            */
         Axis = 6;                                   /* Y right axis number  */
         PRes = Pd->P.dY;                            /* Y pixel resolution   */
      break;                                         /* STOP RIGHT Y AXIS    */
   }                                                 /* END POINTER SETUP    */

   if (Pd->AData[AxisN] == 3)                        /* if phi on this axis  */
      Bn->Dir = (ExDa->spin_rate > 0) ? 1 : -1;      /* angle direction      */
   else                                              /* else                 */
      Bn->Dir = 0;                                   /* unset                */

   switch (Pd->AData[AxisN])                         /* swtich on axis unit  */
   {                                                 /* BEG AXIS UNIT SWITCH */
      case 0:                                        /* START TIME           */
        if (Pd->Tm.Fmt == 0)                         /* time by plot         */
           Pd->Tm.R /= Pd->Tm.N;                     /* time per pixel       */
        else                                         /* user selected time   */
        {                                            /* BEG USER TIME        */
           dT = Pd->Tm.R * Pd->Tm.N;                 /* time across plot     */
           IncTm (&Pd->Pb, &Pd->Pe, dT, Pd->Tm.Sca, 1); /* plot end time     */
        }                                            /* END USER TIME        */

        Bn->R = Pd->Tm.R;                            /* also axis resolution */
        Bn->Sca = Pd->Tm.Sca;                        /* and axis scaling     */
        Bn->Fmt = Pd->Tm.Fmt;                        /* and axis format      */
        Bn->Dir = Pd->Tm.Dir;                        /* and axis direction   */
        Bn->N = Pd->Tm.N;                            /* pixels along axis    */
      break;                                         /* STOP TIME            */

      case 1:                                        /* START VALUE          */
        if (Bn->Fmt == 0)                            /* no format set        */
        {                                            /* BEG NO BINS DEFINED  */
           Bn->N = PRes;                             /* resluotion           */
           Bn->Stop = Ax->Max;                       /* max bin center       */
           Bn->Start = Ax->Min;                      /* min bin center       */
           Bn->Sca = Ax->Sca;                        /* min bin center       */
           dR = Bn->N;                               /* num of bins          */
        }                                            /* END NO BINS DEFINED  */
        else                                         /* defined bins         */
           dR = (Bn->Pos == 0) ? Bn->N - 1 : Bn->N;  /* num of bins          */
      break;                                         /* STOP VALUE           */

      case 2:                                        /* START SCAN           */
      case 9:                                        /* START SCAN           */
        if (Bn->Fmt == 0)                            /* use num of pixels    */
        {                                            /* BEG NUM OF PIXELS    */
           if (Pd->PType == 5)                       /* spectra plot         */
           {                                         /* BEG NOT SCAN         */
              Bn->N = PRes;                          /* pixels across plot   */
              Bn->Stop = Ax->Max;                    /* max bin center       */
              Bn->Start = Ax->Min;                   /* min bin center       */
              Bn->Sca = Ax->Sca;                     /* min bin center       */
           }                                         /* END NOT SCAN         */
           else                                      /* must be scan         */
           {                                         /* BEG ITS SCAN         */
              S = (struct SrcInfo *) Pd->Src;        /* source structure     */
              R = read_idf (S->Key, "", S->Ver, (char *)&dS, _SwpLeN, 0, 0, -1);
              Bn->N = dS;                            /* save plot scan len   */
              Bn->R = 1;                             /* resolution           */
              Bn->Start = 0;                         /* start index          */
              Bn->Stop = Bn->N - 1;                  /* stop index           */
              Bn->Sca = 0;                           /* always linear scale  */
              Bn->Pos = 0;                           /* always centers       */
           }                                         /* END ITS SCAN         */
        }                                            /* END NUM OF PIXELS    */

        dR = (Bn->Pos == 0) ? Bn->N - 1 : Bn->N;     /* num of bins          */
      break;                                         /* STOP SCAN            */

      case 6:                                        /* START SOURCE NUMBER  */
        if (Bn->Fmt == 0)                            /* no format set        */
        {                                            /* BEG SET FORMAT       */
           S = (struct SrcInfo *) Pd->Src;           /* source structure     */

           if (S->SType != 3)
              R = read_idf (S->Key, "", S->Ver, (char *)&dS, _SeN, 0, 0, -1);
           else
              dS = S->TCols;
           Bn->N = dS;                               /* save plot scan len   */
           Bn->R = 1;                                /* resolution           */
           Bn->Start = 0;                            /* start index          */
           Bn->Stop = Bn->N - 1;                     /* stop index           */
           Bn->Sca = 0;                              /* always linear scale  */
           Bn->Pos = 0;                              /* always centers       */
        }                                            /* BEG SET FORMAT       */
        dR = (Bn->Pos == 0) ? Bn->N - 1 : Bn->N;     /* num of bins          */
      break;                                         /* STOP SOURCE NUMBER   */

      default:                                       /* START ALL THE REST   */
        if (Bn->Fmt == 0)                            /* use num of pixels    */
        {                                            /* BEG NUM OF PIXELS    */
           Bn->N = PRes;                             /* pixels across plot   */
           Bn->Stop = Ax->Max;                       /* max bin center       */
           Bn->Start = Ax->Min;                      /* min bin center       */
           Bn->Sca = Ax->Sca;                        /* min bin center       */
        }                                            /* END NOT SCAN         */
        dR = (Bn->Pos == 0) ? Bn->N - 1 : Bn->N;     /* num of bins          */
      break;                                         /* STOP ALL THE REST    */
   }                                                 /* END AXIS UNIT SWITCH */

   if (Pd->AData[AxisN] != 0)                        /* not a time axis      */
   {                                                 /* BEG RESOLUTION SETUP */
      if (Bn->Sca == 1)                              /* if log scaling       */
      {                                              /* BEG TAKE LOGS        */
         Bn->Stop = log(Bn->Stop);                   /* log end val          */
         Bn->Start = log(Bn->Start);                 /* log start            */
      }                                              /* END TAKE LOGS        */

      Bn->R = (Bn->Stop - Bn->Start) / dR;           /* bin resolution       */
      if (Bn->Dir == 0)                              /* flow direct unset?   */
         Bn->Dir = (Bn->R > 0) ? 1 : -1;             /* dir of movement      */
   }                                                 /* END RESOLUTION SETUP */
}
