#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all labels associated with a given line plot        */
/*****************************************************************************/

void AxisNum (ByTe_4 N, ByTe_1 Axis, ByTe_1 Type)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct AxisInfo *Ax;
   struct CutDef *cD;

   ReaL_4 Y, Yb, P;
   ByTe_4 I, Extra, dY, dYs, Rem, YLen;
   ByTe_2 C, Skip;
   ByTe_1 L0[50]; 
   ByTe_1 DoNum, Pn, An, Xp;
   ByTe_1 pN, BCut = 0;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;            /* plot info struct  */
   C = parm.white;                                      /* white label color */
   if (Axis == 0)                                       /* X axis            */
   {                                                    /* BEG X AXIS SETS   */
      Ax = &Pd->Xb;                                     /* x axis info       */
      An = 0;                                           /* axis number       */
   }                                                    /* END X AXIS SETS   */
   else                                                 /* one of the y axes */
   {                                                    /* BEG Y AXIS SETS   */
      if (Axis == 1) {                                  /* Left Y axis       */
         Ax = &Pd->Yl;                                  /* left y axis info  */
         An = 4;                                        /* axis number       */
      } else {                                          /* END LEFT Y SETS   */
         Ax = &Pd->Yr;                                  /* left y axis info  */
         An = 6;                                        /* axis number       */
      }                                                 /* END RIGHT Y SETS  */
   }                                                    /* END Y AXIS SETS   */

   switch (Pd->AData[(ByTe_4)Axis]) {                   /* label by plottype */ 
      case 0:                                           /* START TIME        */
         Xp = (Ax->DoLabs > 0 ) ? 1 : 0;                /* ticks (+ Labels?) */
         if (Xp == 1 && Pd->Yl.DoLabs > 0)              /* can do Y labs too */
            ++Xp;                                       /* set Xp one up     */
         if (Pd->CCut > 0) {
            cD = (struct CutDef *) Pd->CCut;
            if (cD->CutPlace == 0) {
               BCut = 1;
               pN = cD->CutPn;
            }
         }
         if (Pd->LSCut > 0) {
            cD = (struct CutDef *) Pd->LSCut;
            if (cD->CutPlace == 0) {
               BCut = 1;
               pN = cD->CutPn;
            }
         }
         if (BCut)                                      /* do cut label      */
         {                                              /* BEG TIME LABELS   */
            TimeTicks (N, Pd->Pn, 0);                   /* tick main plot    */
            TimeTicks (N, pN, Xp);                      /* cut plot          */
         }                                              /* END TIME LABELS   */
         else                                           /* no cut            */
            TimeTicks (N, Pd->Pn, Xp);                  /* time output       */
      break;                                            /* STOP TIME         */
      case 1:                                           /* START VALUE       */
        Pn = Pd->Pn;                                    /* plot number       */
        if (Type < 10) {                                /* normal plot       */
           if (Ax->DoLabs > 0)                          /* do labels?        */
              num_lab (Pn, An, 0., 0, "", Ax->NumFmt, 0, 1, 0., 0., C);
        } else {                                        /* END NORMAL LABS   */
           dY = Pd->P.dY - 1 + Pd->Gap;                 /* pixels along Y    */
           dYs = dY / Pd->EmptySrc - Pd->Gap;           /* pixels per strip  */
           Rem = dY % Pd->EmptySrc;                     /* left over pixels  */
           if (Ax->DoLabs > 0)
              DoNum = (Pd->Li[1].LocA > 3 && Pd->Li[1].LocB == 2) ? 0 : 1;
           else
              DoNum = 0; 

           Yb = (Pd->Gap == 0) ? Ax->Min + 1 : Ax->Min; /* base Y value      */ 
           Skip = Ax->NumSkip + 1;                      /* num skip param    */
           for (I = 0; I < Pd->EmptySrc; ++I) {         /* loop over sources */
               Extra = (Rem-- > 0) ? 1 : 0;             /* extra pix         */ 
               YLen = dYs + Pd->Gap + Extra;            /* len between ticks */
               Y = Yb + YLen / 2.0 + YLen % 2;          /* tick mark here    */
               dr_tic(Pn, 4, 2, Y);                     /* major Y left tick */
               dr_tic(Pn, 6, 2, Y);                     /* major Y right tic */
               if (DoNum && ((I % Skip) == 0)) {        /* number label?     */
                   sprintf (L0, "%d", I);               /* generate label    */
                   num_lab (Pn, An, Y, 0, L0, "", 0, 1, 0., 0., C); 
                }                                       /* END LABEL TICK    */

                Yb += dYs + Pd->Gap + Extra;            /* next Y base       */
            }                                           /* BEG SOURCE LOOP   */
         }                                              /* END SPEC SCA PLOT */
      break;                                            /* STOP VALUE        */
      case 2:                                           /* START SCAN        */
      case 3:                                           /* START PHI         */
      case 4:                                           /* START PITCH       */
      case 5:                                           /* START THETA       */
      case 6:                                           /* START THETA       */
      case 7:                                           /* START THETA       */
      case 8:                                           /* START CONTOUR     */
      case 9:                                           /* START ANC SCAN    */
        Pn = Pd->Pn;                                    /* plot number       */
        if (Ax->DoLabs > 0)                             /* do labels?        */
           num_lab (Pn, An, 0., 0, "", Ax->NumFmt, 0, 1, 0., 0., C);
      break;                                            /* STOP SCAN         */
   }                                                    /* END MAKE LABEL    */

   if (Pd->CCut > 0 && An != 2) {                        /* Contour Cut       */
      cD = (struct CutDef *) Pd->CCut;
      Ax = (An == 0) ? &cD->Ax : &cD->Ay;               /* axis info         */
      pN = cD->CutPn;
      if ((An == 4 && cD->CutPlace == 0) || (An == 6 && cD->CutPlace == 1) 
          || (An == 0) )
      {
         if (Ax->DoLabs > 0)
         {
            P = (cD->CutPlace) ? -90.0 : 0.0;
            num_lab (pN, An, 0., 0, "", Ax->NumFmt, 0, 1, P, 0., C);
         }
      }
   }                                                    /* END LABEL CUT     */

   if (Pd->LSCut > 0) {                                 /* LShell Cut        */
      cD = (struct CutDef *) Pd->LSCut;
      if (An == 0)
         Ax = &cD->Ax;
      else
         Ax = &cD->Ay;
      pN = cD->CutPn;
      if ((An == 4 && cD->CutPlace == 0) || (An == 6 && cD->CutPlace == 1) 
          || (An == 0) )
      {
         if (Ax->DoLabs > 0)
            num_lab (pN, An, 0., 0, "", Ax->NumFmt, 0, 1, 0., 0., C);
      }
   }                                                    /* END LABEL CUT     */
}
