#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

ByTe_1 AssemPlot (ByTe_4 PN, ByTe_4 SrcN, ByTe_1 DType, ByTe_4 sN)
{
   extern struct UserDefs InFo;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   ByTe_4   Lim[2],  N, pN;
   ByTe_1   PStat = 1;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */
   S  = (struct SrcInfo *)Pd->Src + SrcN;              /* pntr to src        */
   Lim[0] = -1;                                        /* no agv/int limits  */

   if (Pd->AData[0] == 8)                              /* Contour Data       */
      FullPolar (PN, SrcN);                            /* load arrays        */
   else {                                              /* BEG GRIDDED DATA   */
      if (DType)                                       /* BEG MATRIX SOURCE  */
         pN = ((S->OneAll == 3) && (Pd->DoSrcs == 1)) ? S->SenCN : sN;
      else                                             /* NOT MATRIX SOURCE  */
         pN = (Pd->DoSrcs == 1) ? SrcN : 0;            /* current plot       */

      for (N = 0; N < S->Col.N; ++N, ++pN) {           /* BEG COLLAPSES      */
         if (S->Col.Fmt == 0)                          /* need to avg data?  */
            S->ColD = AvgOverX (PN, SrcN, N, Lim);     /* data average       */
         else                                          /* maybe  integrate?  */
           if (S->Col.Fmt == 1)                        /* do integral?       */
              S->ColD = IntOverX (PN, SrcN, N, Lim);   /* data integrate     */

         XPix (PN, SrcN, pN, Lim);                     /* Stuff pixels       */
      }                                                /* BEG COLLAPSES      */
   }
   return (PStat);
}
