#include <stdio.h>

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_1 AdvTickTm (ByTe_1 BaseTm, ByTe_4 dMj, ByTe_4 *NextMj, ReaL_4 dMn, 
                struct TiMiNg *Tm)
{
   ByTe_4 IncMs, MnSep, DiY;
   ByTe_2 Day;
   ByTe_1 TickFmt = 3;

   MnSep = dMn;                                    /* long minor tic sep     */
   switch (BaseTm)                                 /* switch by time base    */
   {                                               /* BEG TIME BASE SWITCH   */
      case 0:                                      /* START YEAR BASE TIME   */
      break;                                       /* STOP YEAR BASE TIME    */
      case 1:                                      /* START DAY BASE TIME    */
         while (MnSep > 500) {                     /* overflow loop          */
            IncMs = 500 * 3600000;                 /* msec increment         */ 
            RollTime (Tm, 0, IncMs);               /* update time            */
            MnSep -= 500;                          /* decrement  Minor Sep   */
         }

         IncMs = MnSep * 3600000;                  /* msec increment         */ 
         if (RollTime (Tm, 0, IncMs) == *NextMj)   /* update time            */
         {                                         /* BEG MAJOR TICK TIME    */
            TickFmt = 2;                           /* set tick fmt to major  */
            *NextMj = Tm->Dy + dMj;                /* day of next mj tick    */
            DiY = LeaP(Tm->Yr);                    /* days in year           */
            if (*NextMj > DiY)                     /* in next year?          */
               *NextMj -= DiY;                     /* (Happy) New Year       */
         }                                         /* END MAJOR TICK TIME    */
      break;                                       /* STOP DAY BASE TIME     */
      case 2:                                      /* START HOUR BASE TIME   */
         IncMs = MnSep * 60000;                    /* increment msec         */ 
         Day = RollTime (Tm, 0, IncMs);            /* update time            */
         if (Tm->Ms == *NextMj)                    /* Need Major tick here?  */
         {                                         /* BEG MAJOR TICK TIME    */
            TickFmt = 2;                           /* set tick fmt to major  */
            *NextMj = Tm->Ms + dMj * 3600000.0;    /* hr of next mj tick    */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK TIME    */
      break;                                       /* STOP HR BASE TIME      */
      case 3:                                      /* START MIN BASE TIME    */
         IncMs = MnSep * 1000;                     /* increment msec         */ 
         Day = RollTime (Tm, 0, IncMs);            /* update time            */
         if (Tm->Ms == *NextMj)                    /* Need Major tick here?  */
         {                                         /* BEG MAJOR TICK TIME    */
            TickFmt = 2;                           /* set tick fmt to major  */
            *NextMj = Tm->Ms + dMj * 60000.0;      /* min of next mj tick    */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK TIME    */
      break;                                       /* STOP MIN BASE TIME     */
      case 4:                                      /* START SEC BASE TIME    */
         IncMs = MnSep;                            /* increment msec         */ 
         Day = RollTime (Tm, 0, IncMs);            /* update time            */
         if (Tm->Ms == *NextMj)                    /* Need Major tick here?  */
         {                                         /* BEG MAJOR TICK TIME    */
            TickFmt = 2;                           /* set tick fmt to major  */
            *NextMj = Tm->Ms + dMj * 1000.0;       /* sec of next mj tick    */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK TIME    */
      break;                                       /* STOP MSEC BASE TIME    */
      case 5:                                      /* START MSEC BASE TIME   */
      case 6:                                      /* START USEC BASE TIME   */
      case 7:                                      /* START NSEC BASE TIME   */
      break;                                       /* STOP SECS BASE TIME    */
   }                                               /* END TIME BASE SWITCH   */

  return (TickFmt);                                /* return the tick format */

}
