# THIS procedure installs the UDFToIDL software package.  Its separated from
#   other installs because there are version installation requirements for
#   WNDOWS and OSX also is or may become specific to its CPU.
#
# NOTE: On WINDOWS there was a change in the linking libraries at IDL version
#    6.3.  The package carries both the pre6.3 and 6.3 libraries.  Which
#    library is installed depends on the value given in IDL_VERSION
#    
#    AND now need 7.0 version also for windows.
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUudftoidlInstall { pdB } {
   global env auANS SySCmDs tcl_platform cOPTS

   upvar $pdB pI

# THIS is the option list

set oList [list CBASE CSYS CADD CSO LD_FLAGS SO_EXT LD CTYPE]

# FLAG WINDOIWS based platforms; Flags are 0 UNIX/Linus/OSX, 2 WINDOWS native,
#    1 WINDOWS/CYGWIN

   if [string match window* $tcl_platform(platform)] {
      if [string match NO $cOPTS(CYGWIN)] { set SyS 2 } else { set SyS 1 }
   } else { set SyS 0 }

# THIS is the default action list

   set dLen [llength $auANS(dOPTS)]

   set owd [pwd]

# FILL in any of the action list elements not accounted for

  set AcTioN $pI(OPT)
  set AcTioN [split $AcTioN "|"]
  set aLen [llength $AcTioN] 
  for { set I $aLen } { $I < $dLen } { incr I } {
     lappend AcTioN [lindex $auANS(dOPTS) $I]
  }

# GET all of the directories which we will need.  This consists of the
#    package base directory, the package home directory, and the directory
#    which holds the InstalledPKG file.

   set dInFo $pI(DIR)
   set diRs [split $dInFo "^"]
   set dInFo [split [lindex $diRs 0] "+"] 
   set dLen [llength $dInFo]

   set pBaSe $env([lindex $dInFo 0])
   set pHoMe $env([lindex $dInFo 0])
   set INSHOME [file join $pBaSe INSTALLED]
   if ![file exists $INSHOME] { file mkdir $INSHOME }
   for { set I 1 } { $I < $dLen } { incr I } {
      set pHoMe [file join $pHoMe [lindex $dInFo $I]] 
   }

# FORM the base package name

   set bPkg $pI(PKG).$pI(REV)

# DELETE the directories the package will create and then recreate them.  
#    This purges the old version if any was present.

   if [lindex $AcTioN 5] { 
      set LeN [llength $diRs]
      if { $LeN > 0 } {
         set suBs [split [lindex $diRs 1] "+"] 
      } else { set suBs "" }
      AUdirCntrl $pHoMe $suBs REMOVEALL 
   }
   AUdirCntrl $pHoMe "" CREATE

#  NOW install the package.  This consists of moving it to its home directory,
#     unzipping it, untarring it and then doing any needed makes or moves.

   file rename -force $bPkg.tgz [file join $pHoMe $bPkg.tgz] 

   cd $pHoMe
   exec $SySCmDs(gzip) -df $bPkg.tgz
   exec $SySCmDs(tar) xmf $bPkg.tar
   if [file exists $bPkg.tar] { file delete -force $bPkg.tar }

# CREATE the package index for the stuff in the MENU subdirectory.  All
#   OS's have this.

   pkg_mkIndex [file join $pHoMe MENU]
   
# IN a windows install its basically all done here.  This is a binary
#   install so there is no compiling and the like.  WINDOWS as of now 
#   comes in three flavors, pre6.3, 6.3, and 7.0. 6.3 covers all IDL
#   versions from 6.3 up dtp but not including 7.0.

   if { $SyS == 2 } {
      set V [string trim $env(IDL_VERSION)]
      if { $V < 6.3 } { 
         set mLiB udfpre6.3.dll 
         set rLiB [list udf6.3.dll udf6.4.dll udf7.0.dll] 
      } elseif { $V < 6.4 } { 
         set mLiB udf6.3.dll 
         set rLiB [list udf6.pre3.dll udf6.4.dll udf7.0.dll] 
      } elseif { $V < 7.0 } { 
         set mLiB udf6.4.dll 
         set rLiB [list udf6.pre3.dll udf6.3.dll udf7.0.dll] 
      } else {
         set mLiB udf7.0.dll 
         set rLiB [list udf6.pre3.dll udf6.3.dll udf6.4.dll] 
      }

# RENAME the dll for this IDL version

      file rename -force [file join $pHoMe $mLiB] [file join $pHoMe udf.dll]

# REMOVE the unused dll's

      set nD [llength rLiB]
      for { set I 0 } { $I < $nD } { incr I } {
         set rmV [lindex $rLiB $I]
         file delete -force [file join $pHoMe $rmV]
      }

# SET the tcl extension

      set tExT .tcl

   } else {

   set tExT ""

# TEMP save of the CADD.idl option
 
   if [info exists cOPTS(CADD.idl)] { set tCADD $cOPTS(CADD.idl) }

# IT appears that some versions of IDL use the header file idl_export.h
#   and some export.h.  Check to see if the first exists and if not the
#   second better.

   if [file exists [file join $env(IDL_DIR) external idl_export.h]] {
      append cOPTS(CADD.idl) " -D_IDL_EXPORT_"
      set cOPTS(CADD.idl) [string trim $cOPTS(CADD.idl)]
   } 


# FILL in any idl compile specific options
 
   set Opts ""
   set noL [llength $oList]
   for { set I 0 } { $I < $noL } { incr I } {
      set cO [lindex $oList $I].idl
      if [info exists cOPTS($cO)] {
         lappend Opts "[lindex $oList $I]|$cOPTS($cO)"
      }
   }

# REPLACE CADD
 
   if [info exists tCADD] { set cOPTS(CADD.idl) $tCADD }


# CREATE the Makefiles
 
   AUsetMakes $Opts

# Build the shared library

      catch { eval exec $auANS(MaKeS) } OuT
   } 

# MOVE the udfUnits menu

   set fN UdfUnits
   set mVF [file join $pHoMe MENU $fN]
   append fN $tExT
   set mVT [file join $pBaSe bin $fN]

   set bHoMe [file join $pBaSe bin]
   if ![file isdirectory $bHoMe] { file mkdir $bHoMe }
   file rename -force $mVF $mVT

   if ![lindex $AcTioN 6] { AUupdateDb $INSHOME pI }

   return 1
}
