# THIS procedure reads the MakeRc file to see if there are any user defined
#   compile and link options to input to the Makefile(s)

package provide AutoUpdate 1.0

proc AUreadMakeOps { } {
   global env auANS cOPTS

   set rC [file join $env(UDFTOOL_HOME) ConFigs MakeRc]
   if [catch { open $rC } fo]  { return 0 }

   set DoNe 0
   while { !$DoNe } {
      set EoF [gets $fo LiNe] 
      if { $EoF < 0 } { return 0 }
      set LiNe [string trim $LiNe] 
      set P [string first "#" $LiNe] 
      set Len [string length $LiNe] 
      if { ($P != 0) && ($Len > 0) } {
         set OpT [lindex $LiNe 0]
         if { [string compare USE_DEFINED $OpT] != 0 } {
            return 0
         } else { set DoNe 1 }
      }
   }

   while { [gets $fo LiNe] >= 0 } {
      set LiNe [string trim $LiNe] 
      set P [string first "#" $LiNe] 
      set Len [string length $LiNe] 
      if { ($P != 0) && ($Len > 0) } {
         set OpT [lindex $LiNe 0]
         set P [string first " " $LiNe] 
         incr P
         set cOPTS($OpT) [string trim [string range $LiNe $P end]]
      }
   }

   if [ catch { exec which ranlib } results ] {
   } else { set cOPTS(RL) ranlib }

   if ![info exists cOPTS(CYGWIN)] { set cOPTS(CYGWIN) NO }

   close $fo

   return 1
   
}
