# THIS procedure gets a list of all of the installed packages on the
#   system
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUinstalledPkgs { } {
   global env auANS
                                                                                
# THIS is the number of package homes that exist   

   set hLen [llength $auANS(PHMS)]

# LOOP over each of the package homes

   for { set I 0 } { $I < $hLen } { incr I } {
       set HomE [lindex $auANS(PHMS) $I]
       set pdB  [lindex $auANS(PDBS) $I]
       set auANS(ipkg,$pdB) ""
       set auANS(irev,$pdB) ""
       set auANS(idep,$pdB) ""
       set auANS(icmp,$pdB) ""
       set auANS(iopt,$pdB) ""
       set auANS(idir,$pdB) ""
      
# FIRST check to see if the package home environment variable has been set

       if ![info exists env($HomE)] { continue }

# NOW check to see if the package installed file exists

       set iName [file join $env($HomE) INSTALLED InstalledPKGS]
       if ![file exists $iName] { continue }

# LAST read the installed packages

       if [catch {open $iName r} fd ] {
           puts stderr "CANNOT OPEN $iName"
       } else {
         set PkG "" ; set ReV "" ; set DeP ""
	 set CmP "" ; set OpT "" ; set DiR ""
         while { [gets $fd LiNe] >= 0 } {
            scan $LiNe "%s %s" fN fD
            set fN [string trim $fN]
            set fD [string trim $fD]
            switch  -exact --  $fN {
               PKG { 
                  if { [string length $PkG] > 0 } {
                     lappend auANS(ipkg,$pdB) $PkG
                     lappend auANS(irev,$pdB) $ReV
                     lappend auANS(idep,$pdB) $DeP
                     lappend auANS(icmp,$pdB) $CmP
                     lappend auANS(iopt,$pdB) $OpT
                     lappend auANS(idir,$pdB) $DiR
                  }
                  set PkG $fD ; set ReV "" ; set DeP ""
	          set CmP "" ;  set OpT "" ; set DiR ""
               }
               REV  { set ReV $fD }
               DEP  { set DeP $fD }
               RCMP { set CmP $fD }
               OPT  { set OpT $fD }
               DIR  { set DiR $fD }
            }
         }
         if { [string length $PkG] > 0 } {
           lappend auANS(ipkg,$pdB) $PkG
           lappend auANS(irev,$pdB) $ReV
           lappend auANS(idep,$pdB) $DeP
           lappend auANS(icmp,$pdB) $CmP
           lappend auANS(iopt,$pdB) $OpT
           lappend auANS(idir,$pdB) $DiR
         }
      }
      close $fd
   }

# CHECK to see if the udf and gph packages have been fully installed.

   set auANS(udfIns) 1
   if { [string length $auANS(ipkg,udf)] > 0 } {
      set nP [llength $auANS(UDFPKG)]
      for { set J 0 } { $J < $nP } { incr J } {
         set pN [lindex $auANS(UDFPKG) $J]
         if { [lsearch $auANS(ipkg,udf) $pN] < 0 } {
            set auANS(udfIns) 0
            break
         }
      }
   } else { set auANS(udfIns) -1 }

   set auANS(gphIns) 1
   if { [string length $auANS(ipkg,gph)] > 0 } {
      set nP [llength $auANS(GPHPKG)]
      for { set J 0 } { $J < $nP } { incr J } {
         set pN [lindex $auANS(GPHPKG) $J]
         if { [lsearch $auANS(ipkg,gph) $pN] < 0 } {
            set auANS(gphIns) 0
            break
         }
      }
   } else { set auANS(gphIns) -1 }
}
