# THIS procedure initializes anything that needs to be set prior to starting
#   the program.
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUinits { } {
   global env auANS
                                                                                
# THIS is a listing of the package sets which can be served as well as their
#   database name on the server and the environment variable used to give 
#   their base directory

    set auANS(PKGS)   [list UDF GPH UDFTOOLS TCLTOOLS IDLTOOLS DOCS]
    set auANS(PDBS)   [list udf gph uTools   tTools   iTools   uDoc]
    set auANS(pID)    [list U   G   A        T        I        D]
    set auANS(PHMS)   [list UDF_HOME GPH_HOME UDFTOOL_HOME TCLTOOLS_HOME  \
                            IDLTOOLS_HOME UDFDOC_HOME]

    set auANS(SHOW)   [list INSTALLED OLD CURRENT NEW UPDATES]
    set auANS(UDFPKG) [list CONFIGS INCLUDES SCRIPTS LIBERRMSGS LIBBASEUDF \
                            LIBDB LIBSERVER LIBCFG LIBCFG LIBPIDF ]
    set auANS(GPHPKG) [list GINCLUDES GCTABLES GDATAFILES GANCILLARY \
                            MAINTENANCE GPRIMITIVES GPLOTTING GMAPPING G3D \
                            GCONTOUR GDRIVERS]

    set auANS(PKGPROT) [list UDFTOOLS,UDFLIBRARIAN UDFTOOLS,CLIENT \
                             TCLTOOLS,TCLCNTRL TCLTOOLS,TCLGUI]

# DEFAULT install options

    set auANS(dOPTS) [list 0 "" 0 "" 0 1 0 0]

# GET a list of the software servers that we know about

    set nS [CLserverFind software cID sIP sPort sSrc sCoM]
    if { $nS == 0 } { puts stderr "NO KNOWN SOFTWARE SERVERS" }
    set auANS(Servers) ""
    for { set I 0 } { $I < $nS } { incr I } { 
       lappend auANS(Servers) [list $cID($I) $sIP($I) $sPort($I) \
                                  $sSrc($I) $sCoM($I)] 

    }

# CHECK to see if we can use things dealing with X11
    
    if ![info exists auANS(XLIB)] {
      if [info exists env(LIBRARY_PATH)] {
         set lP [split $env(LIBRARY_PATH) ":"]
         set lN [llength $lP]
         for { set I 0 } { $I < $lN } { incr I } {
            set X11 [file join [lindex $lP $I] libX11.so]
            if [file exists $X11] { set auANS(XLIB) $X11 ; break }
            set X11 [file join [lindex $lP $I] libX11.a]
            if [file exists $X11] { set auANS(XLIB) $X11 ; break }
            set X11 [file join [lindex $lP $I] libX11.dylib]
            if [file exists $X11] { set auANS(XLIB) $X11 ; break }
            set X11 [file join [lindex $lP $I] libX11.dll.a]
            if [file exists $X11] { set auANS(XLIB) $X11 ; break }
         }
      }
   }
}
