# THIS procedure deletes and creates directories as needed.  It only
#   deletes the highest directory but creates all up to the highest

package provide AutoUpdate 1.0
                                                                                
proc AUdirCntrl { Base Subs { AcTioN CREATE } } {
   global env auANS

# THIS is the HOME directory under which any subdirectories will be found.

   set HOME $Base

# THE number of subdirectories we will be dealing with

   set sLen [llength $Subs]

# EITHER creating or deleting directories.  Could have used an if statement
#   but the switch is cleaner looking 

   switch -exact -- $AcTioN {
      CREATE { 
         if ![file isdirectory $HOME] { file mkdir $HOME }
         for { set I 0 } { $I < $sLen } { incr I } {
            set tDir [file join $HOME [lindex $Subs $I] ]
            if ![file isdirectory $tDir] { file mkdir $tDir }
         }
      }
      REMOVESUBS { 
         for { set I 0 } { $I < $sLen } { incr I } {
            set tDir [file join $HOME [lindex $Subs $I] ]
            if [file isdirectory $tDir] { file delete -force $tDir } 
         }
      }
      REMOVEALL { 
         for { set I 0 } { $I < $sLen } { incr I } {
            set tDir [file join $HOME [lindex $Subs $I] ]
            if [file isdirectory $tDir] { file delete -force $tDir } 
         }
         if [file isdirectory $HOME] { file delete -force $HOME }
      }
   }
}
