# THIS procedure compares the local and server packages and outputs those
#   packages which match the selected criteria
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUshowStatus { W pN } {
   global env auANS
                                                                                
# CHECK to see is there is any information for this package.  There needs
#   to be a non-empty package manifest obtained from the server any entries
#   to possibly be placed in the action list

   set dB  [lindex $auANS(PDBS) $pN]
   set pId [lindex $auANS(PKGS) $pN]
   if ![info exists auANS(dbpkg,$dB)] { return }
   set nPkgs [llength $auANS(dbpkg,$dB)]
   if { $nPkgs  == 0 } { return }

   set PkG ""
   set iRev ""
   set dbRev ""

   set nOpts [llength $auANS(SHOW)]
   for { set I 0 } { $I < $nPkgs } { incr I } {
      set pName [lindex $auANS(dbpkg,$dB) $I]
      set dbRv  [lindex $auANS(dbrev,$dB) $I]
      set Pos [lsearch $auANS(ipkg,$dB) $pName]
      for { set J 0 } { $J < $nOpts } { incr J } {
         set Opt [lindex $auANS(SHOW) $J] 
         if { $auANS(sh,$Opt) == 0 } { continue }
         switch -exact -- $Opt {
            OLD {
               if { $Pos >= 0 } {
                  set iRv  [lindex $auANS(irev,$dB) $Pos]
                  if { [AUrevCmp $dbRv $iRv] < 0 } {
                     lappend PkG $pName
                     lappend dbReV $dbRv
                     lappend iReV $iRv
                  }
               }
            }
            CURRENT {
               if { $Pos >= 0 } {
                  set iRv  [lindex $auANS(irev,$dB) $Pos]
                  if { [AUrevCmp $dbRv $iRv] == 0 } {
                     lappend PkG $pName
                     lappend dbReV $dbRv
                     lappend iReV $iRv
                  }
               }
            }
            NEW {
               if { $Pos < 0 } {
                  lappend PkG $pName
                  lappend dbReV $dbRv
                  lappend iReV -----
               }
            }
            UPDATES {
               if { $Pos >= 0 } {
                  set iRv  [lindex $auANS(irev,$dB) $Pos]
                  if { [AUrevCmp $dbRv $iRv] > 0 } {
                     lappend PkG $pName
                     lappend dbReV $dbRv
                     lappend iReV $iRv
                  }
               }
            }
         }
      }
   }

   set nE [llength $PkG]
   set Fmt "%-10s%-14s%11s%11s"
   set nPkgs [llength $PkG]
   for { set I 0 } { $I < $nPkgs } { incr I } {
      $W insert end [format $Fmt $pId [lindex $PkG $I] [lindex $iReV $I] \
                                 [lindex $dbReV $I] ]
   }
}
