# THIS procedure installs a software package.  There are a number of options
#   to give it some generality.  The inputs include
#
#  pdB    - The database entry that came with the package.  What is used
#              from that array is"
#
#    pdB(DIR) - The directory information.  This is a listing of all of the
#               the directories which are used in this install.  The format
#               is A+B+C+D^E+F
#               where:
#                  A is the Home base package directory and is the environment
#                    variable from which is it derived (eg UDF_HOME)
#                  B,C,D are the directories needed to make up the package 
#                    directory. D is the directory in which the package is
#                    unpacked.
#                  E,F are any directories under D which need to be removed
#                    in the deinstall process.  Most notably this would be
#                    the C-Code directories under some of the Tcl packages
#
#   pdB(PKG)  - The package name (less the version-revision-.tar info)
#   pdB(REV)  - The package revision 
#   pbB(OPT)  - A list which describes what needs to be done. Elements are
#              (0)  1 if a .a make needs be done; 2 if a .so make else 0 
#              (1)  name of program to link if an executable is built; else ""
#              (2)  1 if a release is done; 0 otherwise
#              (3)  List of any files to move to the bin directory under pBaSe 
#                   Multiple files are separated by +'s
#              (4)  1 if a pkgIndex needs to be done
#              (5)  1 if purge the home directory; 0 otherwise
#              (6)  1 no overwrite of existing package (also no InstalledPKGS 
#                   update)
#              (7)  0 if no AUpkgSpecial, 1 if AUpkgSpecial pre Make, 
#                   2 if AUpkgSpecial post Make, 
#              (8)  if extensions need to be added to moved files on a windows
#                   platform add them there - one per file. Multiple extensions
#                   are separated by + and ++ is no extension. 
#                  
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUpkgInstall { pdB } {
   global env auANS SySCmDs tcl_platform cOPTS

   upvar $pdB pI

# FLAG WINDOIWS based platforms; Flags are 0 UNIX/Linus/OSX, 2 WINDOWS native,
#    1 WINDOWS/CYGWIN

   if [string match window* $tcl_platform(platform)] {
      if [string match NO $cOPTS(CYGWIN)] { set SyS 2 } else { set SyS 1 }
   } else { set SyS 0 }
   
# BUILD the makes

   AUsetMakes

# THIS is the default action list

   set dLen [llength $auANS(dOPTS)]

   set owd [pwd]

# FILL in any of the action list elements not accounted for

  set AcTioN $pI(OPT)
  set AcTioN [split $AcTioN "|"]
  set aLen [llength $AcTioN] 
  for { set I $aLen } { $I < $dLen } { incr I } {
     lappend AcTioN [lindex $auANS(dOPTS) $I]
  }

# GET all of the directories which we will need.  This consists of the
#    package base directory, the package home directory, and the directory
#    which holds the InstalledPKG file.

   set dInFo $pI(DIR)
   set diRs [split $dInFo "^"]
   set dInFo [split [lindex $diRs 0] "+"] 
   set dLen [llength $dInFo]

   set pBaSe $env([lindex $dInFo 0])
   set pHoMe $env([lindex $dInFo 0])
   set INSHOME [file join $pBaSe INSTALLED]
   if ![file exists $INSHOME] { file mkdir $INSHOME }
   for { set I 1 } { $I < $dLen } { incr I } {
      set pHoMe [file join $pHoMe [lindex $dInFo $I]] 
   }

# FORM the base package name

   set bPkg $pI(PKG).$pI(REV)

# DELETE the directories the package will create and then recreate them.  
#    This purges the old version if any was present.

   if [lindex $AcTioN 5] { 
      set LeN [llength $diRs]
      if { $LeN > 0 } {
         set suBs [split [lindex $diRs 1] "+"] 
      } else { set suBs "" }
      AUdirCntrl $pHoMe $suBs REMOVEALL
   }
   AUdirCntrl $pHoMe "" CREATE

#  NOW install the package.  This consists of moving it to its home directory,
#     unzipping it, untarring it and then doing any needed makes or moves.

   file rename -force $bPkg.tgz [file join $pHoMe $bPkg.tgz] 

   cd $pHoMe
   exec $SySCmDs(gzip) -df $bPkg.tgz
   exec $SySCmDs(tar) xmf $bPkg.tar
   if [file exists $bPkg.tar] { file delete -force $bPkg.tar }

   if { [lindex $AcTioN 7] == 1 } { AUpkgSpecial $pI(PKG) } 

# IF this is a native WINDOWS install then there is no compiling and linking
#   to be done no matter what the action flags say.  

   if { $SyS < 2 } {
      if { [lindex $AcTioN 0] > 0 } { 
         if { [lindex $AcTioN 0] == 1 }  { 
            catch { eval exec $auANS(MaKe) } OuT
         } else { catch { eval exec $auANS(MaKeS) } OuT}
      }

      if { [string length [lindex $AcTioN 1]] > 0 } { 
         set MaKeE $auANS(MaKeE)
         if { [string length [lindex $AcTioN 1]] > 0 } {
            lappend MaKeE [lindex $AcTioN 1]
         }
         catch { eval exec $MaKeE }
      }
   }

   if [lindex $AcTioN 2] { catch { eval exec $auANS(MaKeR) } }

   cd $owd
   set mvThese [split [lindex $AcTioN 3] "+"]
   set mvExT [split [lindex $AcTioN 8] "+"]
   set mLen [llength $mvThese]
   set eLen [llength $mvExT]
   if { $mLen > 0 } {
      for { set I 0 } { $I < $mLen } { incr I } {
         set mVF [lindex $mvThese $I]
         if { [llength [split $mVF ":"]] == 1 } {
             set bHoMe [file join $pBaSe bin]
             set Mv $mVF
         } else {
             set bHoMe [file join $env([lindex [split $mVF ":"] 0]) bin]
             set Mv [lindex [split $mVF ":"] 1]
         }

         if { ($eLen > 0) && ($SyS == 2) } {
            set ExT [lindex $mvExT $I]
            if { [string length $ExT] > 0 } { 
               set MvA $Mv.$ExT 
            } else { set MvA $Mv }
         } else { set MvA $Mv }

         if ![file isdirectory $bHoMe] { file mkdir $bHoMe }
         file rename -force [file join $pHoMe $Mv] [file join $bHoMe $MvA]
      }
   }

   if { [lindex $AcTioN 7] == 2 } { AUpkgSpecial $pI(PKG) } 

   if [lindex $AcTioN 4] { pkg_mkIndex $pHoMe }

   if ![lindex $AcTioN 6] { AUupdateDb $INSHOME pI }
   return 1
}
