# THIS procedure reads the local package list file.  This provides a local
#   source of the packages that are known to be updatable
#
# OUTPUTS:
#   dBEntries - the software database entries.  This is an array variable.
#               Each array element is a list of the database entries for
#               one of the database entry fields
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUguiFrontEnd { } {
   global env auANS
                                                                                
# READ in the preference file

   GUIprefsRead

# READ in the known package list.  This is a listing of packages and of the
#   corresponding database name for the package.

   set pLen [llength $auANS(PKGS)]
   if { $pLen == 0 } {
      puts stderr "NO KNOWN SOFTWARE PACKAGES"
      exit
   }
  
# LAY out the window names for the GUI frame structure

   set W   .uPCntrl

   if { [winfo exists $W] == 0 } {
      wm title . "UDF UPDATE FRONTEND MENU"

      set Wa .uPBase
      set Wu .uServer
      set WaP $Wa.pkgs
      set WaO $Wa.opts
      set WaD $Wa.dspl

      GUIFrame $W  -1 grid|0|0|news||3
      GUIFrame $Wu -1 grid|1|0|news||3
      GUIFrame $Wa -1 grid|2|0|news||3
      GUIFrame $WaP -1 grid|0|0|n
      GUIFrame $WaO -1 grid|0|1|n
      GUIFrame $WaD -1 grid|0|2|n
      
      set auANS(sNum) 0
      set sI [lindex $auANS(Servers) 0]
      set sLab "CURRENT SERVER: [lindex $sI 1] ([lindex $sI 4])"

      set nS [llength $auANS(Servers)] 
      set sOpts ""
      for { set I 0 } { $I < $nS } { incr I } {
         set sI [lindex $auANS(Servers) $I]
         lappend sOpts "[lindex $sI 1] ([lindex $sI 4])"
      }

      GUIbuttonPush $W.quit QUIT pack|right "exit"  6
      GUIbuttonPush $W.request REQUEST pack|left "AUreqPkgStatus"  6
      GUIbuttonPush $W.provide INSTALL pack|left "AUpkgProvide $WaD.a1"  6
      GUIbuttonPush $W.nuke DEINSTALL pack|left "AUpkgNuke $WaD.a1"  6
      GUIstateSet $W.nuke PBUTTON disabled
      GUIbuttonMenu $W.csrv "CHANGE SERVER" pack|right $sOpts \
              "AUchgServer " 6 -16
      if { $nS == 1 } { GUIstateSet $W.csrv MBUTTON disabled }

      GUILabel $Wu.slab $sLab  c grid|0|0|news 0 -1 "" [list times 12 bold]

      GUILabel $WaP.lpkg PACKAGES c grid|0|0|news 0 10 "" [list times 12 bold]
      for { set I 0 ; set RoW 1 } { $I < $pLen } { incr I ; incr RoW } {
         set pN [lindex $auANS(PKGS) $I] 
         set auANS(db,$pN) 0
         GUIbuttonCheck $WaP.cb$RoW $pN grid|$RoW|0 auANS(db,$pN) "" 0 11
      } 

      GUILabel $WaO.spkg SHOW c grid|0|0|news 0 10 "" [list times 12 bold]
      set sLen [llength $auANS(SHOW)]
      for { set I 0 ; set RoW 1 } { $I < $sLen } { incr I ; incr RoW } {
         set sName [lindex $auANS(SHOW) $I] 
         set auANS(sh,$sName) 0
         GUIbuttonCheck $WaO.cb$RoW $sName grid|$RoW|0 auANS(sh,$sName) "" 0 11
      } 

      set LaB "PKG       ELEMENT         INSTALLED    DATABASE"
      GUILabel $WaD.la1 "" c grid|0|0|
      GUILabel $WaD.la2 $LaB  w grid|1|0|
      $WaD.la2 configure -font [list fixed]
      GUIboxList $WaD.a1 47 10 grid|2|0 "" multiple 0 1
      $WaD.a1 configure -font [list fixed]
   }
}
