# THIS procedure allows a user to set an unset environment variable
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUenvSet { pName envVar } {
   global env EnVSeT
                                                                                
   if [info exists EnVSeT] { unset EnVSeT }

# LAY out the popup window

   set W .popUp

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "SET ENVIRONMENT VARAIBLE"

      set Wa $W.top
      set Wb $W.mid
      set Wc $W.bot

      GUIFrame $Wa  -1 pack|top||both
      GUIFrame $Wb  -1 pack|top||both
      GUIFrame $Wc  -1 pack|top||both|true
      
      GUIbuttonPush $Wa.set CONTINUE pack|left "set EnVSeT 1 ; destroy $W"  6
      GUILabel $Wa.lab "SET ENVIRONMENT VARIABLE" c pack|left|center|x|true \
                         0 -1 "" [list times 12 bold]
      GUIbuttonPush $Wa.abort ABORT pack|right \
                           "unset env($envVar) ; set EnVSeT 1 ; destroy $W"  6

      GUIboxText $Wb.text 50 9 grid|0|0 0 0 [list courier 12]
      GUILabel $Wc.lab $envVar l grid|0|0|w 0 0 "" [list courier 12 bold]
      GUIboxEntry $Wc.text grid|1|0|w 50 env($envVar)

      $Wb.text configure -wrap word

      $Wb.text tag configure rTexT -foreground #ff0000
      $Wb.text tag configure bold -font {courier 12 bold}
      $Wb.text tag configure normal -font {courier 12}
      set TexTa " of the package " 
      set TexTb " requires the environment varaible "
      set TexTc " be set.  You can set it temporarily here and continue the\
                  installation or you can abort the installation.  Click\
                  CONTINUE after the environment has been set.\n\n"
      set TexTd "REMEMBER to permanently set the environment variable after\
                 AutoUpdate has completed."
      $Wb.text insert end "Installation" bold 
      $Wb.text insert end $TexTa normal 
      $Wb.text insert end $pName bold 
      $Wb.text insert end $TexTb normal 
      $Wb.text insert end $envVar bold 
      $Wb.text insert end $TexTc normal 
      $Wb.text insert end $TexTd rTexT 
   }
}
