# THIS procedure updates the local package database file.  If there is an
#   existing package database we will read the contents of it an rewrite
#   them into a temporary file.  If the package being installed is one
#   of the entries that entry will be disgarded in favor of the newly
#   obtained database entry.  The temporary file is then copied back to the
#   original package database file.  If no package database file exists this
#   will create it and put the current entry into it.

package provide AutoUpdate 1.0

proc AUupdateDb { HoMe pdB { Delete 0 }  } {

  upvar $pdB pI

# IF there is a package database open it to read otherwise to wite.

   set iName [file join $HoMe InstalledPKGS]
   if [file exists $iName] { set openAs r } else { set openAs w }
   if [catch {open $iName $openAs } fo]  {
     puts stderr "UNABLE to open or create InstalledPKGS file"
     return 0
   }

# GET the current time
                                                                                
   set TiMe [clock format [clock seconds] -format %Y%m%d]

# WE need to get a list of the database entries to be added and we need to
#   know the position of the PKG entry in that list since it needs to be the
#   first entry for that package.

   set dbN [array names pI]
   set pP [lsearch $dbN PKG]

# NUMBER of fields in the database entry

   set nE [array size pI]

# SWITCH depending if we are adding to an existing database or creating a
#   a new one.

   if [string match r $openAs] {

      set tName [file join $HoMe ._TmP]
      if [catch {open $tName w} fi]  {
         puts stderr "UNABLE to create Temporary file $tName"
         return 0
      }

# READ through the database copying its contents over to the temporary file.
#   If there is an entry for the current package substitute the current 
#   database entry for it.

      set Entered 0
      set IgN 0
      while { [gets $fo LiNe] > 0 } {
         scan $LiNe "%s %s" fN fD
         set fN [string trim $fN]
         set fD [string trim $fD]
         if [string match PKG $fN] {
            set IgN 0
            if { [string compare $fD $pI(PKG)] == 0 } {
               set IgN 1
               set Entered 1
               set pP [lsearch $dbN PKG]
	       if !$Delete {
                  puts $fi "[lindex $dbN $pP]  $pI([lindex $dbN $pP])"
                  for { set I 0 } { $I < $nE } { incr I } {
                     if { $I != $pP } {
                        puts $fi "[lindex $dbN $I]   $pI([lindex $dbN $I])"
                     }
                  }
                  puts $fi "TIME   $TiMe"
               }
            } else { puts $fi "$fN   $fD" }
         } else { 
            if { !$IgN } { puts $fi "$fN   $fD" }
         }
      }

      if !$Entered { 
         puts $fi "[lindex $dbN $pP]  $pI([lindex $dbN $pP])"
         for { set I 0 } { $I < $nE } { incr I } {
            if { $I != $pP } {
               puts $fi "[lindex $dbN $I]   $pI([lindex $dbN $I])"
            }
         }
         puts $fi "TIME   $TiMe"
      }
      close $fi
      close $fo
      file rename -force $tName $iName
   } else {
      set nE [array size pI]
      puts $fo "[lindex $dbN $pP]  $pI([lindex $dbN $pP])"
      for { set I 0 } { $I < $nE } { incr I } {
         if { $I != $pP } {
            puts $fo "[lindex $dbN $I]   $pI([lindex $dbN $I])"
         }
      }
      puts $fo "TIME   $TiMe"
      close $fo
   }

   AUinstalledPkgs

   return 1
}
