# THIS procedure sets up items which depend on the local system such as
#   the make inputs.
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUsysDeps { } {
   global env auANS cOPTS tcl_platform

# THIS is the operating system Change it to lowercase so we don't 
#     have to worry about what's capitalized.
 
   set oS [string tolower $tcl_platform(os)]

# OPEN the MakeRc file.  Try the one in the ConFigs area first and if
#    there is nothing there fallback to the one in the UDFLibrarian 
#    directory.
 
   set rC [file join $env(UDFTOOL_HOME) ConFigs MakeRcNew]
   if ![file exists $rC] {
      set rC [file join $env(UDFTOOL_HOME) UDFLibrarian MakeRc]
   }

   if [catch { open $rC } fo]  { 
      puts stderr "Can't open MakeRc"
      return 0 
   }

# SEARCH for the start of an information block.
 
   set OS 0
	    set DD 0
   set EOF [gets $fo LiNe]
   while { ($EOF >= 0) } {
      if [AUparseLine $LiNe oP fD] {  
	 if [string match BEGIN $oP] {
	    set Apnd ""
            set fD [string tolower $fD]
	    if [string match $oS [lindex $fD 0]] { 
	       set Fill 1 
	       incr OS
	    } elseif [string match default $fD] { 
	       set Fill 1 
	       set Apnd ".def" 
	    } else { set Fill 0 }

	    AUparseBlock $fo $Fill $Apnd
            set EOF [gets $fo LiNe]
         } else { set EOF [gets $fo LiNe] }
      } else { set EOF [gets $fo LiNe] }
   }
   close $fo

   if { $OS == 0 } { puts stderr "Unknown Operating System $oS" }

   return 1
}

proc AUparseLine { LiNe OpT Field } {
   upvar $OpT F1
   upvar $Field F2

   set rV 0 

   set LiNe [string trim $LiNe] 
   set P [string first "#" $LiNe] 
   if { ($P != 0) && ([string length $LiNe] > 0) } {
      set F1 [string trim [lindex $LiNe 0]]
      set P [string first " " $LiNe] 
      set F2 [string trim [string range $LiNe $P end]]
      set rV 1
   }

   return $rV
}

proc AUparseBlock { fo Fill exT } {
   global cOPTS

   set OK 1
   set EOF [gets $fo LiNe]
   while { ($EOF >= 0) && $OK } {
      if [AUparseLine $LiNe OpT Field] {
         if ![string match END $OpT] {
	    set IdX $OpT$exT
            if $Fill { set cOPTS($IdX) $Field } 
            set EOF [gets $fo LiNe]
         } else { set OK 0 }
      } else { set EOF [gets $fo LiNe] }
   }
}
