# THIS procedure reads the UDFrc to get all of the UDF user parameters

package provide AutoUpdate 1.0

proc AUreadUDFrc { PgM uDFRc } {
   global env

   upvar $uDFRc uR

# READ the system wide file should one exist.

   set rC [file join $env(UDFTOOL_HOME) ConFigs UDFrc]
   if ![catch { open $rC } fo]  { 
      while { [gets $fo LiNe] >= 0 } {
         set LiNe [string trim $LiNe] 
         set P [string first "#" $LiNe] 
         set Len [string length $LiNe] 
         if { ($P != 0) && ($Len > 0) } {
            set FlD [split [lindex $LiNe 0] ":"]
            if { [llength $FlD] < 2 } {
               set P [expr [string first " " $LiNe] + 1] 
               set I [string trim [lindex $FlD 0]]
               set uR($I) [string trim [string range $LiNe $P end]]
            } else {
               if { [string compare $PgM [lindex $FlD 0]] == 0 } {
                  set P [expr [string first " " $LiNe] + 1] 
                  set I [lindex $FlD 1]
                  set uR($I) [string trim [string range $LiNe $P end]]
               }
            }
         }
      }
      close $fo
   } 

# READ the personal file should one exist.  Any options set here overwrite
#    the system wide ones.

   set Home [glob ~/ ]
   set rC [file join $Home .UDFrc]
   if ![catch { open $rC } fo]  { 
      while { [gets $fo LiNe] >= 0 } {
         set LiNe [string trim $LiNe] 
         set P [string first "#" $LiNe] 
         set Len [string length $LiNe] 
         if { ($P != 0) && ($Len > 0) } {
            set FlD [split [lindex $LiNe 0] ":"]
            if { [llength $FlD] < 2 } {
               set P [expr [string first " " $LiNe] + 1] 
               set I [string trim [lindex $FlD 0]]
               set uR($I) [string trim [string range $LiNe $P end]]
            } else {
               if { [string compare $PgM [lindex $FlD 0]] == 0 } {
                  set P [expr [string first " " $LiNe] + 1] 
                  set I [lindex $FlD 1]
                  set uR($I) [string trim [string range $LiNe $P end]]
               }
            }
         }
      }
      close $fo
   }
}
