# THIS procedure reads a package database entry
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUreadPdB { dBName dBEntries rM } {
   global env auANS EnVSeL SySCmDs

   upvar $dBEntries pI

# READ the database entry.  This has where is package needs to be put
#   as well as its install options and dependencies

   if [catch {open $dBName.dbe r} fd ] {
      set Status 0
   } else {
      set Status 1
      if [info exists pI] { unset pI }
      while { [gets $fd LiNe] >= 0 } {
         scan $LiNe "%s %s" FlD Val
         set FlD [string trim $FlD]
         set Val [string trim $Val]
         set pI($FlD) $Val
      }
      close $fd 
   }

   if $rM {
      if [file exists $dBName.dbe] { file delete -force $dBName.dbe }
   }

# LOOK at the package install options and makes sure that they are
#   all there.  If not put in defaults for the missing ones.

   set OptDef [list 0 "" 0 "" 0 1 0 0 ""]
   set nO [llength $OptDef]
   for { set I [llength [split $pI(OPT) "|"] ] } { $I < $nO } { incr I } {
       append pI(OPT) "|[lindex $OptDef $I]"
   }

   return $Status
}
